/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.WordNetInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class APFAnalyzer {
    static String encoding = "ISO-8859-1";
    static HashMap startTag;
    static HashSet endTag;
    static DocumentBuilder builder;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire.txt";
    static int identityCount;
    static int synonymCount;
    static int differentCount;
    static ArrayList mentionTypes;
    static ArrayList mentionTexts;
    static ArrayList headTexts;
    static int[] ACEoffsetMap;
    static int[] JEToffsetMap;
    static HashMap standardType;

    public static void main(String[] stringArray) throws Exception {
        String string;
        WordNetInterface.initialize();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        builder = documentBuilderFactory.newDocumentBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string);
            String string2 = ACEdir + string + ".sgm";
            boolean bl = fileList.indexOf("03") > 0;
            String string3 = ACEdir + string + (bl ? ".apf.xml" : ".sgm.tmx.rdc.xml");
            APFAnalyzer.analyzeDocument(string2, string3);
        }
        APFAnalyzer.report();
    }

    private static void analyzeDocument(String string, String string2) throws SAXException, IOException {
        Document document = builder.parse(string2);
        StringBuffer stringBuffer = APFAnalyzer.readDocument(string);
        APFAnalyzer.computeOffsets(stringBuffer);
        APFAnalyzer.findEntityMentions(document, stringBuffer);
    }

    static void findEntityMentions(Document document, StringBuffer stringBuffer) {
        APFAnalyzer.clearMentionTables();
        NodeList nodeList = document.getElementsByTagName("entity");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("ID");
            NodeList nodeList2 = element.getElementsByTagName("entity_type");
            Element element2 = (Element)nodeList2.item(0);
            String string2 = element2.getAttribute("GENERIC");
            if (string2.equals("TRUE")) continue;
            String string3 = APFAnalyzer.getElementText(element, "entity_type");
            if (standardType.containsKey(string3)) {
                string3 = (String)standardType.get(string3);
            }
            NodeList nodeList3 = element.getElementsByTagName("entity_mention");
            APFAnalyzer.clearMentionTables();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Element element3 = (Element)nodeList3.item(j);
                String string4 = element3.getAttribute("ID");
                String string5 = element3.getAttribute("TYPE");
                NodeList nodeList4 = element3.getElementsByTagName("extent");
                Element element4 = (Element)nodeList4.item(0);
                String string6 = APFAnalyzer.getElementText(element4, "start");
                int n = Integer.parseInt(string6);
                int n2 = JEToffsetMap[n];
                String string7 = APFAnalyzer.getElementText(element4, "end");
                int n3 = Integer.parseInt(string7);
                int n4 = JEToffsetMap[n3];
                String string8 = stringBuffer.substring(n2, n4 + 1);
                NodeList nodeList5 = element3.getElementsByTagName("head");
                Element element5 = (Element)nodeList5.item(0);
                String string9 = APFAnalyzer.getElementText(element5, "start");
                int n5 = Integer.parseInt(string9);
                int n6 = JEToffsetMap[n5];
                String string10 = APFAnalyzer.getElementText(element5, "end");
                int n7 = Integer.parseInt(string10);
                int n8 = JEToffsetMap[n7];
                String string11 = stringBuffer.substring(n6, n8 + 1);
                APFAnalyzer.addMention(string5, string8, string11);
            }
            APFAnalyzer.analyzeMentions(string3);
        }
    }

    private static String getElementText(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        Element element2 = (Element)nodeList.item(0);
        String string2 = element2.getFirstChild().getNodeValue();
        return string2;
    }

    private static void clearMentionTables() {
        mentionTypes.clear();
        mentionTexts.clear();
        headTexts.clear();
    }

    private static void addMention(String string, String string2, String string3) {
        mentionTypes.add(string);
        mentionTexts.add(string2);
        headTexts.add(string3);
    }

    private static void analyzeMentions(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < mentionTexts.size(); ++i) {
            String string2 = (String)mentionTypes.get(i);
            String string3 = ((String)headTexts.get(i)).toLowerCase();
            if (!string2.equals("NOMINAL")) continue;
            if (!hashSet.isEmpty()) {
                if (hashSet.contains(string3)) {
                    ++identityCount;
                } else if (WordNetInterface.containsSynonym(hashSet, string3)) {
                    ++synonymCount;
                } else {
                    System.out.println("different heads: " + string3 + " and " + hashSet);
                    ++differentCount;
                }
            }
            hashSet.add(string3);
        }
    }

    private static void report() {
        System.out.println(identityCount + " same head pairs");
        System.out.println(synonymCount + " synonymous head pairs");
        System.out.println(differentCount + " different head pairs");
    }

    static StringBuffer readDocument(String string) throws IOException {
        String string2;
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer;
    }

    static void computeOffsets(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = 0;
        int n2 = stringBuffer.length();
        ACEoffsetMap = new int[n2];
        JEToffsetMap = new int[n2];
        for (int i = 0; i < n2; ++i) {
            if (stringBuffer.charAt(i) == '<') {
                bl = true;
            }
            APFAnalyzer.JEToffsetMap[i - n] = i;
            if (bl) {
                ++n;
            }
            APFAnalyzer.ACEoffsetMap[i] = i - n;
            if (stringBuffer.charAt(i) != '>') continue;
            bl = false;
        }
    }

    static {
        identityCount = 0;
        synonymCount = 0;
        differentCount = 0;
        mentionTypes = new ArrayList();
        mentionTexts = new ArrayList();
        headTexts = new ArrayList();
        ACEoffsetMap = null;
        JEToffsetMap = null;
        standardType = new HashMap();
        standardType.put("GSP", "GPE");
        standardType.put("PER", "PERSON");
        standardType.put("ORG", "ORGANIZATION");
        standardType.put("LOC", "LOCATION");
        standardType.put("FAC", "FACILITY");
    }
}

