/*
 * Decompiled with CFR 0.152.
 */
package Jet.Scorer;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SGMLScorer {
    public Document doc1;
    public Document doc2;
    public Vector mismatch1 = new Vector();
    public Vector mismatch2 = new Vector();
    public int numOfTagsInDoc1 = 0;
    public int numOfTagsInDoc2 = 0;
    public int numOfMatchingTags = 0;
    public int numOfMatchingAttrs = 0;
    public int totalTagsInDoc1 = 0;
    public int totalTagsInDoc2 = 0;
    public int totalMatchingTags = 0;
    public int totalMatchingAttrs = 0;
    String lastTypeMatched = "";
    boolean ignorePeriods = false;

    public SGMLScorer(Document document, Document document2) {
        this.doc1 = document;
        this.doc2 = document2;
    }

    public void match(String string) {
        this.match(string, string);
    }

    public void match(String string, String string2) {
        this.numOfTagsInDoc1 = 0;
        this.numOfTagsInDoc2 = 0;
        this.numOfMatchingTags = 0;
        this.numOfMatchingAttrs = 0;
        this.lastTypeMatched = string2;
        Annotation annotation = null;
        Annotation annotation2 = null;
        Vector vector = this.doc1.annotationsOfType(string);
        HashMap hashMap = this.annotationMap(this.doc2.annotationsOfType(string2), this.doc2);
        HashMap hashMap2 = this.annotationMap(this.doc1.annotationsOfType(string), this.doc1);
        HashMap hashMap3 = this.annotationMap(this.doc2.annotationsOfType(string2), this.doc2);
        if (vector != null && hashMap != null) {
            int n = vector.size();
            int n2 = hashMap.size();
            this.numOfTagsInDoc1 = n;
            this.numOfTagsInDoc2 = n2;
            for (int i = 0; i < n; ++i) {
                annotation = (Annotation)vector.get(i);
                Long l = this.annotationKey(annotation, this.doc1);
                annotation2 = (Annotation)hashMap.get(l);
                if (annotation2 == null) continue;
                ++this.numOfMatchingTags;
                Object object = annotation.get("TYPE");
                Object object2 = annotation2.get("TYPE");
                Object object3 = annotation.get("CAT");
                Object object4 = annotation2.get("CAT");
                if ((object == null ? object2 == null : object.equals(object2)) && (object3 == null ? object4 == null : object3.equals(object4))) {
                    ++this.numOfMatchingAttrs;
                    hashMap2.remove(l);
                    hashMap3.remove(l);
                }
                hashMap.remove(l);
                --n2;
            }
        }
        if (hashMap2 != null) {
            this.mismatch1.addAll(hashMap2.values());
        }
        if (hashMap3 != null) {
            Iterator iterator = hashMap3.values().iterator();
            while (iterator.hasNext()) {
                Annotation annotation3 = (Annotation)iterator.next();
                Object object = annotation3.get("STATUS");
                if (object != null && object.equals("OPT")) {
                    --this.numOfTagsInDoc2;
                    continue;
                }
                this.mismatch2.add(annotation3);
            }
        }
        this.totalTagsInDoc1 += this.numOfTagsInDoc1;
        this.totalTagsInDoc2 += this.numOfTagsInDoc2;
        this.totalMatchingTags += this.numOfMatchingTags;
        this.totalMatchingAttrs += this.numOfMatchingAttrs;
    }

    public String report() {
        return "For " + this.lastTypeMatched + ", " + "# of matching tags = " + this.numOfMatchingTags + "    # of tags in response = " + this.numOfTagsInDoc1 + "    # of tags in key = " + this.numOfTagsInDoc2 + "    # with matching attributes = " + this.numOfMatchingAttrs;
    }

    private HashMap annotationMap(Vector vector, Document document) {
        if (vector == null) {
            return null;
        }
        HashMap<Long, Annotation> hashMap = new HashMap<Long, Annotation>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Long l = this.annotationKey(annotation, document);
            if (hashMap.containsKey(l)) {
                System.out.println("Duplicate annotation " + annotation);
            }
            hashMap.put(l, annotation);
        }
        return hashMap;
    }

    private Long annotationKey(Annotation annotation, Document document) {
        int n;
        long l = annotation.span().start();
        long l2 = annotation.span().end();
        if (this.ignorePeriods && (n = annotation.span().endNoWS(document)) > 1 && document.charAt(n - 1) == '.') {
            l2 = n - 1;
        }
        return new Long(l * 1000000000L + l2);
    }
}

