/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.EDTtype;
import AceJet.Gazetteer;
import AceJet.WordNetInterface;
import Jet.Console;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.AddSyntacticRelations;
import Jet.Parser.StatParser;
import Jet.Parser.SynFun;
import Jet.Refres.Hobbs;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public class RefresBuildTrain {
    static boolean train = false;
    static boolean test;
    static boolean trace;
    static final int testDocs = 25;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire.txt";
    static final String parseCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parses/training nwire parses.txt";
    static final String featureFile = "C:/Documents and Settings/Ralph Grishman/My Documents/jet temp/coref features.txt";
    static final String modelFile = "C:/Documents and Settings/Ralph Grishman/My Documents/jet temp/coref model.txt";
    static PrintStream writer;
    static final int sharedFeatures = 2;
    static GISModel model;
    static int correct;
    static int incorrect;
    static Vector entities;
    static HashMap headToEntityMap;
    static HashMap syntacticAntecedent;
    static HashMap mentionToEntity;
    private static final String[] indefiniteDets;
    private static String[] singularPronouns;
    private static String[] pluralPronouns;
    private static String[] humanPronouns;
    private static String[] nonHumanPronouns;
    private static String[] firstSecondPronouns;
    private static String[] thirdPronouns;
    private static HashMap nominative;
    private static int[] sentenceBoundaries;
    private static Vector sentences;

    public static void main(String[] stringArray) throws IOException {
        String string;
        Resolve.trace = false;
        WordNetInterface.initialize();
        EDTtype.readTypeDict();
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("C:/Documents and Settings/Ralph Grishman/My Documents/newjet/jet/data/loc.dict");
        if (train) {
            writer = new PrintStream(new FileOutputStream(featureFile));
        } else {
            RefresBuildTrain.loadModel(modelFile);
        }
        test = !train;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (train && ++n < 25 || !train && n >= 25) continue;
            System.out.println("\nProcessing document " + n + ": " + string);
            String string2 = ACEdir + string + ".sgm";
            boolean bl = fileList.indexOf("03") > 0;
            String string3 = ACEdir + string + (bl ? ".apf.xml" : ".sgm.tmx.rdc.xml");
            String string4 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parses/" + string + ".sgm";
            RefresBuildTrain.analyzeDocument(string2, string3, string4);
        }
        if (!train) {
            System.out.println(correct + " correct resolutions");
            System.out.println(incorrect + " incorrect resolutions");
        }
    }

    private static void analyzeDocument(String string, String string2, String string3) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        AceDocument aceDocument = new AceDocument(string, string2);
        ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
        externalDocument.setAllTags(true);
        externalDocument.open();
        RefresBuildTrain.collectSentenceBoundaries(externalDocument);
        for (int i = 0; i < sentences.size(); ++i) {
            object3 = (Annotation)sentences.get(i);
            AddSyntacticRelations.annotate(externalDocument, ((Annotation)object3).span());
        }
        Ace.tagReciprocalRelations(externalDocument);
        Vector vector = Resolve.gatherMentions(externalDocument, new Span(0, externalDocument.length()));
        syntacticAntecedent = Resolve.gatherSyntacticCoref(externalDocument, vector);
        object3 = new HashMap();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            object2 = Resolve.getHeadC(annotation);
            object = new Integer(((Annotation)object2).span().start());
            ((HashMap)object3).put(object, annotation);
        }
        headToEntityMap = new HashMap();
        ArrayList arrayList = aceDocument.entities;
        for (n = 0; n < arrayList.size(); ++n) {
            object2 = (AceEntity)arrayList.get(n);
            object = ((AceEntity)object2).mentions;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                AceEntityMention aceEntityMention = (AceEntityMention)((ArrayList)object).get(i);
                Integer n2 = new Integer(aceEntityMention.head.start());
                headToEntityMap.put(n2, ((AceEntity)object2).id);
            }
        }
        mentionToEntity = new HashMap();
        entities = new Vector();
        for (n = 0; n < externalDocument.length(); ++n) {
            object2 = new Integer(n);
            object = (Annotation)((HashMap)object3).get(object2);
            String string4 = (String)headToEntityMap.get(object2);
            if (object == null || string4 == null) continue;
            RefresBuildTrain.resolveMention(externalDocument, (Annotation)object, string4);
        }
    }

    public static void references(Document document, Span span) {
        train = false;
        test = false;
        if (model == null) {
            RefresBuildTrain.loadModel(modelFile);
        }
        if ((entities = document.annotationsOfType("entity")) == null) {
            entities = new Vector();
        }
        mentionToEntity = new HashMap();
        if (trace) {
            Console.println("Resolving references");
        }
        RefresBuildTrain.collectSentenceBoundaries(document);
        Vector vector = Resolve.gatherMentions(document, span);
        syntacticAntecedent = Resolve.gatherSyntacticCoref(document, vector);
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            RefresBuildTrain.resolveMention(document, annotation, null);
        }
        Resolve.updateEvents(document, span);
    }

    private static void resolveMention(Document document, Annotation annotation, String string) {
        int n;
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string2 = (String)annotation2.get("cat");
        String string3 = SynFun.getHead(document, annotation);
        if (string3 == null) {
            return;
        }
        boolean bl = string2 == "name";
        boolean bl2 = string2 == "pro" || string2 == "det" || string2 == "np";
        boolean bl3 = string2 == "n" || string2 == "adj" || string2 == "ven" || string2 == "tv" || string2 == "hyphword";
        boolean bl4 = string2 == "$";
        Annotation annotation3 = null;
        Annotation annotation4 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < entities.size(); ++n) {
            int n2;
            boolean bl5;
            Annotation annotation5 = (Annotation)entities.get(n);
            String[] stringArray3 = new String[2];
            if (bl) {
                stringArray3 = RefresBuildTrain.nameAnaphoraFeatures(document, annotation, annotation5);
            } else if (bl3) {
                stringArray3 = RefresBuildTrain.nominalAnaphoraFeatures(document, annotation, annotation5);
            } else if (bl2) {
                stringArray3 = RefresBuildTrain.pronounAnaphoraFeatures(document, annotation, annotation5);
            } else if (bl4) {
                if (!test) {
                    continue;
                }
            } else {
                System.out.println("***RefresBuildTrain:  unexpected mention category: " + string2 + " for " + document.text(annotation));
                if (!test) continue;
            }
            Annotation annotation6 = (Annotation)syntacticAntecedent.get(annotation);
            boolean bl6 = annotation6 != null && ((Vector)annotation5.get("mentions")).contains(annotation6);
            stringArray3[stringArray3.length - 2] = "syntax=" + bl6;
            String string4 = RefresBuildTrain.context(annotation);
            ArrayList arrayList = (ArrayList)annotation5.get("contexts");
            boolean bl7 = RefresBuildTrain.matchingContext(string4, arrayList);
            stringArray3[stringArray3.length - 1] = "context=" + RefresBuildTrain.tf(bl7);
            boolean bl8 = bl5 = train | test && string.equals(annotation5.get("aceID"));
            if (bl5) {
                annotation3 = annotation5;
            }
            if (train) {
                for (n2 = 0; n2 < stringArray3.length; ++n2) {
                    writer.print(stringArray3[n2] + " ");
                }
                writer.println(RefresBuildTrain.tf(bl5));
                continue;
            }
            n2 = model.getIndex("t");
            double d3 = model.eval(stringArray3)[n2];
            if (d3 > 0.1 && d3 > d) {
                annotation4 = annotation5;
                stringArray = stringArray3;
                d = d3;
            }
            if (!bl5) continue;
            stringArray2 = stringArray3;
            d2 = d3;
        }
        if (train | test) {
            if (annotation3 != null) {
                RefresBuildTrain.addMentionToEntity(document, annotation, annotation3);
            } else {
                RefresBuildTrain.createEntity(document, annotation, string);
            }
        } else if (annotation4 != null) {
            RefresBuildTrain.addMentionToEntity(document, annotation, annotation4);
        } else {
            RefresBuildTrain.createEntity(document, annotation, string);
        }
        annotation.put("mention", "true");
        if (test) {
            if (annotation3 == annotation4) {
                ++correct;
            } else {
                ++incorrect;
                System.out.println("\nError resolving " + document.text(annotation));
                System.out.println("  Anaphor: " + annotation);
                if (annotation3 != null) {
                    System.out.println("  True antecedent: " + document.text(annotation3));
                }
                System.out.println("  True antecedent: " + annotation3);
                if (stringArray2 != null) {
                    System.out.print("  True antecedent features: \n    ");
                    for (n = 0; n < stringArray2.length; ++n) {
                        System.out.print((String)stringArray2[n] + " ");
                    }
                    System.out.println(d2);
                }
                if (annotation4 != null) {
                    System.out.println("  Predicted antecedent: " + document.text(annotation4));
                }
                System.out.println("  Predicted antecedent: " + annotation4);
                if (stringArray != null) {
                    System.out.print("  Predicted antecedent features: \n    ");
                    for (n = 0; n < stringArray.length; ++n) {
                        System.out.print((String)stringArray[n] + " ");
                    }
                    System.out.println(d);
                }
            }
        }
    }

    private static String tf(boolean bl) {
        return bl ? "t" : "f";
    }

    private static void addMentionToEntity(Document document, Annotation annotation, Annotation annotation2) {
        Object object;
        Object object2;
        Vector vector = (Vector)annotation2.get("mentions");
        vector.add(annotation);
        mentionToEntity.put(annotation, annotation2);
        String string = RefresBuildTrain.nominativeFormOf(SynFun.getHead(document, annotation));
        String[] stringArray = Resolve.getNameTokens(document, annotation);
        if (stringArray != null) {
            if (annotation2.get("name") == null) {
                stringArray = Resolve.normalizeGazName(stringArray, false, Resolve.trace);
                object2 = Resolve.getNgHead(annotation);
                object = Tokenizer.gatherTokenStrings(document, ((Annotation)object2).span());
                annotation2.put("name", stringArray);
                annotation2.put("nameWithMods", object);
                annotation2.put("nameType", string);
            }
        } else if (annotation2.get("head") == null) {
            annotation2.put("head", string);
        }
        if ((object2 = RefresBuildTrain.context(annotation)) != null) {
            object = (String[])annotation2.get("contexts");
            if (object == null) {
                object = new ArrayList();
                annotation2.put("contexts", object);
            }
            object.add(object2);
        }
    }

    private static void createEntity(Document document, Annotation annotation, String string) {
        Span span = annotation.span();
        Annotation annotation2 = new Annotation("entity", span, new FeatureSet());
        document.addAnnotation(annotation2);
        Vector vector = new Vector();
        annotation2.put("mentions", vector);
        String string2 = RefresBuildTrain.nominativeFormOf(SynFun.getHead(document, annotation));
        String string3 = SynFun.getNumber(annotation);
        if (string3 == null) {
            string3 = RefresBuildTrain.in(string2, pluralPronouns) ? "plural" : "singular";
        }
        boolean bl = SynFun.getHuman(annotation) || string2 == "person" || RefresBuildTrain.in(string2, humanPronouns);
        RefresBuildTrain.addMentionToEntity(document, annotation, annotation2);
        if (bl) {
            annotation2.put("human", "true");
        }
        annotation2.put("number", string3);
        annotation2.put("aceID", string);
        entities.add(annotation2);
    }

    private static String[] nameAnaphoraFeatures(Document document, Annotation annotation, Annotation annotation2) {
        String[] stringArray = new String[7];
        String[] stringArray2 = Resolve.getNameTokens(document, annotation);
        if (stringArray2 != null) {
            stringArray2 = Resolve.normalizeGazName(stringArray2, false, Resolve.trace);
        }
        String string = SynFun.getHead(document, annotation);
        String[] stringArray3 = (String[])annotation2.get("name");
        String string2 = (String)annotation2.get("nameType");
        int n = RefresBuildTrain.sentencesBetween(annotation2, annotation);
        n = Math.min(n, 10);
        stringArray[0] = "dist=" + n;
        boolean bl = stringArray3 != null && Resolve.matchFullName(stringArray2, string, stringArray3, string2) == 0;
        stringArray[1] = "exactName=" + RefresBuildTrain.tf(bl);
        boolean bl2 = stringArray3 != null && Resolve.matchFullName(stringArray2, string, stringArray3, string2) > 0;
        stringArray[2] = "substringName=" + RefresBuildTrain.tf(bl2);
        boolean bl3 = stringArray3 != null && stringArray2.length == 1 && Resolve.isAcronym(stringArray3, stringArray2[0]) >= 0;
        boolean bl4 = stringArray3 != null && stringArray2.length == 1 && Resolve.isAbbreviation(stringArray3, stringArray2[0]) >= 0;
        stringArray[3] = "abbrev=" + RefresBuildTrain.tf(bl3 | bl4);
        boolean bl5 = stringArray3 != null && stringArray3.length == 1 && Resolve.isAcronym(stringArray2, stringArray3[0]) >= 0;
        boolean bl6 = stringArray3 != null && stringArray3.length == 1 && Resolve.isAbbreviation(stringArray2, stringArray3[0]) >= 0;
        stringArray[4] = "revAbbrev=" + RefresBuildTrain.tf(bl5 | bl6);
        return stringArray;
    }

    private static String[] nominalAnaphoraFeatures(Document document, Annotation annotation, Annotation annotation2) {
        boolean bl;
        String string;
        String[] stringArray = new String[8];
        int n = RefresBuildTrain.sentencesBetween(annotation2, annotation);
        n = Math.min(n, 10);
        stringArray[0] = "dist=" + n;
        String string2 = SynFun.getDet(annotation);
        stringArray[1] = RefresBuildTrain.in(string2, indefiniteDets) ? "det=indef" : "det=" + string2;
        String string3 = SynFun.getNumber(annotation);
        if (string3 == null) {
            string3 = "singular";
        }
        String string4 = (String)annotation2.get("number");
        boolean bl2 = string3.equals(string4);
        stringArray[2] = "numberAgr=" + RefresBuildTrain.tf(bl2);
        String string5 = SynFun.getHead(document, annotation);
        boolean bl3 = string5.equals(string = (String)annotation2.get("head"));
        boolean bl4 = bl = bl3 && RefresBuildTrain.compatibleLeftMods(document, annotation, annotation2);
        stringArray[3] = bl ? "agr=total" : (bl3 ? "agr=head" : "agr=none");
        String string6 = (String)annotation2.get("nameType");
        stringArray[4] = string6 != null ? "heads=" + string6 + ":" + string5 : "";
        boolean bl5 = RefresBuildTrain.nameNomCoref(document, annotation, annotation2);
        if (bl5) {
            System.out.println("Name-nom coref");
            System.out.println("  Anaphor = " + document.text(annotation));
            System.out.println("  Antecedent = " + document.text(annotation2));
        }
        stringArray[5] = "nameNom=" + RefresBuildTrain.tf(bl5);
        return stringArray;
    }

    public static boolean nameNomCoref(Document document, Annotation annotation, Annotation annotation2) {
        String[] stringArray = (String[])annotation2.get("nameWithMods");
        if (stringArray == null) {
            return false;
        }
        String[] stringArray2 = Tokenizer.gatherTokenStrings(document, annotation.span());
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equalsIgnoreCase("the")) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray2[i].equalsIgnoreCase(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static String[] pronounAnaphoraFeatures(Document document, Annotation annotation, Annotation annotation2) {
        String[] stringArray = new String[7];
        String string = SynFun.getHead(document, annotation);
        String string2 = RefresBuildTrain.nominativeFormOf(string);
        Vector vector = (Vector)annotation2.get("mentions");
        Annotation annotation3 = (Annotation)vector.get(vector.size() - 1);
        int n = Hobbs.distance(annotation3, annotation, sentences);
        n = Math.min(n, 10);
        stringArray[0] = "hobbs=" + n;
        String string3 = (String)annotation2.get("number");
        boolean bl = true;
        if (RefresBuildTrain.in(string2, singularPronouns) && string3 == "plural" || RefresBuildTrain.in(string2, pluralPronouns) && string3 == "singular") {
            bl = false;
        }
        stringArray[1] = "proNumberAgr=" + RefresBuildTrain.tf(bl);
        boolean bl2 = annotation2.get("human") != null;
        boolean bl3 = true;
        if (RefresBuildTrain.in(string2, humanPronouns) && !bl2) {
            bl3 = false;
        }
        if (RefresBuildTrain.in(string2, nonHumanPronouns) && bl2) {
            bl3 = false;
        }
        stringArray[2] = "humanAgr=" + RefresBuildTrain.tf(bl3);
        String string4 = (String)annotation2.get("head");
        boolean bl4 = RefresBuildTrain.in(string2, firstSecondPronouns) ? string2.equals(string4) : (RefresBuildTrain.in(string2, thirdPronouns) ? !RefresBuildTrain.in(string4, firstSecondPronouns) : false);
        stringArray[3] = "personAgr=" + RefresBuildTrain.tf(bl4);
        stringArray[4] = "pro=" + string2;
        return stringArray;
    }

    private static String nominativeFormOf(String string) {
        if (nominative.containsKey(string)) {
            return (String)nominative.get(string);
        }
        return string;
    }

    public static boolean in(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    private static void collectSentenceBoundaries(Document document) {
        sentences = document.annotationsOfType("sentence");
        sentenceBoundaries = new int[sentences.size()];
        for (int i = 0; i < sentences.size(); ++i) {
            RefresBuildTrain.sentenceBoundaries[i] = ((Annotation)sentences.get(i)).span().start();
        }
    }

    private static int sentencesBetween(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < sentenceBoundaries.length; ++i) {
            if (n >= sentenceBoundaries[i] || sentenceBoundaries[i] > n2) continue;
            ++n3;
        }
        return n3;
    }

    private static int sentencesBetween(Annotation annotation, Annotation annotation2) {
        return RefresBuildTrain.sentencesBetween(annotation.span().start(), annotation2.span().start());
    }

    private static void loadModel(String string) {
        try {
            model = new SuffixSensitiveGISModelReader(new File(string)).getModel();
            System.out.println("GIS model loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private static String[] getLeftModifierTokens(Document document, Annotation annotation) {
        String[] stringArray;
        String string;
        Annotation annotation2 = Resolve.getNgHead(annotation);
        int n = annotation2.start();
        Annotation annotation3 = Resolve.getHeadC(annotation);
        int n2 = annotation3.start();
        Annotation[] annotationArray = StatParser.children(annotation2);
        if (annotationArray != null && annotationArray.length >= 2 && Resolve.in(string = document.text((Annotation)(stringArray = annotationArray[0])).trim().toLowerCase().intern(), AddSyntacticRelations.comlexDeterminers)) {
            n = stringArray.end();
        }
        stringArray = Tokenizer.gatherTokenStrings(document, new Span(n, n2));
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].toLowerCase();
        }
        return stringArray;
    }

    private static boolean compatibleLeftMods(Document document, Annotation annotation, Annotation annotation2) {
        Object[] objectArray = RefresBuildTrain.getLeftModifierTokens(document, annotation);
        Vector vector = (Vector)annotation2.get("mentions");
        Annotation annotation3 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation4 = (Annotation)vector.get(i);
            if (!RefresBuildTrain.isNominalMention(annotation4)) continue;
            annotation3 = annotation4;
            break;
        }
        if (annotation3 == null) {
            return false;
        }
        Object[] objectArray2 = RefresBuildTrain.getLeftModifierTokens(document, annotation3);
        boolean bl = Resolve.intersect(objectArray, objectArray2);
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private static boolean isNominalMention(Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string = (String)annotation2.get("cat");
        return string == "n";
    }

    private static String context(Annotation annotation) {
        Annotation annotation2 = null;
        String string = null;
        String string2 = null;
        if (annotation.get("subject-1") != null) {
            annotation2 = (Annotation)annotation.get("subject-1");
            string = "subject";
        } else if (annotation.get("object-1") != null) {
            annotation2 = (Annotation)annotation.get("object-1");
            string = "object";
        }
        if (annotation2 != null) {
            string2 = SynFun.getImmediateHead(annotation2);
        }
        if (string2 != null && !string2.equals("be")) {
            String string3 = string + ":" + string2;
            return string3;
        }
        return null;
    }

    public static boolean matchingContext(String string, ArrayList arrayList) {
        if (string == null) {
            return false;
        }
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (!RefresBuildTrain.matchingContext(string, string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchingContext(String string, String string2) {
        String string3;
        String string4;
        int n = string.indexOf(58);
        int n2 = string2.indexOf(58);
        String string5 = string.substring(0, n);
        if (!string5.equals(string4 = string2.substring(0, n2))) {
            return false;
        }
        String string6 = string.substring(n + 1);
        boolean bl = WordNetInterface.isVerbSynonym(string6, string3 = string2.substring(n2 + 1));
        if (bl) {
            System.out.println("*****Matching contexts " + string2 + " and " + string);
        }
        return bl;
    }

    static {
        trace = true;
        model = null;
        correct = 0;
        incorrect = 0;
        indefiniteDets = new String[]{"few", "afew", "more", "many", "most", "some", "any", "several", "less", "neither", "another", "such", "no", "either"};
        singularPronouns = new String[]{"I", "he", "she", "it"};
        pluralPronouns = new String[]{"we", "they"};
        humanPronouns = new String[]{"I", "you", "he", "she", "we"};
        nonHumanPronouns = new String[]{"it"};
        firstSecondPronouns = new String[]{"I", "we", "you"};
        thirdPronouns = new String[]{"he", "she", "it", "they"};
        nominative = new HashMap();
        nominative.put("me", "I");
        nominative.put("my", "I");
        nominative.put("myself", "I");
        nominative.put("your", "you");
        nominative.put("yourself", "you");
        nominative.put("him", "he");
        nominative.put("his", "he");
        nominative.put("himself", "he");
        nominative.put("her", "she");
        nominative.put("hers", "she");
        nominative.put("herself", "she");
        nominative.put("its", "it");
        nominative.put("itself", "it");
        nominative.put("us", "we");
        nominative.put("our", "we");
        nominative.put("ourselves", "we");
        nominative.put("them", "they");
        nominative.put("their", "they");
        nominative.put("themselves", "they");
    }
}

