/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import Jet.JetTest;
import Jet.Refres.CorefEval;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class EntityView
extends View {
    private Object[] entities;

    public EntityView(Document document, int n) {
        this.document = document;
        try {
            Vector vector = this.document.annotationsOfType("entity");
            if (vector == null || vector.size() == 0) {
                System.out.println(" (EntityView) No entities to display.");
                return;
            }
            Annotation.sort(vector);
            Collections.reverse(vector);
            this.entities = vector.toArray();
            Object[] objectArray = new String[this.entities.length];
            for (int i = 0; i < this.entities.length; ++i) {
                objectArray[i] = this.entityDescription((Annotation)this.entities[i]);
            }
            this.jbInit(objectArray, "Entities");
            this.setTitle("Entities for Document " + n);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            int n2 = (dimension.width - dimension2.width) / 30;
            this.setLocation(30 * (n % n2) + 15, 20 * (n % n2) + 10);
            this.setVisible(true);
            this.jSplitPaneTop.setDividerLocation(0.3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void jListValueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        for (n = 0; n < this.entities.length; ++n) {
            if (jList.isSelectedIndex(n)) continue;
            this.bleachEntity((Annotation)this.entities[n]);
        }
        this.jTextPane.clearLines();
        for (n = 0; n < this.entities.length; ++n) {
            if (!jList.isSelectedIndex(n)) continue;
            this.highlightEntity((Annotation)this.entities[n]);
        }
    }

    private void highlightEntity(Annotation annotation) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, Color.pink);
        StyleConstants.setBold(simpleAttributeSet, true);
        this.setEntityAttribute(annotation, simpleAttributeSet);
        Vector vector = this.mentionsOfEntity(annotation);
        Color color = Color.BLUE;
        if (annotation.get("status") == "response") {
            color = Color.RED;
        }
        if (annotation.get("status") == "key") {
            color = Color.GREEN;
        }
        this.connectMentions(vector, color);
    }

    private void bleachEntity(Annotation annotation) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.setEntityAttribute(annotation, simpleAttributeSet);
    }

    private String entityDescription(Annotation annotation) {
        String string = (String)annotation.get("id");
        String string2 = (String)annotation.get("descriptor");
        String string3 = (String)annotation.get("status");
        String string4 = "";
        if (string3 == "key") {
            string4 = "[K]";
        } else if (string3 == "response") {
            string4 = "[R]";
        }
        if (string != null || string2 != null) {
            return string + ": " + string2 + string4;
        }
        return Resolve.normalizeName(this.document.text(annotation)) + string4;
    }

    private Vector mentionsOfEntity(Annotation annotation) {
        return (Vector)annotation.get("mentions");
    }

    private void setEntityAttribute(Annotation annotation, SimpleAttributeSet simpleAttributeSet) {
        Vector vector = this.mentionsOfEntity(annotation);
        if (vector == null) {
            System.out.println("EntityView:  entity has no mentions:");
            System.out.println("            " + annotation);
            return;
        }
        this.setAnnotationAttribute(vector, simpleAttributeSet);
    }

    private void connectMentions(Vector vector, Color color) {
        Point point = null;
        for (int i = 0; i < vector.size(); ++i) {
            Point point2;
            Annotation annotation = (Annotation)vector.get(i);
            int n = annotation.span().start();
            try {
                Rectangle rectangle = this.jTextPane.modelToView(n);
                point2 = rectangle.getLocation();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (i > 0) {
                this.jTextPane.addLine(point, point2, color);
            }
            point = point2;
        }
    }

    public static void task(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 4 && stringArray[1].equals("-encoding")) {
            string = stringArray[2];
            string2 = stringArray[3];
        } else if (stringArray.length == 2) {
            string2 = stringArray[1];
        } else {
            System.out.println("CorefView requires 1 argument: jet -CorefView [-encoding e] <document>");
            System.exit(1);
        }
        if (string != null && !JetTest.setEncoding(string)) {
            System.exit(1);
        }
        ExternalDocument externalDocument = new ExternalDocument("sgml", string2);
        externalDocument.setAllTags(true);
        externalDocument.open();
        CorefEval.buildEntitiesFromMentions(externalDocument);
        new EntityView(externalDocument, 0);
    }
}

