/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.EDTtype;
import AceJet.Gazetteer;
import Jet.Chunk.Chunker;
import Jet.Control;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import java.io.IOException;
import java.util.Vector;

public class CorefWriter {
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String collection = "C:/Documents and Settings/Ralph Grishman/My Documents/Sekine/input/Duc2004/files.txt";
    static final String dictFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/EDT type dict.txt";

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("ME ace.properties");
        Chunker.loadModel();
        EDTtype.readTypeDict(dictFile);
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/loc.dict");
        Pat.trace = false;
        Resolve.trace = false;
        DocumentCollection documentCollection = new DocumentCollection(collection);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.open();
            Ace.monocase = Ace.allLowerCase(externalDocument);
            Control.processDocument(externalDocument, null, i == 0, i);
            CorefWriter.buildMentionsFromEntities(externalDocument);
            externalDocument.setSGMLtags(new String[]{"mention"});
        }
        documentCollection.saveAs("C:/Documents and Settings/Ralph Grishman/My Documents/Sekine/output/Duc2004/files.txt");
    }

    private static void buildMentionsFromEntities(Document document) {
        Vector vector = document.annotationsOfType("entity");
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Vector vector2 = (Vector)annotation.get("mentions");
            for (int j = 0; j < vector2.size(); ++j) {
                Annotation annotation2 = (Annotation)vector2.get(j);
                Annotation annotation3 = Resolve.getHeadC(annotation2);
                document.annotate("mention", annotation3.span(), new FeatureSet("entity", new Integer(i)));
            }
        }
    }
}

