/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Concepts.ConcreteFileFilter;
import Jet.Pat.Action;
import Jet.Pat.PatternAlternation;
import Jet.Pat.PatternCollection;
import Jet.Pat.PatternElement;
import Jet.Pat.PatternRule;
import Jet.Pat.PatternSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PatternView
extends JFrame
implements ActionListener {
    PatternCollection pc;
    DefaultMutableTreeNode patternsNode;
    DefaultMutableTreeNode patternSetsNode;
    JTree patternTree;
    JScrollPane jScrollPane = new JScrollPane();
    JFileChooser fc = new JFileChooser(".");
    File currentFile;
    Vector matchedPatterns = new Vector();
    Vector appliedPatterns = new Vector();

    public PatternView(File file) {
        this.currentFile = file;
        this.readPatterns();
        this.buildTree();
        this.jbInit();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open ...")) {
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                this.currentFile = this.fc.getSelectedFile();
                this.readPatterns();
                this.buildTree();
                this.patternTree.getSelectionModel().setSelectionMode(1);
                this.jScrollPane.getViewport().add((Component)this.patternTree, null);
                this.setTitle("Pattern View - " + this.currentFile.getPath());
            }
        } else if (actionEvent.getActionCommand().equals("Expand")) {
            TreePath treePath = this.patternTree.getSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.expand(defaultMutableTreeNode);
            }
        } else if (actionEvent.getActionCommand().equals("Collapse")) {
            TreePath treePath = this.patternTree.getSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.collapse(defaultMutableTreeNode);
            }
        } else if (actionEvent.getActionCommand().equals("Expand All")) {
            this.expand(this.patternsNode);
            this.expand(this.patternSetsNode);
        } else if (actionEvent.getActionCommand().equals("Collapse All")) {
            this.collapse(this.patternsNode);
            this.collapse(this.patternSetsNode);
        } else if (actionEvent.getActionCommand().equals("Clear Marks")) {
            this.clearMatchedPatterns();
            this.clearAppliedPatterns();
            this.refresh();
        } else {
            this.dispose();
        }
    }

    public void addMatchedPattern(String string) {
        this.matchedPatterns.add(string);
    }

    public void clearMatchedPatterns() {
        this.matchedPatterns = new Vector();
    }

    public void addAppliedPattern(String string) {
        this.appliedPatterns.add(string);
    }

    public void clearAppliedPatterns() {
        this.appliedPatterns = new Vector();
    }

    public void refresh() {
        this.patternTree.updateUI();
    }

    private void buildTree() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        String string;
        int n2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("root");
        this.patternTree = new JTree(defaultMutableTreeNode3);
        this.patternTree.setRootVisible(false);
        this.patternTree.setShowsRootHandles(true);
        this.patternTree.setEditable(false);
        this.patternTree.putClientProperty("JTree.lineStyle", "Angled");
        this.patternTree.setCellRenderer(new PatternRenderer());
        this.patternsNode = new DefaultMutableTreeNode("Patterns");
        this.patternSetsNode = new DefaultMutableTreeNode("Pattern Sets");
        defaultMutableTreeNode3.add(this.patternsNode);
        defaultMutableTreeNode3.add(this.patternSetsNode);
        for (n2 = 0; n2 < this.pc.patternNames.size(); ++n2) {
            string = (String)this.pc.patternNames.get(n2);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            this.patternsNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode = defaultMutableTreeNode2;
            PatternElement patternElement = (PatternElement)this.pc.patterns.get(string);
            if (patternElement instanceof PatternAlternation) {
                PatternAlternation patternAlternation = (PatternAlternation)patternElement;
                for (n = 0; n < patternAlternation.options.length; ++n) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(patternAlternation.options[n].toString());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                continue;
            }
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(patternElement.toString());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        for (n2 = 0; n2 < this.pc.patternSetNames.size(); ++n2) {
            string = (String)this.pc.patternSetNames.get(n2);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Pattern Set: " + string);
            this.patternSetsNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode = defaultMutableTreeNode2;
            PatternSet patternSet = (PatternSet)this.pc.patternSets.get(string);
            for (n = 0; n < patternSet.rules.size(); ++n) {
                PatternRule patternRule = (PatternRule)patternSet.rules.get(n);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(patternRule.patternName);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                for (int i = 0; i < patternRule.actions().size(); ++i) {
                    Action action = (Action)patternRule.actions().get(i);
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(action));
                }
            }
        }
        this.patternTree.updateUI();
    }

    private void readPatterns() {
        this.pc = new PatternCollection();
        try {
            this.pc.readPatternCollection(new BufferedReader(new FileReader(this.currentFile)));
        }
        catch (IOException iOException) {
            System.err.println("Error: reading pattern file " + this.currentFile.getName() + ", " + iOException.getMessage());
        }
        this.pc.makePatternGraph();
    }

    private void expand(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.patternTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.expand((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }

    private void collapse(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.collapse((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        this.patternTree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    private void jbInit() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Open ...");
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic(86);
        jMenuItem = new JMenuItem("Expand");
        jMenuItem.setMnemonic(69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Collapse");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Expand All");
        jMenuItem.setMnemonic(69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 10));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Collapse All");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem("Clear Marks");
        jMenuItem.setMnemonic(77);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        ConcreteFileFilter concreteFileFilter = new ConcreteFileFilter("pat", "Pattern Files (*.pat)");
        this.fc.setFileFilter(concreteFileFilter);
        this.fc.setDialogTitle("Open Pattern File");
        this.fc.setApproveButtonText("Open");
        this.fc.setApproveButtonMnemonic(79);
        this.fc.setApproveButtonToolTipText("Open Pattern File");
        this.patternTree.getSelectionModel().setSelectionMode(1);
        this.jScrollPane.getViewport().add((Component)this.patternTree, null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.setSize(600, 600);
        this.setTitle("Pattern View - " + this.currentFile.getPath());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PatternView.this.dispose();
            }
        });
    }

    class PatternRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon actionIcon = new ImageIcon("images/fish.gif");
        ImageIcon matchIcon = new ImageIcon("images/octopus.gif");
        ImageIcon applyIcon = new ImageIcon("images/crab.gif");

        PatternRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3 && this.isAction(object)) {
                this.setIcon(this.actionIcon);
            } else if (!bl3 && this.isMatched(object)) {
                this.setIcon(this.matchIcon);
            } else if (!bl3 && this.isApplied(object)) {
                this.setIcon(this.applyIcon);
            }
            return this;
        }

        boolean isAction(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                if (!((DefaultMutableTreeNode)treeNodeArray[i]).equals(PatternView.this.patternSetsNode)) continue;
                return true;
            }
            return false;
        }

        boolean isMatched(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            String string = defaultMutableTreeNode.getUserObject().toString();
            if (!PatternView.this.matchedPatterns.contains(string)) {
                return false;
            }
            TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                if (!((DefaultMutableTreeNode)treeNodeArray[i]).equals(PatternView.this.patternsNode)) continue;
                return true;
            }
            return false;
        }

        boolean isApplied(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            String string = defaultMutableTreeNode.getUserObject().toString();
            if (!PatternView.this.appliedPatterns.contains(string)) {
                return false;
            }
            TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                if (!((DefaultMutableTreeNode)treeNodeArray[i]).equals(PatternView.this.patternSetsNode)) continue;
                return true;
            }
            return false;
        }
    }
}

