/*
 * Decompiled with CFR 0.152.
 */
package Jet.Lisp;

import Jet.Lisp.Variable;
import Jet.Pat.FeatureTest;
import Jet.Pat.PatternSyntaxError;
import Jet.Tipster.Annotation;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class FeatureSet {
    protected Vector features;
    protected Vector values;

    public FeatureSet() {
        this.features = new Vector(1);
        this.values = new Vector(1);
    }

    public FeatureSet(String string, Object object) {
        this.features = new Vector(1);
        this.values = new Vector(1);
        this.features.addElement(string);
        this.values.addElement(object);
    }

    public FeatureSet(String string, Object object, String string2, Object object2) {
        this.features = new Vector(2);
        this.values = new Vector(2);
        this.features.addElement(string);
        this.values.addElement(object);
        this.features.addElement(string2);
        this.values.addElement(object2);
    }

    public FeatureSet(String string, Object object, String string2, Object object2, String string3, Object object3) {
        this.features = new Vector(2);
        this.values = new Vector(2);
        this.features.addElement(string);
        this.values.addElement(object);
        this.features.addElement(string2);
        this.values.addElement(object2);
        this.features.addElement(string3);
        this.values.addElement(object3);
    }

    public FeatureSet(FeatureSet featureSet) {
        int n = featureSet.size();
        this.features = new Vector(n);
        this.values = new Vector(n);
        this.putAll(featureSet);
    }

    public FeatureSet(StreamTokenizer streamTokenizer, boolean bl, char c) throws IOException, PatternSyntaxError {
        this.features = new Vector();
        this.values = new Vector();
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(46, 46);
        while (streamTokenizer.nextToken() != c) {
            Object object;
            if (streamTokenizer.ttype == 44 & this.features.size() > 0) {
                streamTokenizer.nextToken();
            }
            if (streamTokenizer.ttype != -3) {
                throw new PatternSyntaxError("feature name or " + c + " expected, " + streamTokenizer + " found");
            }
            String string = streamTokenizer.sval.intern();
            if (streamTokenizer.nextToken() == 61) {
                if (streamTokenizer.nextToken() == -3) {
                    object = streamTokenizer.sval.intern();
                    if (Character.isUpperCase(((String)object).charAt(0))) {
                        if (bl) {
                            this.put(string, new Variable((String)object));
                            continue;
                        }
                        this.put(string, object);
                        continue;
                    }
                    if (object == "null") {
                        this.put(string, null);
                        continue;
                    }
                    this.put(string, object);
                    continue;
                }
                if (streamTokenizer.ttype == 34) {
                    object = streamTokenizer.sval.intern();
                    this.put(string, object);
                    continue;
                }
                if (streamTokenizer.ttype == -2) {
                    object = new Integer((int)streamTokenizer.nval);
                    this.put(string, object);
                    continue;
                }
                if (streamTokenizer.ttype == 91) {
                    object = new FeatureSet(streamTokenizer, bl, ']');
                    this.put(string, object);
                    continue;
                }
                throw new PatternSyntaxError("feature value expected");
            }
            if (bl && streamTokenizer.ttype == 63) {
                object = new FeatureTest(streamTokenizer);
                this.put(string, object);
                continue;
            }
            throw new PatternSyntaxError("= or ? expected");
        }
    }

    public void put(String string, Object object) {
        int n = this.features.indexOf(string);
        if (n < 0) {
            this.features.addElement(string);
            this.values.addElement(object);
        } else {
            this.values.set(n, object);
        }
    }

    public void putAll(FeatureSet featureSet) {
        if (featureSet == null) {
            return;
        }
        Enumeration enumeration = featureSet.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = featureSet.get(string);
            this.put(string, object);
        }
    }

    public Object get(String string) {
        int n = this.features.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.values.get(n);
    }

    public boolean containsFeature(String string) {
        return this.features.indexOf(string) >= 0;
    }

    public boolean subsetOf(FeatureSet featureSet) {
        if (featureSet == null) {
            return false;
        }
        int n = this.features.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.features.get(i);
            if (!featureSet.containsFeature(string)) {
                return false;
            }
            if (this.values.get(i).equals(featureSet.get(string))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(FeatureSet featureSet) {
        if (featureSet == null) {
            return false;
        }
        int n = this.features.size();
        if (n != featureSet.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)this.features.get(i);
            if (!featureSet.containsFeature(string)) {
                return false;
            }
            if (this.values.get(i).equals(featureSet.get(string))) continue;
            return false;
        }
        return true;
    }

    public Enumeration keys() {
        return this.features.elements();
    }

    public int size() {
        return this.features.size();
    }

    public FeatureSet substitute(HashMap hashMap) {
        FeatureSet featureSet = new FeatureSet();
        int n = this.features.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.values.get(i);
            if (object instanceof Variable) {
                object = hashMap.get(((Variable)object).name);
            } else if (object instanceof FeatureSet) {
                object = ((FeatureSet)object).substitute(hashMap);
            }
            featureSet.put((String)this.features.get(i), object);
        }
        return featureSet;
    }

    public static FeatureSet unify(FeatureSet featureSet, FeatureSet featureSet2) {
        FeatureSet featureSet3 = new FeatureSet(featureSet);
        if (featureSet2 == null) {
            return featureSet3;
        }
        Enumeration enumeration = featureSet2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = featureSet.get(string);
            Object object2 = featureSet2.get(string);
            if (object == null) {
                featureSet3.put(string, object2);
                continue;
            }
            if (object == object2) continue;
            return null;
        }
        return featureSet3;
    }

    public String toString() {
        return "[" + this.toSGMLString() + "]";
    }

    public String toSGMLString() {
        return this.toSGMLString(2, false);
    }

    public String toSGMLString(int n, boolean bl) {
        int n2 = this.features.size();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            if (((String)this.features.elementAt(i)).endsWith("-1")) continue;
            if (i > 0) {
                string = string + " ";
            }
            string = string + this.features.elementAt(i) + "=" + (bl ? "\"" : "") + FeatureSet.valueToString(this.values.elementAt(i), n, bl) + (bl ? "\"" : "");
        }
        return string;
    }

    private static String valueToString(Object object, int n, boolean bl) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(FeatureSet.valueToString(objectArray[i], n, bl));
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Annotation) {
            Annotation annotation = (Annotation)object;
            if (n > 1) {
                return annotation.toSGMLString(n - 1, bl);
            }
            return "#" + annotation.getId();
        }
        return object.toString();
    }

    public void prepareToMakeString(int n) {
        int n2 = this.features.size();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            this.prepareToMakeString(this.values.elementAt(i), n);
        }
    }

    private void prepareToMakeString(Object object, int n) {
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    this.prepareToMakeString(objectArray[i], n);
                }
            } else if (object instanceof Annotation) {
                Annotation annotation = (Annotation)object;
                if (n > 1) {
                    annotation.prepareToMakeString(n - 1);
                } else {
                    annotation.assignId();
                }
            }
        }
    }
}

