/*
 * Decompiled with CFR 0.152.
 */
package Jet;

import Jet.Chunk.Chunker;
import Jet.Console;
import Jet.JetTest;
import Jet.Lex.Lexicon;
import Jet.Lex.Tokenizer;
import Jet.Parser.AddSyntacticRelations;
import Jet.Parser.ParseTreeNode;
import Jet.Parser.Parsers;
import Jet.Parser.StatParser;
import Jet.Refres.EntityView;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import Jet.Tipster.View;
import Jet.Zoner.SentenceSplitter;
import Jet.Zoner.SpeechSplitter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class Control {
    public static void processDocument(Document document, OutputStreamWriter outputStreamWriter, boolean bl, int n) throws IOException {
        String string = JetTest.config.getProperty("processDocument");
        if (string == null || string.length() == 0) {
            Console.println("*** System error: no processDocument script.");
            return;
        }
        if (JetTest.nameTagger != null) {
            JetTest.nameTagger.nameHMM.newDocument();
        }
        Control.applyScript(document, new Span(0, document.length()), string);
        String string2 = JetTest.config.getProperty("WriteSGML.type");
        if (string2 != null) {
            System.out.println("Writing document " + n);
            outputStreamWriter.write(document.writeSGML(string2).toString());
            outputStreamWriter.write(System.getProperty("line.separator"));
        }
        if (bl) {
            View view = new View(document, n);
            JetTest.views.add(view);
            Vector vector = document.annotationsOfType("entity");
            if (vector != null && vector.size() > 0) {
                EntityView entityView = new EntityView(document, n);
                JetTest.views.add(entityView);
            }
        }
    }

    public static void processSentence(Document document, Span span) {
        String string = JetTest.config.getProperty("processSentence");
        if (string == null || string.length() == 0) {
            Console.println("*** No processSentence script.");
        } else {
            Control.applyScript(document, span, string);
        }
    }

    public static void applyScript(Document document, Span span, String string) {
        String[] stringArray = Control.splitAtComma(string);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string2 = stringArray[i].intern();
            int n = string2.indexOf(58);
            if (n > 0 && n < string2.length() - 1) {
                object2 = string2.substring(0, n).trim();
                String string3 = string2.substring(n + 1).trim();
                object = JetTest.config.getProperty(string3);
                if (object == null || ((String)object).length() == 0) {
                    Console.println("*** No script for " + string3);
                    continue;
                }
                Vector vector = document.annotationsOfType((String)object2, span);
                if (vector == null) {
                    Console.println("*** No annotations of type " + (String)object2);
                    continue;
                }
                for (int j = 0; j < vector.size(); ++j) {
                    Annotation annotation = (Annotation)vector.get(j);
                    Control.applyScript(document, annotation.span(), (String)object);
                }
                continue;
            }
            if (string2.startsWith("tag(") && string2.endsWith(")")) {
                object2 = string2.substring(4, string2.length() - 1).trim();
                document.annotateWithTag((String)object2);
                continue;
            }
            if (string2 == "tokenize") {
                Tokenizer.tokenize(document, span);
                continue;
            }
            if (string2 == "sentenceSplit") {
                SentenceSplitter.split(document, span);
                continue;
            }
            if (string2 == "speechSplit") {
                SpeechSplitter.split(document, span);
                continue;
            }
            if (string2 == "lexLookup") {
                Lexicon.annotateWithDefinitions(document, span.start(), span.end());
                continue;
            }
            if (string2 == "tagPOS") {
                if (JetTest.tagger == null) {
                    Console.println("Error:  no POS model loaded");
                    continue;
                }
                JetTest.tagger.tagPenn(document, span);
                continue;
            }
            if (string2 == "tagJet") {
                if (JetTest.tagger == null) {
                    Console.println("Error:  no POS model loaded");
                    continue;
                }
                JetTest.tagger.tagJet(document, span);
                continue;
            }
            if (string2 == "pruneTags") {
                if (JetTest.tagger == null) {
                    Console.println("Error:  no POS model loaded");
                    continue;
                }
                JetTest.tagger.prune(document, span);
                continue;
            }
            if (string2 == "tagNames") {
                if (JetTest.nameTagger == null) {
                    Console.println("Error:  no name model loaded");
                    continue;
                }
                JetTest.nameTagger.tag(document, span);
                continue;
            }
            if (string2 == "chunk") {
                if (Chunker.model == null) {
                    Console.println("Error:  no chunker model loaded");
                    continue;
                }
                Chunker.chunk(document, span);
                continue;
            }
            if (string2 == "parse") {
                object2 = Parsers.parse(document, 0, document.length(), JetTest.gram);
                for (int j = 0; j < ((Vector)object2).size(); ++j) {
                    object = (ParseTreeNode)((Vector)object2).elementAt(j);
                    if (object == null) continue;
                    ParseTreeNode.makeParseAnnotations(document, (ParseTreeNode)object);
                    if (((Vector)object2).size() == 1) {
                        Console.println("Parse:");
                    } else {
                        Console.println("Parse " + (j + 1) + ":");
                    }
                    ((ParseTreeNode)object).printTree();
                }
                continue;
            }
            if (string2 == "statParse") {
                if (!StatParser.isInitialized()) {
                    Console.println("Error:  no grammar for parser");
                    continue;
                }
                StatParser.parse(document, span);
                continue;
            }
            if (string2 == "syntacticRelations") {
                AddSyntacticRelations.annotate(document, span);
                continue;
            }
            if (string2.startsWith("pat(") && string2.endsWith(")")) {
                object2 = string2.substring(4, string2.length() - 1).trim();
                JetTest.pc.apply((String)object2, document, span);
                continue;
            }
            if (string2 == "resolve") {
                Resolve.references(document, span);
                continue;
            }
            System.out.println("Unknown Jet.processSentence action: " + string2);
        }
    }

    private static String[] splitAtComma(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }
}

