/*
 * Decompiled with CFR 0.152.
 */
package Jet;

import Jet.Concepts.ConceptHierarchyWindow;
import Jet.Control;
import Jet.HMM.HMMTagger;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Parser.Parsers;
import Jet.Pat.PatternApplication;
import Jet.Pat.PatternGraphView;
import Jet.Pat.PatternView;
import Jet.Scorer.SGMLScorerWindow;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Console
extends JFrame
implements ActionListener {
    static JMenuBar menuBar;
    static JPanel controlPanel;
    static JLabel label;
    static JTextField sentence;
    static JTextArea area;
    static JScrollPane sp;
    public static PatternView pv;
    public static PatternGraphView pgv;

    public Console() {
        super("Jet Console");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSize(640, 480);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    private static JMenu buildFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Reload Grammar");
        jMenuItem.setMnemonic(71);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JetTest.readGrammar();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Reload Lexicon");
        jMenuItem2.setMnemonic(76);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JetTest.readLexicons();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Reload Patterns");
        jMenuItem3.setMnemonic(80);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JetTest.readPatterns();
                JMenu jMenu = menuBar.getMenu(3);
                jMenu.remove(2);
                jMenu.remove(2);
                jMenu.add(PatternApplication.matchSubmenu());
                jMenu.add(PatternApplication.applySubmenu());
            }
        });
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Clear console");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                area.setText("");
            }
        });
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Exit");
        jMenuItem5.setMnemonic(88);
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    private static JMenu buildTaggerMenu() {
        JMenu jMenu = new JMenu("Tagger");
        jMenu.setMnemonic(71);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("POS Tagger Trace", HMMTagger.trace);
        jCheckBoxMenuItem.setMnemonic(80);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HMMTagger.trace = jCheckBoxMenuItem.getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        return jMenu;
    }

    private static JMenu buildPatternsMenu() {
        JMenu jMenu = new JMenu("Patterns");
        jMenu.setMnemonic(80);
        JMenuItem jMenuItem = new JMenuItem("View Patterns");
        jMenuItem.setMnemonic(86);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pv = new PatternView(JetTest.patternFile);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("View Pattern Graphs");
        jMenuItem2.setMnemonic(71);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pgv = new PatternGraphView(JetTest.patternFile);
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.add(PatternApplication.matchSubmenu());
        jMenu.add(PatternApplication.applySubmenu());
        return jMenu;
    }

    private static JMenu buildToolsMenu() {
        JMenu jMenu = new JMenu("Tools");
        jMenu.setMnemonic(84);
        JMenuItem jMenuItem = new JMenuItem("SGML Scorer ...");
        jMenuItem.setMnemonic(83);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGMLScorerWindow sGMLScorerWindow = new SGMLScorerWindow();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Concept Editor ...");
        jMenuItem2.setMnemonic(67);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConceptHierarchyWindow conceptHierarchyWindow = new ConceptHierarchyWindow(JetTest.conceptHierarchy, JetTest.conceptHierarchyFile);
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Process Documents");
        jMenu2.setMnemonic(80);
        jMenu.add(jMenu2);
        JMenuItem jMenuItem3 = new JMenuItem("and View Annotated Documents ...");
        jMenuItem3.setMnemonic(86);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pv != null) {
                    pv.clearMatchedPatterns();
                    pv.clearAppliedPatterns();
                    pv.refresh();
                }
                JetTest.processFiles(true);
            }
        });
        jMenu2.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("but Don't View");
        jMenuItem4.setMnemonic(68);
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pv != null) {
                    pv.clearMatchedPatterns();
                    pv.clearAppliedPatterns();
                    pv.refresh();
                }
                JetTest.processFiles(false);
            }
        });
        jMenu2.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Close All Jet Documents");
        jMenuItem5.setMnemonic(65);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JetTest.closeAllViews();
            }
        });
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Costomize Annotation Colors ...");
        jMenuItem6.setMnemonic(90);
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationColor.showColors();
            }
        });
        jMenu.add(jMenuItem6);
        return jMenu;
    }

    public static void print(String string) {
        if (area == null) {
            System.out.print(string);
        } else {
            area.append(string);
            sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getMaximum());
        }
    }

    public static void println(String string) {
        if (area == null) {
            System.out.println(string);
        } else {
            area.append(string);
            area.append("\n");
            sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getMaximum());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = sentence.getText();
        Console.println("---------");
        Console.println("Sentence:                               " + string);
        sentence.selectAll();
        if (pv != null) {
            pv.clearMatchedPatterns();
            pv.clearAppliedPatterns();
            pv.refresh();
        }
        if (string == null) {
            return;
        }
        Document document = new Document(string);
        Span span = new Span(0, document.length());
        Tokenizer.tokenize(document, span);
        Control.processSentence(document, span);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(3);
        menuBar = new JMenuBar();
        menuBar.add(Console.buildFileMenu());
        menuBar.add(Parsers.parserMenu());
        menuBar.add(Console.buildTaggerMenu());
        menuBar.add(Console.buildPatternsMenu());
        menuBar.add(Console.buildToolsMenu());
        this.setJMenuBar(menuBar);
        controlPanel = new JPanel();
        label = new JLabel();
        sentence = new JTextField();
        area = new JTextArea();
        area.setEditable(false);
        area.setFont(new Font("Monospaced", 0, 12));
        sp = new JScrollPane(area);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        label.setText("Enter sentence:");
        sentence.addActionListener(this);
        controlPanel.setLayout(new GridBagLayout());
        area.setMargin(new Insets(3, 3, 3, 3));
        container.add((Component)controlPanel, "South");
        controlPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 3, 0), 0, 0));
        controlPanel.add((Component)sentence, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 6, 3, 16), 0, 0));
        container.add((Component)sp, "Center");
    }

    static {
        area = null;
        pv = null;
        pgv = null;
    }
}

