/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.DataStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class NameSubtyper {
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 21andup.txt";
    static PrintStream writer;
    static final String featureFile = "C:/Documents and Settings/Ralph Grishman/My Documents/jet temp/ACEnameSubtypeFeatures.txt";
    static final String modelFile = "C:/Documents and Settings/Ralph Grishman/My Documents/jet temp/ACEnameSubtypeModel.txt";
    static GISModel model;

    public static void main(String[] stringArray) throws IOException {
        AceDocument.ace2004 = true;
        writer = new PrintStream(new FileOutputStream(featureFile));
        NameSubtyper.processFileList(fileList);
        NameSubtyper.processFileList("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 bnews.txt");
        NameSubtyper.processFileList("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 chinese.txt");
        NameSubtyper.createModel();
        NameSubtyper.store(modelFile);
        System.out.println("Finished.");
    }

    private static void processFileList(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string2);
            String string3 = ACEdir + string2 + ".sgm";
            String string4 = ACEdir + string2 + ".apf.xml";
            NameSubtyper.analyzeDocument(string3, string4);
        }
    }

    private static void analyzeDocument(String string, String string2) {
        AceDocument aceDocument = new AceDocument(string, string2);
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            String string3 = aceEntity.type;
            String string4 = aceEntity.subtype;
            ArrayList arrayList2 = aceEntity.names;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityName aceEntityName = (AceEntityName)arrayList2.get(j);
                String string5 = aceEntityName.text;
                if (string3.equals("WEA")) {
                    System.out.println("Found weapon name " + string5);
                }
                if (string3.equals("VEH")) {
                    System.out.println("Found vehicle name " + string5);
                    continue;
                }
                if (string3.equals("PERSON")) continue;
                String[] stringArray = string5.split("\\s");
                String[] stringArray2 = NameSubtyper.NEfeatures(stringArray, string3);
                for (int k = 0; k < stringArray2.length; ++k) {
                    writer.print(stringArray2[k] + " ");
                }
                writer.println(string4);
            }
        }
    }

    private static String[] NEfeatures(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string = string.substring(0, 3);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = string + "=" + stringArray[i].toLowerCase();
        }
        return stringArray2;
    }

    public static void createModel() {
        try {
            FileReader fileReader = new FileReader(new File(featureFile));
            BasicEventStream basicEventStream = new BasicEventStream((DataStream)new PlainTextByLineDataStream((Reader)fileReader));
            GIS.SMOOTHING = false;
            GIS.SMOOTHING_OBSERVATION = 0.1;
            model = GIS.trainModel((EventStream)basicEventStream, (int)100, (int)2);
        }
        catch (Exception exception) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(exception);
        }
    }

    public static void store(String string) {
        try {
            File file = new File(string);
            SuffixSensitiveGISModelWriter suffixSensitiveGISModelWriter = new SuffixSensitiveGISModelWriter(model, file);
            suffixSensitiveGISModelWriter.persist();
        }
        catch (IOException iOException) {
            System.out.println("MaxEntNE.saveModel: unable to save model");
            System.out.println(iOException);
        }
    }

    public static void load(String string) {
        try {
            model = new SuffixSensitiveGISModelReader(new File(string)).getModel();
            System.out.println("GIS model loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public static String classify(String string, String string2) {
        if (string2.equals("PERSON")) {
            return "";
        }
        if (string2.equals("VEH") || string2.equals("WEA")) {
            return "Other";
        }
        if (model == null) {
            NameSubtyper.load(modelFile);
        }
        String[] stringArray = string.split("\\s");
        String[] stringArray2 = NameSubtyper.NEfeatures(stringArray, string2);
        String string3 = model.getBestOutcome(model.eval(stringArray2));
        return string3;
    }
}

