/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class APFtoXML {
    static String encoding = "ISO-8859-1";
    static HashMap startTag;
    static HashSet endTag;
    static DocumentBuilder builder;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String outputDir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/NE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/aug03 all.txt";
    static int[] ACEoffsetMap;
    static HashMap standardType;

    APFtoXML() {
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        builder = documentBuilderFactory.newDocumentBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string);
            String string2 = ACEdir + string + ".sgm";
            boolean bl = fileList.indexOf("03") > 0;
            String string3 = ACEdir + string + (bl ? ".apf.xml" : ".sgm.tmx.rdc.xml");
            String string4 = outputDir + string + ".ne.txt";
            APFtoXML.convertDocument(string2, string3, string4);
        }
    }

    private static void convertDocument(String string, String string2, String string3) throws SAXException, IOException {
        Document document = builder.parse(string2);
        APFtoXML.findNames(document);
        StringBuffer stringBuffer = APFtoXML.readDocument(string);
        APFtoXML.computeOffsets(stringBuffer);
        APFtoXML.writeXML(stringBuffer, string3);
    }

    static void findNames(Document document) {
        startTag = new HashMap();
        endTag = new HashSet();
        NodeList nodeList = document.getElementsByTagName("entity");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName("entity_type");
            Element element2 = (Element)nodeList2.item(0);
            String string = APFtoXML.getElementText(element, "entity_type");
            NodeList nodeList3 = element.getElementsByTagName("name");
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Element element3 = (Element)nodeList3.item(j);
                String string2 = APFtoXML.getElementText(element3, "start");
                String string3 = APFtoXML.getElementText(element3, "end");
                startTag.put(new Integer(string2), string);
                endTag.add(new Integer(string3));
            }
        }
    }

    private static String getElementText(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        Element element2 = (Element)nodeList.item(0);
        String string2 = element2.getFirstChild().getNodeValue();
        return string2;
    }

    static StringBuffer readDocument(String string) throws IOException {
        String string2;
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer;
    }

    static void computeOffsets(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = 0;
        int n2 = stringBuffer.length();
        ACEoffsetMap = new int[n2];
        for (int i = 0; i < n2; ++i) {
            if (stringBuffer.charAt(i) == '<') {
                bl = true;
            }
            if (bl) {
                ++n;
            }
            APFtoXML.ACEoffsetMap[i] = i - n;
            if (stringBuffer.charAt(i) != '>') continue;
            bl = false;
        }
    }

    static void writeXML(StringBuffer stringBuffer, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), encoding);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            int n = ACEoffsetMap[i];
            Integer n2 = new Integer(n);
            if (startTag.containsKey(n2)) {
                String string2 = (String)startTag.get(n2);
                if (standardType.containsKey(string2)) {
                    string2 = (String)standardType.get(string2);
                }
                outputStreamWriter.write("<ENAMEX TYPE=" + string2 + ">");
            }
            outputStreamWriter.write(stringBuffer.charAt(i));
            if (!endTag.contains(n2)) continue;
            outputStreamWriter.write("</ENAMEX>");
        }
        if (endTag.contains(new Integer(stringBuffer.length()))) {
            outputStreamWriter.write("</ENAMEX>");
        }
        outputStreamWriter.close();
    }

    static {
        ACEoffsetMap = null;
        standardType = new HashMap();
        standardType.put("GSP", "GPE");
        standardType.put("PER", "PERSON");
        standardType.put("ORG", "ORGANIZATION");
        standardType.put("LOC", "LOCATION");
        standardType.put("FAC", "FACILITY");
    }
}

