/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.srl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;

public class PrecisionAndRecallForSRL {
    public static final String OPT_PREDICTIONS_FILES = "predictions";
    public static final String OPT_INSTANCE_FILES = "truthfile";

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_PREDICTIONS_FILES, "file", "directory containing the predictions of the classifiers");
        cmdOpts.addOption(OPT_INSTANCE_FILES, "file", "file containing the instances being classified");
        return cmdOpts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(PrecisionAndRecallForSRL.createOptions(), args);
        File outputFiles = new File(cmdLine.getStringValue(OPT_PREDICTIONS_FILES));
        File truthFile = new File(cmdLine.getStringValue(OPT_INSTANCE_FILES));
        HashMap<String, String> labelToClassTruth = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(truthFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split = line.split("\\t+");
            labelToClassTruth.put(split[0], split[1]);
        }
        reader.close();
        HashMap<String, String> labelToPredicted = new HashMap<String, String>();
        for (File outputFile : outputFiles.listFiles()) {
            reader = new BufferedReader(new FileReader(outputFile));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\s+");
                labelToPredicted.put(split[1], split[2]);
            }
            reader.close();
        }
        System.err.println("Label to predicted size: " + labelToPredicted.size());
        System.err.println("Label to class truth size: " + labelToClassTruth.size());
        HashMap<String, IntHolder> classToNumOutThereTRUTH = new HashMap<String, IntHolder>();
        HashMap<String, IntHolder> classToNumPredicted = new HashMap<String, IntHolder>();
        HashMap<String, IntHolder> classToNumberOfCorrectPredicitions = new HashMap<String, IntHolder>();
        for (String label : labelToPredicted.keySet()) {
            String prediction = (String)labelToPredicted.get(label);
            String truth = (String)labelToClassTruth.get(label);
            IntHolder numPredicted = (IntHolder)classToNumPredicted.get(prediction);
            if (numPredicted == null) {
                numPredicted = new IntHolder(0);
                classToNumPredicted.put(prediction, numPredicted);
            }
            ++numPredicted.val;
            if (truth == null) {
                System.err.println("Null truth: " + label);
            }
            if (prediction.equals(truth)) {
                IntHolder numCorrect = (IntHolder)classToNumberOfCorrectPredicitions.get(prediction);
                if (numCorrect == null) {
                    numCorrect = new IntHolder(0);
                    classToNumberOfCorrectPredicitions.put(prediction, numCorrect);
                }
                ++numCorrect.val;
                continue;
            }
            System.err.println(prediction + " vs " + truth + " for " + label);
        }
        for (String label : labelToClassTruth.keySet()) {
            String truth = (String)labelToClassTruth.get(label);
            IntHolder numOutThere = (IntHolder)classToNumOutThereTRUTH.get(truth);
            if (numOutThere == null) {
                numOutThere = new IntHolder(0);
                classToNumOutThereTRUTH.put(truth, numOutThere);
            }
            ++numOutThere.val;
        }
        HashSet clazzes = new HashSet(classToNumOutThereTRUTH.keySet());
        clazzes.addAll(classToNumPredicted.keySet());
        for (String clazzType : clazzes) {
            IntHolder numOutThereH = (IntHolder)classToNumOutThereTRUTH.get(clazzType);
            IntHolder numCorrectH = (IntHolder)classToNumberOfCorrectPredicitions.get(clazzType);
            IntHolder numPredictedH = (IntHolder)classToNumPredicted.get(clazzType);
            double numOutThere = numOutThereH == null ? 0.0 : (double)numOutThereH.val;
            double numCorrect = numCorrectH == null ? 0.0 : (double)numCorrectH.val;
            double numPredicted = numPredictedH == null ? 0.0 : (double)numPredictedH.val;
            double precision = numCorrect / numPredicted;
            double recall = numCorrect / numOutThere;
            System.err.println(clazzType + "\t" + numCorrect + "\t" + numPredicted + "\t" + numOutThere + "\t" + precision + "\t" + recall);
        }
    }

    public static class IntHolder {
        int val;

        public IntHolder(int val) {
            this.val = val;
        }
    }
}

