/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.featgen.MultiStepFeatureGenerator;
import tratz.ml.ClassScoreTuple;
import tratz.ml.LinearClassificationModel;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;
import tratz.semantics.ModelNameLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassificationBundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected MultiStepFeatureGenerator mFeatGen;
    protected Map<String, LinearClassificationModel> mModelMap;
    protected LinearClassificationModel mSingleModel;
    protected ModelNameLookup mModelNameLookup;

    public ClassificationBundle(MultiStepFeatureGenerator featGen, Map<String, LinearClassificationModel> models, ModelNameLookup modelNameLookup) {
        this.mFeatGen = featGen;
        this.mModelMap = models;
        this.mModelNameLookup = modelNameLookup;
    }

    public ClassificationBundle(MultiStepFeatureGenerator featGen, LinearClassificationModel model) {
        this.mFeatGen = featGen;
        this.mSingleModel = model;
    }

    public ClassScoreTuple[] getPredictions(String arcType, List<Token> tokens, Parse parse, int wordIndex) {
        ClassScoreTuple[] retValue = null;
        Set<String> features = this.mFeatGen.generateFeatures(tokens, parse, wordIndex);
        if (this.mSingleModel != null) {
            retValue = this.mSingleModel.getDecision(features);
        } else {
            LinearClassificationModel model;
            String modelName = this.mModelNameLookup.determineModelName(arcType, tokens, parse, wordIndex);
            if (modelName != null && (model = this.mModelMap.get(modelName)) != null) {
                retValue = model.getDecision(features);
            }
        }
        return retValue;
    }
}

