/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tratz.parse.io.SentenceReader;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

public class ConllxSentenceReader
implements SentenceReader {
    private Map<String, String> mCanon = new HashMap<String, String>();

    public Parse readSentence(BufferedReader reader) throws IOException {
        Token root = new Token("[ROOT]", 0);
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<Arc> arcs = new ArrayList<Arc>();
        String line = null;
        HashMap<Integer, Token> numToToken = new HashMap<Integer, Token>();
        numToToken.put(0, root);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) {
                if (tokens.size() != 0) break;
                continue;
            }
            lines.add(line);
            String[] split = line.split("\\t+");
            int tokenNum = Integer.parseInt(split[0]);
            String text = this.canon(split[1]);
            Token token = new Token(text, tokenNum);
            String pos = this.canon(split[4]);
            String coarsePos = this.canon(split[3]);
            token.setCoarsePos(coarsePos);
            token.setPos(pos);
            tokens.add(token);
            numToToken.put(tokenNum, token);
        }
        for (String l : lines) {
            String[] split = l.split("\\t+");
            int tokenNum = Integer.parseInt(split[0]);
            int head = Integer.parseInt(split[6]);
            String dependency = this.canon(split[7]);
            String pos = this.canon(split[4]);
            String coarsePos = this.canon(split[3]);
            Token t1 = (Token)numToToken.get(tokenNum);
            Token t2 = (Token)numToToken.get(head);
            t1.setPos(pos);
            t1.setCoarsePos(coarsePos);
            arcs.add(new Arc(t1, t2, dependency));
        }
        Parse result = null;
        if (tokens.size() > 0) {
            result = new Parse(new Sentence(tokens), root, arcs);
        }
        return result;
    }

    private String canon(String s) {
        String canon = this.mCanon.get(s);
        if (canon == null) {
            canon = s;
            this.mCanon.put(s, canon);
        }
        return canon;
    }
}

