/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;
import tratz.util.TreebankConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceFramesFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        POS pos = null;
        if (TreebankConstants.VERB_LABELS.contains(type)) {
            pos = POS.VERB;
            IndexEntry entry = WordNet.getInstance().getMorpho().lookupIndexEntry(pos, input, true);
            if (entry != null) {
                Sense[] senses = entry.getSenses();
                for (int s = 0; s < senses.length && s < this.mMaxSenseNum; ++s) {
                    Sense sense = senses[s];
                    for (Sense.Key key : sense.getKeys()) {
                        int[] sentenceFrames = key.getFrames();
                        int numFrames = sentenceFrames.length;
                        for (int i = 0; i < numFrames; ++i) {
                            productions.add(Integer.toString(sentenceFrames[i]));
                        }
                    }
                }
            }
        }
        return productions;
    }
}

