/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HypernymsFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos != null && (entry = WordNet.getInstance().lookupIndexEntry(pos, input, false)) != null && pos != POS.ADJECTIVE && pos != POS.ADVERB) {
            this.addHypernymsForEntry(entry, productions);
        }
        return productions;
    }

    private final void addHypernymsForEntry(IndexEntry entry, Set<String> productions) {
        Sense[] senses = entry.getSenses();
        for (int i = 0; i < senses.length && i < this.mMaxSenseNum; ++i) {
            Pointer[] hyperPointers;
            Sense sense = senses[i];
            for (Pointer p : hyperPointers = sense.getSemPointers(PointerType.HYPERNYM, PointerType.INSTANCE_HYPERNYM)) {
                this.addHypernyms(productions, p.getTargetSense(), 0);
            }
        }
    }

    private void addHypernyms(Set<String> productions, Sense sense, int level) {
        if (level < 15) {
            Pointer[] hyperPointers = sense.getSemPointers(PointerType.HYPERNYM, PointerType.INSTANCE_HYPERNYM);
            for (Sense.Key key : sense.getKeys()) {
                productions.add(key.getLemma());
            }
            for (Pointer p : hyperPointers) {
                this.addHypernyms(productions, p.getTargetSense(), level + 1);
            }
        }
    }
}

