/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryCatalog;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public class DictionaryCatalogSet {
    private Map _catalogs = new HashMap();

    public DictionaryCatalogSet(String string, Class clazz) {
        string = string.trim();
        int n = 0;
        while (n < DictionaryFileType.FILE_TYPES.length) {
            DictionaryCatalog dictionaryCatalog = new DictionaryCatalog(string, DictionaryFileType.FILE_TYPES[n], clazz);
            this._catalogs.put(dictionaryCatalog.getKey(), dictionaryCatalog);
            ++n;
        }
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            Iterator iterator = this.getCatalogIterator();
            while (iterator.hasNext()) {
                ((DictionaryCatalog)iterator.next()).open();
            }
        }
    }

    public boolean isOpen() {
        Iterator iterator = this.getCatalogIterator();
        while (iterator.hasNext()) {
            if (((DictionaryCatalog)iterator.next()).isOpen()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        Iterator iterator = this.getCatalogIterator();
        while (iterator.hasNext()) {
            ((DictionaryCatalog)iterator.next()).close();
        }
    }

    public DictionaryCatalog get(DictionaryFileType dictionaryFileType) {
        return (DictionaryCatalog)this._catalogs.get(dictionaryFileType);
    }

    public int size() {
        return this._catalogs.size();
    }

    public Iterator getCatalogIterator() {
        return this._catalogs.values().iterator();
    }

    public DictionaryFile getDictionaryFile(POS pOS, DictionaryFileType dictionaryFileType) {
        return this.get(dictionaryFileType).get(pOS);
    }
}

