/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import tratz.featgen.InitException;
import tratz.featgen.fer.AbstractFeatureRule;
import tratz.rogi.Roget;
import tratz.util.TreebankConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RogetsHierarchyFER
extends AbstractFeatureRule {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_DEFAULT_POS = "DefaultPos";
    private String mDefaultPos;

    @Override
    public void init(Map<String, String> params) throws InitException {
        super.init(params);
        this.mDefaultPos = params.get(PARAM_DEFAULT_POS);
    }

    @Override
    public Set<String> getProductions(String input, String type, Set<String> results) {
        Set<Roget.Term> terms;
        if (Roget.getInstance() == null) {
            try {
                Roget.init();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (type == null) {
            type = this.mDefaultPos;
        }
        Roget.POS pos = null;
        if (TreebankConstants.NOUN_LABELS.contains(type)) {
            pos = Roget.POS.N;
        } else if (TreebankConstants.VERB_LABELS.contains(type)) {
            pos = Roget.POS.V;
        } else if (TreebankConstants.ADJ_LABELS.contains(type)) {
            pos = Roget.POS.ADJ;
        }
        if (pos != null && (terms = Roget.getInstance().getTerms(pos, input)) != null) {
            for (Roget.Term t : terms) {
                Roget.Entry entry = t.getEntry();
                results.add("re:" + entry.getNum());
                for (Roget.Division div = entry.getDivision(); div != null; div = div.getParent()) {
                    results.add("rd:" + div.getName().hashCode());
                }
            }
        }
        return results;
    }
}

