/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import pnuts.lang.Context;
import pnuts.lang.Generator;
import pnuts.lang.Indexed;
import pnuts.lang.Java2Configuration;
import pnuts.lang.Package;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Property;
import pnuts.lang.Runtime;

class MerlinConfiguration
extends Java2Configuration {
    MerlinConfiguration() {
    }

    MerlinConfiguration(Class stopClass) {
        super(stopClass);
    }

    public Object getElement(Context context, Object target, Object key) {
        if (target instanceof Object[]) {
            if (key instanceof Number) {
                return ((Object[])target)[((Number)key).intValue()];
            }
            if (key instanceof PnutsFunction) {
                return Java2Configuration.filterGenerator((Object[])target, (PnutsFunction)key, context);
            }
        } else if (target instanceof Indexed) {
            if (key instanceof Number) {
                return ((Indexed)target).get(((Number)key).intValue());
            }
            if (key instanceof String) {
                return this.getBeanProperty(context, target, (String)key);
            }
        } else {
            if (target instanceof Package) {
                return ((Property)target).get(((String)key).intern(), context);
            }
            if (target instanceof Property) {
                return ((Property)target).get((String)key, context);
            }
            if (target instanceof Map) {
                return ((Map)target).get(key);
            }
            if (target instanceof Context) {
                return ((Context)target).get(((String)key).intern());
            }
            if (target instanceof Generator) {
                if (key instanceof Number) {
                    return Java2Configuration.generateNth((Generator)target, ((Number)key).intValue(), context);
                }
                if (key instanceof PnutsFunction) {
                    return Java2Configuration.filterGenerator((Generator)target, (PnutsFunction)key, context);
                }
            } else if (key instanceof PnutsFunction) {
                if (target instanceof Collection) {
                    return Java2Configuration.filterGenerator((Collection)target, (PnutsFunction)key, context);
                }
                if (target instanceof int[] || target instanceof byte[] || target instanceof short[] || target instanceof char[] || target instanceof long[] || target instanceof float[] || target instanceof double[] || target instanceof boolean[]) {
                    return Java2Configuration.filterGenerator(target, (PnutsFunction)key, context);
                }
            } else {
                if (key instanceof String) {
                    return this.getBeanProperty(context, target, (String)key);
                }
                if (key instanceof Number) {
                    if (target instanceof List) {
                        return ((List)target).get(((Number)key).intValue());
                    }
                    if (target instanceof String) {
                        return new Character(((String)target).charAt(((Number)key).intValue()));
                    }
                    if (target instanceof CharSequence) {
                        return new Character(((CharSequence)target).charAt(((Number)key).intValue()));
                    }
                    if (target instanceof int[]) {
                        return new Integer(((int[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof byte[]) {
                        return new Byte(((byte[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof char[]) {
                        return new Character(((char[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof float[]) {
                        return new Float(((float[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof double[]) {
                        return new Double(((double[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof boolean[]) {
                        return ((boolean[])target)[((Number)key).intValue()];
                    }
                    if (target instanceof long[]) {
                        return new Long(((long[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof short[]) {
                        return new Short(((short[])target)[((Number)key).intValue()]);
                    }
                }
            }
        }
        throw new PnutsException("illegal argument [key: " + String.valueOf(key) + ", target: " + target + "]", context);
    }

    public Object getRange(Context context, Object target, Object idx1, Object idx2) {
        int from = ((Number)idx1).intValue();
        int to = -1;
        if (idx2 != null) {
            to = ((Number)idx2).intValue();
        }
        if (target instanceof CharSequence) {
            CharSequence s = (CharSequence)target;
            int len = s.length();
            if (from > len - 1) {
                return s.subSequence(0, 0);
            }
            if (idx2 != null) {
                if (from > to || to < 0) {
                    return s.subSequence(0, 0);
                }
                if (from < 0) {
                    from = 0;
                }
                if (to > len - 1) {
                    to = len - 1;
                }
                return s.subSequence(from, to + 1);
            }
            if (from < 0) {
                from = 0;
            }
            return s.subSequence(from, len);
        }
        if (Runtime.isArray(target)) {
            int size;
            Class<?> c = target.getClass().getComponentType();
            int len = Runtime.getArrayLength(target);
            if (from > len - 1) {
                return Array.newInstance(c, 0);
            }
            if (idx2 == null) {
                to = len - 1;
            } else {
                if (from > to || to < 0) {
                    return Array.newInstance(c, 0);
                }
                if (to > len - 1) {
                    to = len - 1;
                }
            }
            if (from < 0) {
                from = 0;
            }
            if ((size = to - from + 1) < 0) {
                size = 0;
            } else if (from + size > len) {
                size = len - from;
            }
            Object ret = Array.newInstance(c, size);
            if (size > 0) {
                System.arraycopy(target, from, ret, 0, size);
            }
            return ret;
        }
        if (target instanceof List) {
            List list = (List)target;
            try {
                int size = list.size();
                if (from < 0) {
                    from = 0;
                } else if (from > size) {
                    from = size;
                }
                if (idx2 == null) {
                    to = size;
                } else if (from > to || to < 0) {
                    to = from;
                } else if (++to > size) {
                    to = size;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return list.subList(from, to);
        }
        if (target instanceof Generator) {
            if (idx2 != null) {
                if (from > to || to < 0) {
                    from = -1;
                    to = -1;
                } else if (from < 0) {
                    from = 0;
                }
            } else {
                to = -1;
                if (from < 0) {
                    from = 0;
                }
            }
            return new Runtime.RangeGenerator((Generator)target, from, to);
        }
        throw new PnutsException("illegal.type", new Object[]{target}, context);
    }

    public Enumeration toEnumeration(Object obj) {
        Enumeration en = super.toEnumeration(obj);
        if (en == null && obj instanceof CharSequence) {
            en = new CharSequenceEnum((CharSequence)obj);
        }
        return en;
    }

    static class CharSequenceEnum
    implements Enumeration {
        CharSequence seq;
        int len;
        int pos = 0;

        CharSequenceEnum(CharSequence seq) {
            this.seq = seq;
            this.len = seq.length();
        }

        public boolean hasMoreElements() {
            return this.len > this.pos;
        }

        public Object nextElement() {
            return new Character(this.seq.charAt(this.pos++));
        }
    }
}

