/*
 * Decompiled with CFR 0.152.
 */
package Jet;

import AceJet.Datum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.PlainTextGISModelReader;
import opennlp.maxent.io.PlainTextGISModelWriter;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;

public class MaxEntModel {
    String featureFileName;
    String modelFileName;
    PrintStream featureWriter = null;
    GISModel model = null;
    int cutoff = 4;
    int iterations = 100;

    public MaxEntModel() {
    }

    public MaxEntModel(String string, String string2) {
        this.featureFileName = string;
        this.modelFileName = string2;
    }

    public void initializeForTraining(String string) {
        this.featureFileName = string;
        this.initializeForTraining();
    }

    public void initializeForTraining() {
        if (this.featureFileName == null) {
            System.out.println("MaxEntModel.initializeForTraining: no featureFileName specified");
        } else {
            try {
                this.featureWriter = new PrintStream(new FileOutputStream(this.featureFileName));
            }
            catch (IOException iOException) {
                System.out.print("Unable to create feature file: ");
                System.out.println(iOException);
            }
        }
    }

    public void addEvent(Datum datum) {
        if (this.featureWriter == null) {
            this.initializeForTraining();
        }
        this.featureWriter.println(datum.toString());
    }

    public void setCutoff(int n) {
        this.cutoff = n;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public void buildModel() {
        boolean bl = false;
        double d = 0.1;
        boolean bl2 = true;
        try {
            this.featureWriter.close();
            FileReader fileReader = new FileReader(new File(this.featureFileName));
            BasicEventStream basicEventStream = new BasicEventStream(new PlainTextByLineDataStream(fileReader));
            GIS.SMOOTHING_OBSERVATION = d;
            this.model = GIS.trainModel(basicEventStream, this.iterations, this.cutoff, bl, bl2);
        }
        catch (Exception exception) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(exception);
        }
    }

    public void saveModel() {
        if (this.modelFileName == null) {
            System.out.println("MaxEntModel.saveModel:  no modelFileName specified");
        } else {
            this.saveModel(this.modelFileName);
        }
    }

    public void saveModel(String string) {
        try {
            File file = new File(string);
            SuffixSensitiveGISModelWriter suffixSensitiveGISModelWriter = new SuffixSensitiveGISModelWriter(this.model, file);
            suffixSensitiveGISModelWriter.persist();
        }
        catch (IOException iOException) {
            System.out.print("Unable to save model: ");
            System.out.println(iOException);
        }
    }

    public void saveModel(BufferedWriter bufferedWriter) {
        try {
            PlainTextGISModelWriter plainTextGISModelWriter = new PlainTextGISModelWriter((AbstractModel)this.model, bufferedWriter);
            plainTextGISModelWriter.persist();
        }
        catch (IOException iOException) {
            System.out.print("Unable to save model: ");
            System.out.println(iOException);
        }
    }

    public void loadModel() {
        if (this.modelFileName == null) {
            System.out.println("MaxEntModel.loadModel:  no modelFileName specified");
        } else {
            this.loadModel(this.modelFileName);
        }
    }

    public void loadModel(String string) {
        try {
            File file = new File(string);
            this.model = (GISModel)new SuffixSensitiveGISModelReader(file).getModel();
            System.out.println("GIS model " + file.getName() + " loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public void loadModel(BufferedReader bufferedReader) {
        try {
            this.model = (GISModel)new PlainTextGISModelReader(bufferedReader).getModel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public boolean isLoaded() {
        return this.model != null;
    }

    public double prob(Datum datum, String string) {
        return this.model.eval(datum.toArray())[this.model.getIndex(string)];
    }

    public String bestOutcome(Datum datum) {
        return this.model.getBestOutcome(this.model.eval(datum.toArray())).intern();
    }

    public int getNumOutcomes() {
        return this.model.getNumOutcomes();
    }

    public String getOutcome(int n) {
        return this.model.getOutcome(n);
    }

    public double[] getOutcomeProbabilities(Datum datum) {
        return this.model.eval(datum.toArray());
    }
}

