/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.AbstractDictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public class DictionaryCatalog {
    private Map _files = new HashMap();
    private DictionaryFileType _fileType;

    public DictionaryCatalog(String string, DictionaryFileType dictionaryFileType, Class clazz) throws JWNLRuntimeException {
        this._fileType = dictionaryFileType;
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            DictionaryFile dictionaryFile = (DictionaryFile)constructor.newInstance(null);
            int n = 0;
            while (n < POS.CATS.length) {
                DictionaryFile dictionaryFile2 = dictionaryFile.newInstance(string, POS.CATS[n], dictionaryFileType);
                this._files.put(dictionaryFile2.getPOS(), dictionaryFile2);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_0018", new Object[]{dictionaryFileType, clazz}, (Throwable)exception);
        }
    }

    public Object getKey() {
        return this.getFileType();
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            Iterator iterator = this.getFileIterator();
            while (iterator.hasNext()) {
                ((DictionaryFile)iterator.next()).open();
            }
        }
    }

    public boolean isOpen() {
        Iterator iterator = this.getFileIterator();
        while (iterator.hasNext()) {
            if (((DictionaryFile)iterator.next()).isOpen()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        Iterator iterator = this.getFileIterator();
        while (iterator.hasNext()) {
            ((AbstractDictionaryFile)iterator.next()).close();
        }
    }

    public int size() {
        return this._files.size();
    }

    public Iterator getFileIterator() {
        return this._files.values().iterator();
    }

    public DictionaryFile get(POS pOS) {
        return (DictionaryFile)this._files.get(pOS);
    }

    public DictionaryFileType getFileType() {
        return this._fileType;
    }
}

