/*
 * Decompiled with CFR 0.152.
 */
package tratz.rogi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Roget {
    private static Roget mRoget;
    static int count;
    public final Matcher NEW_ENTRY_MATCHER = Pattern.compile("\\s*#([0-9ab]+)\\.(.*)--\\s+N\\.(.*)").matcher("");
    private static final Matcher LINK_MATCHER1;
    private static final Matcher LINK_MATCHER2;
    private static final Matcher LINK_MATCHER3;
    public static final int Thesaurus = 0;
    public static final int Class = 1;
    public static final int Division = 2;
    public static final int Section = 3;
    public static final int Subsection = 4;
    public static final int Unnamed = 5;
    public static final int Number = 6;
    public static final int Numeral = 7;
    public static final int Dash = 8;
    private Division mTopDivision;
    private Map<POS, Map<String, Set<Term>>> mPosToTerm = new HashMap<POS, Map<String, Set<Term>>>();
    private Map<String, Set<Term>> mStringToTerm = new HashMap<String, Set<Term>>();

    public static Roget init() throws IOException {
        mRoget = new Roget(Roget.class.getResource("/roget15aMod.txt"));
        return mRoget;
    }

    public static Roget getInstance() {
        return mRoget;
    }

    public Set<Term> getTerms(POS pos, String string) {
        return this.mPosToTerm.get((Object)pos).get(string);
    }

    public Map<String, Set<Term>> getTermsMap(POS pos) {
        return this.mPosToTerm.get((Object)pos);
    }

    public Set<Term> getTerms(String string) {
        return this.mStringToTerm.get(string);
    }

    private Roget(URL fileURL) throws IOException {
        Division currentDivision;
        if (mRoget == null) {
            mRoget = this;
        }
        this.mTopDivision = currentDivision = new Division("Roget's Thesaurus", 0, null);
        String line = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileURL.openStream()));
        StringBuilder temp = new StringBuilder();
        boolean notFoundYet = true;
        Entry currEntry = null;
        POS currPOS = POS.N;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("*** END OF THE PROJECT GUTENBERG EBOOK")) {
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                break;
            }
            if (notFoundYet) {
                if (!line.matches("\\s*BEGIN THESAURUS\\s*")) continue;
                notFoundYet = false;
                continue;
            }
            if (line.matches("\\s*<--.*-->\\s*")) continue;
            line = line.replace("[obs3]", "");
            line = line.replace("|", "");
            line = line.replace("!", "");
            line = line.replace("&c,", "&c.");
            if ((line = line.replace("&c..", "&c.")).matches("\\s*[0-9]\\..*")) {
                // empty if block
            }
            if (line.startsWith("%")) {
                String name = line.substring(1).trim();
                int type = line.contains("CLASS") ? 1 : (line.contains("SUBSECTION") ? 4 : (line.contains("SECTION") ? 3 : (line.contains("DIVISION") ? 2 : (line.matches("%\\([0-9]*\\).*") ? 6 : (line.matches("%\\s*\\([iv]*\\).*") ? 7 : (line.startsWith("%-") ? 8 : 5))))));
                while (type <= currentDivision.mType) {
                    currentDivision = currentDivision.mParent;
                }
                Division newDivision = new Division(name, type, currentDivision);
                currentDivision.mDivisions.add(newDivision);
                currentDivision = newDivision;
                continue;
            }
            String lt = line.trim();
            if (lt.startsWith("V.") || lt.startsWith("V[")) {
                lt = lt.startsWith("V[") ? lt.substring(lt.indexOf("].") + 2) : lt.substring(2);
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                temp.setLength(0);
                currPOS = POS.V;
                temp.append(lt).append(" ");
                continue;
            }
            if (lt.startsWith("Adj.")) {
                lt = lt.substring(4);
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                temp.setLength(0);
                currPOS = POS.ADJ;
                temp.append(lt).append(" ");
                continue;
            }
            if (lt.startsWith("Int.")) {
                lt = lt.substring(4);
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                temp.setLength(0);
                currPOS = POS.INT;
                temp.append(lt).append(" ");
                continue;
            }
            if (lt.startsWith("Phr.") | lt.startsWith("Phr[")) {
                lt = lt.startsWith("Phr[") ? lt.substring(lt.indexOf("].") + 2) : lt.substring(4);
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                temp.setLength(0);
                currPOS = POS.PHR;
                temp.append(lt).append(" ");
                continue;
            }
            if (lt.startsWith("Adv.") || lt.matches("\\s*#[0-9ab]+\\.(.*)--\\s+Adv\\..*")) {
                lt = lt.substring(4);
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                temp.setLength(0);
                currPOS = POS.ADV;
                temp.append(lt).append(" ");
                continue;
            }
            if (lt.startsWith("#")) {
                if (currEntry != null) {
                    ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                    temp.setLength(0);
                }
                this.NEW_ENTRY_MATCHER.reset(lt);
                if (!this.NEW_ENTRY_MATCHER.matches()) {
                    // empty if block
                }
                String g1 = this.NEW_ENTRY_MATCHER.group(1);
                String g2 = this.NEW_ENTRY_MATCHER.group(2).trim();
                String g3 = this.NEW_ENTRY_MATCHER.group(3);
                currEntry = new Entry(currentDivision, g1, g2);
                currentDivision.mEntries.add(currEntry);
                currPOS = POS.N;
                temp.append(g3).append(" ");
                continue;
            }
            if (!lt.equals("") && line.startsWith("     ")) {
                if (currEntry == null) continue;
                ((List)currEntry.mPosToTerms.get((Object)currPOS)).add(this.createTermSet(temp.toString(), currEntry, currPOS));
                temp.setLength(0);
                temp.append(lt).append(" ");
                continue;
            }
            if (lt.equals("")) continue;
            temp.append(lt).append(" ");
        }
        temp.append(line).append(" ");
        reader.close();
    }

    public Division getTopDivision() {
        return this.mTopDivision;
    }

    private Set<Term> createTermSet(String input, Entry entry, POS pos) {
        String[] pieces = input.split("[,;]");
        HashSet<Term> termSet = new HashSet<Term>();
        for (String piece : pieces) {
            String g2;
            String g1;
            piece = piece.trim();
            LINK_MATCHER1.reset(piece);
            LINK_MATCHER2.reset(piece);
            LINK_MATCHER3.reset(piece);
            String termPart = piece;
            if (LINK_MATCHER1.matches()) {
                g1 = LINK_MATCHER1.group(1);
                g2 = LINK_MATCHER1.group(2);
                String g3 = LINK_MATCHER1.group(3);
                String g4 = LINK_MATCHER1.group(4);
                String g5 = LINK_MATCHER1.group(5);
                if (g5 != null) {
                    // empty if block
                }
                termPart = g1.trim();
            } else if (LINK_MATCHER2.matches()) {
                g1 = LINK_MATCHER2.group(1);
                g2 = LINK_MATCHER2.group(2);
                termPart = g1.trim();
            } else if (LINK_MATCHER3.matches() || piece.endsWith("&c.") || piece.endsWith("&c") || piece.contains("&c") || !piece.contains("&c") || input.matches(".*&c. [^;, ]*\\s*") || piece.startsWith("&c") || !piece.endsWith("&c.")) {
                // empty if block
            }
            if (termPart.endsWith(".") && termPart.length() > 1) {
                termPart = termPart.substring(0, termPart.length() - 1);
            }
            if (termPart.equals("") || termPart.equals(".")) continue;
            Term newTerm = new Term(termPart, entry);
            Set<Term> terms = this.mStringToTerm.get(termPart);
            if (terms == null) {
                terms = new HashSet<Term>();
                this.mStringToTerm.put(termPart, terms);
            }
            terms.add(newTerm);
            Map<String, Set<Term>> sToTerm = this.mPosToTerm.get((Object)pos);
            if (sToTerm == null) {
                sToTerm = new HashMap<String, Set<Term>>();
                this.mPosToTerm.put(pos, sToTerm);
            }
            if ((terms = sToTerm.get(termPart)) == null) {
                terms = new HashSet<Term>();
                sToTerm.put(termPart, terms);
            }
            terms.add(newTerm);
            termSet.add(newTerm);
        }
        return termSet;
    }

    static {
        count = 0;
        LINK_MATCHER1 = Pattern.compile("(.+)&c(\\.)?\\s*(\\(([^0-9]*)\\))?\\s*([0-9ab]+)\\s*(\\[.*\\])?\\.?").matcher("");
        LINK_MATCHER2 = Pattern.compile("(.+)&c(\\.)?\\s*(n|v|V|adj|Adj|adv)\\.?").matcher("");
        LINK_MATCHER3 = Pattern.compile("(.+)&c(\\.)?\\s+([^0-9]+).*").matcher("");
    }

    public static class Link {
        int linkNum;
        String linkType;
        String linkTermText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Term {
        private final Entry mEntry;
        private final String mTerm;
        private final List<Link> mLinks = new ArrayList<Link>(0);

        public Term(String term, Entry entry) {
            this.mTerm = term;
            this.mEntry = entry;
        }

        public Entry getEntry() {
            return this.mEntry;
        }

        public String getString() {
            return this.mTerm;
        }

        public List<Link> getLinks() {
            return this.mLinks;
        }

        public String toString() {
            return this.mTerm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        private final Division mDivision;
        private final String mNum;
        private final String mName;
        private final Map<POS, List<Set<Term>>> mPosToTerms = new HashMap<POS, List<Set<Term>>>();

        public Entry(Division division, String num, String name) {
            this.mDivision = division;
            this.mNum = num;
            this.mName = name;
            this.mPosToTerms.put(POS.N, new ArrayList());
            this.mPosToTerms.put(POS.V, new ArrayList());
            this.mPosToTerms.put(POS.ADJ, new ArrayList());
            this.mPosToTerms.put(POS.ADV, new ArrayList());
            this.mPosToTerms.put(POS.PHR, new ArrayList());
            this.mPosToTerms.put(POS.INT, new ArrayList());
        }

        public Division getDivision() {
            return this.mDivision;
        }

        public String getNum() {
            return this.mNum;
        }

        public String getName() {
            return this.mName;
        }

        public List<Set<Term>> getTerms(POS pos) {
            return this.mPosToTerms.get((Object)pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Division {
        private final String mName;
        private final int mType;
        private final Division mParent;
        private final List<Division> mDivisions = new ArrayList<Division>(0);
        private final List<Entry> mEntries = new ArrayList<Entry>(0);

        public Division(String name, int type, Division parent) {
            this.mName = name;
            this.mType = type;
            this.mParent = parent;
        }

        public String getName() {
            return this.mName;
        }

        public int getType() {
            return this.mType;
        }

        public Division getParent() {
            return this.mParent;
        }

        public List<Division> getDivisions() {
            return this.mDivisions;
        }

        public List<Entry> getEntries() {
            return this.mEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum POS {
        N,
        V,
        ADJ,
        ADV,
        PHR,
        INT;

    }
}

