/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedFormFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos != null && (entry = WordNet.getInstance().getMorpho().lookupIndexEntry(pos, input, true)) != null) {
            for (Sense sense : entry.getSenses()) {
                Pointer[] derForms;
                for (Pointer ptr : derForms = sense.getPointers(PointerType.DERIVED_FORM)) {
                    for (Sense.Key key : ptr.getTargetSense().getKeys()) {
                        productions.add(key.getLemma());
                    }
                }
            }
        }
        return productions;
    }
}

