/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import opennlp.model.AbstractModel;
import opennlp.model.DataIndexer;
import opennlp.model.EvalParameters;
import opennlp.model.MutableContext;
import opennlp.perceptron.PerceptronModel;

public class PerceptronTrainer {
    private int numUniqueEvents;
    private int numEvents;
    private int numPreds;
    private int numOutcomes;
    private int[][] contexts;
    private float[][] values;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] params;
    private int[][][] updates;
    private int VALUE = 0;
    private int ITER = 1;
    private int EVENT = 2;
    private MutableContext[] averageParams;
    private EvalParameters evalParams;
    private boolean printMessages = true;
    double[] modelDistribution;
    private int iterations;
    private boolean useAverage;

    public AbstractModel trainModel(int n, DataIndexer dataIndexer, int n2) {
        this.iterations = n;
        return this.trainModel(n, dataIndexer, n2, true);
    }

    public AbstractModel trainModel(int n, DataIndexer dataIndexer, int n2, boolean bl) {
        int n3;
        this.display("Incorporating indexed data for training...  \n");
        this.useAverage = bl;
        this.contexts = dataIndexer.getContexts();
        this.values = dataIndexer.getValues();
        this.numTimesEventsSeen = dataIndexer.getNumTimesEventsSeen();
        this.numEvents = dataIndexer.getNumEvents();
        this.numUniqueEvents = this.contexts.length;
        this.iterations = n;
        this.outcomeLabels = dataIndexer.getOutcomeLabels();
        this.outcomeList = dataIndexer.getOutcomeList();
        this.predLabels = dataIndexer.getPredLabels();
        this.numPreds = this.predLabels.length;
        this.numOutcomes = this.outcomeLabels.length;
        if (bl) {
            this.updates = new int[this.numPreds][this.numOutcomes][3];
        }
        this.display("done.\n");
        this.display("\tNumber of Event Tokens: " + this.numUniqueEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        this.params = new MutableContext[this.numPreds];
        if (bl) {
            this.averageParams = new MutableContext[this.numPreds];
        }
        this.evalParams = new EvalParameters(this.params, this.numOutcomes);
        int[] nArray = new int[this.numOutcomes];
        for (n3 = 0; n3 < this.numOutcomes; ++n3) {
            nArray[n3] = n3;
        }
        for (n3 = 0; n3 < this.numPreds; ++n3) {
            this.params[n3] = new MutableContext(nArray, new double[this.numOutcomes]);
            if (bl) {
                this.averageParams[n3] = new MutableContext(nArray, new double[this.numOutcomes]);
            }
            for (int i = 0; i < this.numOutcomes; ++i) {
                this.params[n3].setParameter(i, 0.0);
                if (!bl) continue;
                this.averageParams[n3].setParameter(i, 0.0);
            }
        }
        this.modelDistribution = new double[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(n);
        this.display("...done.\n");
        if (bl) {
            return new PerceptronModel(this.averageParams, this.predLabels, this.outcomeLabels);
        }
        return new PerceptronModel(this.params, this.predLabels, this.outcomeLabels);
    }

    private void display(String string) {
        if (this.printMessages) {
            System.out.print(string);
        }
    }

    private void findParameters(int n) {
        this.display("Performing " + n + " iterations.\n");
        for (int i = 1; i <= n; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            this.nextIteration(i);
        }
        if (this.useAverage) {
            this.trainingStats(this.averageParams);
        } else {
            this.trainingStats(this.params);
        }
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    private void nextIteration(int n) {
        int n2;
        int n3;
        --n;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.numUniqueEvents) {
            for (int i = 0; i < this.numTimesEventsSeen[n6]; ++i) {
                int n7;
                for (n3 = 0; n3 < this.numOutcomes; ++n3) {
                    this.modelDistribution[n3] = 0.0;
                }
                if (this.values != null) {
                    PerceptronModel.eval(this.contexts[n6], this.values[n6], this.modelDistribution, this.evalParams, false);
                } else {
                    PerceptronModel.eval(this.contexts[n6], null, this.modelDistribution, this.evalParams, false);
                }
                n3 = 0;
                for (n7 = 1; n7 < this.numOutcomes; ++n7) {
                    if (!(this.modelDistribution[n7] > this.modelDistribution[n3])) continue;
                    n3 = n7;
                }
                int n8 = n7 = n3 == this.outcomeList[n5] ? 1 : 0;
                if (n7 != 0) {
                    ++n4;
                }
                for (n2 = 0; n2 < this.numOutcomes; ++n2) {
                    int n9;
                    int n10;
                    if (n2 == this.outcomeList[n5]) {
                        if (!(this.modelDistribution[n2] <= 0.0)) continue;
                        for (n10 = 0; n10 < this.contexts[n6].length; ++n10) {
                            n9 = this.contexts[n6][n10];
                            if (this.values == null) {
                                this.params[n9].updateParameter(n2, 1.0);
                            } else {
                                this.params[n9].updateParameter(n2, this.values[n6][n10]);
                            }
                            if (!this.useAverage) continue;
                            if (this.updates[n9][n2][this.VALUE] != 0) {
                                this.averageParams[n9].updateParameter(n2, this.updates[n9][n2][this.VALUE] * (this.numEvents * (n - this.updates[n9][n2][this.ITER]) + (n6 - this.updates[n9][n2][this.EVENT])));
                            }
                            this.updates[n9][n2][this.VALUE] = (int)this.params[n9].getParameters()[n2];
                            this.updates[n9][n2][this.ITER] = n;
                            this.updates[n9][n2][this.EVENT] = n6;
                        }
                        continue;
                    }
                    if (!(this.modelDistribution[n2] > 0.0)) continue;
                    for (n10 = 0; n10 < this.contexts[n6].length; ++n10) {
                        n9 = this.contexts[n6][n10];
                        if (this.values == null) {
                            this.params[n9].updateParameter(n2, -1.0);
                        } else {
                            this.params[n9].updateParameter(n2, -1.0f * this.values[n6][n10]);
                        }
                        if (!this.useAverage) continue;
                        if (this.updates[n9][n2][this.VALUE] != 0) {
                            this.averageParams[n9].updateParameter(n2, this.updates[n9][n2][this.VALUE] * (this.numEvents * (n - this.updates[n9][n2][this.ITER]) + (n6 - this.updates[n9][n2][this.EVENT])));
                        }
                        this.updates[n9][n2][this.VALUE] = (int)this.params[n9].getParameters()[n2];
                        this.updates[n9][n2][this.ITER] = n;
                        this.updates[n9][n2][this.EVENT] = n6;
                    }
                }
            }
            ++n6;
            ++n5;
        }
        double d = (double)this.iterations * (double)this.numEvents;
        if (this.useAverage && n == this.iterations - 1) {
            for (n3 = 0; n3 < this.numPreds; ++n3) {
                double[] dArray = this.averageParams[n3].getParameters();
                for (n2 = 0; n2 < this.numOutcomes; ++n2) {
                    if (this.updates[n3][n2][this.VALUE] != 0) {
                        int n11 = n2;
                        dArray[n11] = dArray[n11] + (double)(this.updates[n3][n2][this.VALUE] * (this.numEvents * (this.iterations - this.updates[n3][n2][this.ITER]) - this.updates[n3][n2][this.EVENT]));
                    }
                    if (dArray[n2] == 0.0) continue;
                    int n12 = n2;
                    dArray[n12] = dArray[n12] / d;
                    this.averageParams[n3].setParameter(n2, dArray[n2]);
                }
            }
        }
        this.display(". (" + n4 + "/" + this.numEvents + ") " + (double)n4 / (double)this.numEvents + "\n");
    }

    private void trainingStats(MutableContext[] mutableContextArray) {
        int n = 0;
        for (int i = 0; i < this.numUniqueEvents; ++i) {
            for (int j = 0; j < this.numTimesEventsSeen[i]; ++j) {
                int n2;
                for (n2 = 0; n2 < this.numOutcomes; ++n2) {
                    this.modelDistribution[n2] = 0.0;
                }
                if (this.values != null) {
                    PerceptronModel.eval(this.contexts[i], this.values[i], this.modelDistribution, this.evalParams, false);
                } else {
                    PerceptronModel.eval(this.contexts[i], null, this.modelDistribution, this.evalParams, false);
                }
                n2 = 0;
                for (int k = 1; k < this.numOutcomes; ++k) {
                    if (!(this.modelDistribution[k] > this.modelDistribution[n2])) continue;
                    n2 = k;
                }
                if (n2 != this.outcomeList[i]) continue;
                ++n;
            }
        }
        this.display(". (" + n + "/" + this.numEvents + ") " + (double)n / (double)this.numEvents + "\n");
    }
}

