/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Lisp.FeatureSet;
import Jet.Lisp.Variable;
import Jet.Pat.Action;
import Jet.Pat.AddFeaturesAction;
import Jet.Pat.AnnotationPatternElement;
import Jet.Pat.AssignmentPatternElement;
import Jet.Pat.IntegerPatternElement;
import Jet.Pat.NewAnnotationAction;
import Jet.Pat.PatternAlternation;
import Jet.Pat.PatternElement;
import Jet.Pat.PatternReference;
import Jet.Pat.PatternRepetition;
import Jet.Pat.PatternRule;
import Jet.Pat.PatternSequence;
import Jet.Pat.PatternSet;
import Jet.Pat.PatternSyntaxError;
import Jet.Pat.PrintAction;
import Jet.Pat.SpanBindingPatternElement;
import Jet.Pat.TokenStringPatternElement;
import Jet.Pat.UndefinedCapPatternElement;
import Jet.Pat.WriteAction;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PatternCollection {
    public Hashtable patterns = new Hashtable();
    public Hashtable patternSets = new Hashtable();
    public Vector patternNames = new Vector();
    public Vector patternSetNames = new Vector();
    private PatternSet currentPatternSet;

    public void readPatternCollection(Reader reader) throws IOException {
        this.currentPatternSet = null;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        StreamTokenizer streamTokenizer = new StreamTokenizer(lineNumberReader);
        block2: while (true) {
            try {
                while (true) {
                    if (streamTokenizer.nextToken() == -1) {
                        return;
                    }
                    this.readPatternStatement(streamTokenizer);
                }
            }
            catch (PatternSyntaxError patternSyntaxError) {
                int n = lineNumberReader.getLineNumber();
                System.out.println("*** syntax error in pattern file, line " + n);
                System.out.println(patternSyntaxError.toString());
                System.out.println("Current token = " + streamTokenizer.toString());
                do {
                    if (streamTokenizer.nextToken() == 59) continue block2;
                } while (streamTokenizer.ttype != -1);
                return;
            }
            break;
        }
    }

    private void readPatternStatement(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        if (streamTokenizer.ttype == -3) {
            if (streamTokenizer.sval.equals("when")) {
                this.readWhenStatement(streamTokenizer);
            } else if (streamTokenizer.sval.equals("pattern")) {
                this.readPatternSetStatement(streamTokenizer);
            } else {
                this.readPatternDefinition(streamTokenizer);
            }
        } else {
            throw new PatternSyntaxError();
        }
    }

    private void readPatternDefinition(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        String string = streamTokenizer.sval;
        if (streamTokenizer.nextToken() != 58) {
            throw new PatternSyntaxError(": expected");
        }
        if (streamTokenizer.nextToken() != 61) {
            throw new PatternSyntaxError("= expected");
        }
        streamTokenizer.nextToken();
        PatternElement patternElement = this.readPatternAlternation(streamTokenizer);
        if (streamTokenizer.ttype != 59) {
            throw new PatternSyntaxError("; expected");
        }
        this.patterns.put(string, patternElement);
        this.patternNames.add(string);
    }

    private PatternElement readPatternAlternation(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        Vector<PatternElement> vector = new Vector<PatternElement>();
        vector.addElement(this.readPatternSequence(streamTokenizer));
        while (streamTokenizer.ttype == 124) {
            streamTokenizer.nextToken();
            vector.addElement(this.readPatternSequence(streamTokenizer));
        }
        if (vector.size() == 1) {
            return (PatternElement)vector.get(0);
        }
        return new PatternAlternation(vector);
    }

    private PatternElement readPatternSequence(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        Vector<PatternElement> vector = new Vector<PatternElement>();
        PatternElement patternElement = this.readRepeatedPatternElement(streamTokenizer);
        if (patternElement == null) {
            throw new PatternSyntaxError();
        }
        do {
            vector.addElement(patternElement);
        } while ((patternElement = this.readRepeatedPatternElement(streamTokenizer)) != null);
        if (vector.size() == 1) {
            return (PatternElement)vector.get(0);
        }
        return new PatternSequence(vector);
    }

    private PatternElement readRepeatedPatternElement(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        PatternElement patternElement = this.readPatternElement(streamTokenizer);
        if (patternElement == null) {
            return null;
        }
        char c = (char)streamTokenizer.ttype;
        if (c == '?' || c == '*' || c == '+') {
            streamTokenizer.nextToken();
            return new PatternRepetition(patternElement, c);
        }
        return patternElement;
    }

    private PatternElement readPatternElement(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        if (streamTokenizer.ttype == 34) {
            String string = streamTokenizer.sval;
            streamTokenizer.nextToken();
            return new TokenStringPatternElement(string);
        }
        if (streamTokenizer.ttype == 91) {
            if (streamTokenizer.nextToken() != -3) {
                throw new PatternSyntaxError();
            }
            String string = streamTokenizer.sval;
            FeatureSet featureSet = new FeatureSet(streamTokenizer, true, ']');
            streamTokenizer.nextToken();
            if (string.equals("integer")) {
                return new IntegerPatternElement(featureSet);
            }
            if (string.equals("undefinedCap")) {
                return new UndefinedCapPatternElement(featureSet);
            }
            if (streamTokenizer.ttype == 58) {
                if (streamTokenizer.nextToken() == -3 && Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
                    String string2 = streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    return new AnnotationPatternElement(string, featureSet, new Variable(string2));
                }
                throw new PatternSyntaxError("variable expected after :");
            }
            return new AnnotationPatternElement(string, featureSet);
        }
        if (streamTokenizer.ttype == -3) {
            if (Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
                String string = streamTokenizer.sval;
                if (streamTokenizer.nextToken() != 61) {
                    throw new PatternSyntaxError("= expected");
                }
                AssignmentPatternElement assignmentPatternElement = null;
                if (streamTokenizer.nextToken() == -2) {
                    assignmentPatternElement = new AssignmentPatternElement(new Variable(string), new Integer((int)streamTokenizer.nval));
                } else if (streamTokenizer.ttype == -3) {
                    assignmentPatternElement = new AssignmentPatternElement(new Variable(string), streamTokenizer.sval);
                } else {
                    throw new PatternSyntaxError("integer expected");
                }
                streamTokenizer.nextToken();
                return assignmentPatternElement;
            }
            String string = streamTokenizer.sval;
            streamTokenizer.nextToken();
            return new PatternReference(string, this);
        }
        if (streamTokenizer.ttype == 40) {
            streamTokenizer.nextToken();
            PatternElement patternElement = this.readPatternAlternation(streamTokenizer);
            if (streamTokenizer.ttype != 41) {
                throw new PatternSyntaxError(") expected");
            }
            if (streamTokenizer.nextToken() == 58) {
                if (streamTokenizer.nextToken() == -3 && Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
                    String string = streamTokenizer.sval;
                    patternElement = new SpanBindingPatternElement(patternElement, new Variable(string));
                    streamTokenizer.nextToken();
                } else {
                    throw new PatternSyntaxError("variable expected after :");
                }
            }
            return patternElement;
        }
        return null;
    }

    private void readWhenStatement(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        if (streamTokenizer.nextToken() != -3) {
            throw new PatternSyntaxError("no pattern name in when statement");
        }
        String string = streamTokenizer.sval;
        Vector<Action> vector = new Vector<Action>();
        do {
            if (streamTokenizer.nextToken() == -3) {
                if (streamTokenizer.sval.equals("print")) {
                    vector.addElement(new PrintAction(streamTokenizer));
                    continue;
                }
                if (streamTokenizer.sval.equals("write")) {
                    vector.addElement(new WriteAction(streamTokenizer));
                    continue;
                }
                if (streamTokenizer.sval.equals("add")) {
                    vector.addElement(new NewAnnotationAction(streamTokenizer));
                    continue;
                }
                if (streamTokenizer.sval.equals("addFeatures")) {
                    vector.addElement(new AddFeaturesAction(streamTokenizer));
                    continue;
                }
                throw new PatternSyntaxError("unknown action " + streamTokenizer.sval);
            }
            throw new PatternSyntaxError("unknown action " + streamTokenizer.sval);
        } while (streamTokenizer.ttype == 44);
        if (streamTokenizer.ttype != 59) {
            throw new PatternSyntaxError("; expected");
        }
        if (this.currentPatternSet == null) {
            throw new PatternSyntaxError("no pattern set defined");
        }
        this.currentPatternSet.addRule(new PatternRule(string, vector));
    }

    private void readPatternSetStatement(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equals("set")) {
            throw new PatternSyntaxError("'set' expected");
        }
        if (streamTokenizer.nextToken() != -3) {
            throw new PatternSyntaxError("pattern set name expected");
        }
        String string = streamTokenizer.sval;
        if (streamTokenizer.nextToken() != 59) {
            throw new PatternSyntaxError("; expected");
        }
        if (this.patternSets.containsKey(string)) {
            this.currentPatternSet = (PatternSet)this.patternSets.get(string);
        } else {
            this.currentPatternSet = new PatternSet();
            this.patternSets.put(string, this.currentPatternSet);
            this.patternSetNames.add(string);
        }
    }

    public PatternElement getPattern(String string) {
        return (PatternElement)this.patterns.get(string);
    }

    public PatternElement dereference(String string) {
        return (PatternElement)this.patterns.get(string);
    }

    public PatternSet getPatternSet(String string) {
        return (PatternSet)this.patternSets.get(string);
    }

    public void makePatternGraph() {
        Enumeration enumeration = this.patternSets.elements();
        while (enumeration.hasMoreElements()) {
            PatternSet patternSet = (PatternSet)enumeration.nextElement();
            patternSet.makePatternGraph(this);
        }
    }

    public void apply(String string, Document document) {
        if (this.patternSets.containsKey(string)) {
            PatternSet patternSet = (PatternSet)this.patternSets.get(string);
            patternSet.apply(document);
        }
    }

    public void apply(String string, Document document, Span span) {
        if (this.patternSets.containsKey(string)) {
            PatternSet patternSet = (PatternSet)this.patternSets.get(string);
            patternSet.apply(document, span);
        }
    }
}

