/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntityMention;
import AceJet.AceMention;
import Jet.Tipster.Document;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AcePatternNode {
    String type;
    String subtype;
    String head;
    static final int MATCH_SCORE_ANY_MENTION = 10000;
    static final int MATCH_SCORE_TYPE_MATCH = 10100;
    static final int MATCH_SCORE_SUBTYPE_MATCH = 10200;
    static final int MATCH_SCORE_WORD_MATCH = 10300;
    private AceMention lastMatchedMention = null;

    public AcePatternNode(AceMention aceMention) {
        this.type = aceMention.getType();
        if (aceMention instanceof AceEntityMention) {
            this.subtype = ((AceEntityMention)aceMention).entity.subtype;
            this.head = ((AceEntityMention)aceMention).headText.replace('\n', ' ');
        } else {
            this.subtype = "";
            this.head = aceMention.text.replace('\n', ' ');
        }
    }

    public AcePatternNode(String string) {
        if (string == null) {
            System.err.println("AcePatternNode: null constructor argument");
            return;
        }
        String[] stringArray = string.split(" \\| ");
        if (stringArray.length != 3) {
            System.err.println("AcePatternNode: invalid constructor argument: " + string);
            return;
        }
        this.type = stringArray[0];
        this.subtype = stringArray[1];
        this.head = stringArray[2];
    }

    public boolean equals(Object object) {
        if (!(object instanceof AcePatternNode)) {
            return false;
        }
        AcePatternNode acePatternNode = (AcePatternNode)object;
        return this.type.equals(acePatternNode.type) && this.subtype.equals(acePatternNode.subtype) && this.head.equals(acePatternNode.head);
    }

    public int hashCode() {
        return (this.type + this.subtype + this.head).hashCode();
    }

    public String toString() {
        return this.type + "." + this.subtype;
    }

    public void write(PrintWriter printWriter) {
        printWriter.println(this.type + " | " + this.subtype + " | " + this.head);
    }

    public int match(AceMention aceMention) {
        int n = 10000;
        if (this.type.equals(aceMention.getType())) {
            n = 10100;
            if (aceMention instanceof AceEntityMention) {
                AceEntityMention aceEntityMention = (AceEntityMention)aceMention;
                if (this.subtype.equals(aceEntityMention.entity.subtype)) {
                    n = 10200;
                    if (this.head.equals(aceEntityMention.headText)) {
                        n = 10300;
                    }
                }
            }
        }
        return n;
    }

    public AceMention matchFromLeft(int n, Document document, AceDocument aceDocument) {
        ArrayList<AceMention> arrayList = aceDocument.getAllMentions();
        for (int i = 0; i < arrayList.size(); ++i) {
            AceMention aceMention = arrayList.get(i);
            if (aceMention.jetExtent.start() != n || !this.type.equals(aceMention.getType())) continue;
            return aceMention;
        }
        return null;
    }

    public AceMention matchFromRight(int n, Document document, AceDocument aceDocument) {
        ArrayList<AceMention> arrayList = aceDocument.getAllMentions();
        for (int i = 0; i < arrayList.size(); ++i) {
            AceMention aceMention = arrayList.get(i);
            if (aceMention.jetExtent.end() != n || !this.type.equals(aceMention.getType())) continue;
            return aceMention;
        }
        return null;
    }

    public int matchOnHead(int n, Document document, AceDocument aceDocument) {
        ArrayList<AceMention> arrayList = aceDocument.getAllMentions();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            AceMention aceMention = arrayList.get(i);
            int n3 = n2 = aceMention instanceof AceEntityMention ? ((AceEntityMention)aceMention).jetHead.start() : aceMention.extent.start();
            if (n2 != n) continue;
            this.lastMatchedMention = aceMention;
            return this.match(aceMention);
        }
        this.lastMatchedMention = null;
        return -1;
    }

    public AceMention getMatchedMention() {
        return this.lastMatchedMention;
    }
}

