/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import pnuts.lang.Context;
import pnuts.tools.CancelableContext;
import pnuts.tools.Console;
import pnuts.tools.JTextComponentConsoleUI;
import pnuts.tools.PnutsConsole;

public class PnutsConsoleUI
extends JTextComponentConsoleUI {
    static final String ICON_RESOURCE = "pnuts16.png";
    Vector history = new Vector();
    int historyIndex = -1;
    JFrame frame;
    JComponent component;
    String title;
    static /* synthetic */ Class class$pnuts$tools$PnutsConsole;

    public PnutsConsoleUI() {
        this(null);
    }

    public PnutsConsoleUI(Console console2) {
        this.setModel(console2);
        EventHandler handler = new EventHandler();
        JTextArea textarea = (JTextArea)this.textComponent;
        textarea.addKeyListener(handler);
        textarea.getDocument().addDocumentListener(handler);
    }

    public PnutsConsole createConsole(Context context, String inputlog) {
        return this.createConsole(null, context, null, inputlog, true, null, 5);
    }

    protected PnutsConsole createConsole() {
        return new PnutsConsole();
    }

    public PnutsConsole createConsole(String[] modules, Context context, ClassLoader cl, String inputlog, boolean greeting, Runnable terminationCallback, int priority) {
        Context cc = context != null ? context : new CancelableContext();
        if (cl != null) {
            cc.setClassLoader(cl);
        }
        if (modules != null) {
            for (int i = 0; i < modules.length; ++i) {
                cc.usePackage(modules[i]);
            }
        }
        PnutsConsole console2 = this.createConsole();
        this.setModel(console2);
        console2.setContext(cc);
        console2.setInputLog(inputlog);
        console2.setGreeting(greeting);
        console2.setClassLoader(cl);
        console2.setPriority(priority);
        console2.setTerminationCallback(terminationCallback);
        console2.setConsoleUI(this);
        return console2;
    }

    public void entered(String command) {
        if (command != null && command.length() > 0) {
            this.history.add(command);
        }
        this.historyIndex = this.history.size();
    }

    public JTextArea getTextArea() {
        return (JTextArea)this.textComponent;
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JScrollPane(this.textComponent);
        }
        return this.component;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            Image iconImage;
            this.frame = new JFrame(this.title);
            this.frame.setContentPane(this.getComponent());
            ((Component)this.frame).setSize(this.textComponent.getPreferredSize());
            URL imageURL = (class$pnuts$tools$PnutsConsole == null ? (class$pnuts$tools$PnutsConsole = PnutsConsoleUI.class$("pnuts.tools.PnutsConsole")) : class$pnuts$tools$PnutsConsole).getResource(ICON_RESOURCE);
            if (imageURL != null && (iconImage = Toolkit.getDefaultToolkit().getImage(imageURL)) != null) {
                this.frame.setIconImage(iconImage);
            }
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ((PnutsConsole)PnutsConsoleUI.this.model).dispose();
                }
            });
        }
        return this.frame;
    }

    void largerFont() {
        Font font = this.textComponent.getFont();
        int size = font.getSize() + 1;
        this.textComponent.setFont(font.deriveFont((float)size));
    }

    void smallerFont() {
        Font font = this.textComponent.getFont();
        int size = font.getSize() - 1;
        if (size < 1) {
            size = 1;
        }
        this.textComponent.setFont(font.deriveFont((float)size));
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EventHandler
    implements KeyListener,
    DocumentListener {
        EventHandler() {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            char ch = e.getKeyChar();
            boolean control = e.isControlDown();
            int pos = PnutsConsoleUI.this.textComponent.getCaretPosition();
            if (code == 8 || code == 37) {
                if (PnutsConsoleUI.this.mark == pos) {
                    e.consume();
                }
            } else if (control && code == 65) {
                PnutsConsoleUI.this.textComponent.setCaretPosition(PnutsConsoleUI.this.mark);
                e.consume();
            } else if (control && code == 69) {
                PnutsConsoleUI.this.textComponent.setCaretPosition(PnutsConsoleUI.this.textComponent.getDocument().getLength());
                e.consume();
            } else if (control && code == 66) {
                if (PnutsConsoleUI.this.mark < pos) {
                    PnutsConsoleUI.this.textComponent.setCaretPosition(pos - 1);
                }
                e.consume();
            } else if (control && code == 68) {
                Document doc = PnutsConsoleUI.this.textComponent.getDocument();
                if (pos < doc.getLength()) {
                    try {
                        doc.remove(pos, 1);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                e.consume();
            } else if (control && code == 70) {
                if (PnutsConsoleUI.this.textComponent.getDocument().getLength() > pos) {
                    PnutsConsoleUI.this.textComponent.setCaretPosition(pos + 1);
                }
                e.consume();
            } else if (control && code == 75) {
                Document doc = PnutsConsoleUI.this.textComponent.getDocument();
                try {
                    doc.remove(pos, doc.getLength() - pos);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                e.consume();
            } else if (control && code == 85) {
                Document doc = PnutsConsoleUI.this.textComponent.getDocument();
                try {
                    doc.remove(PnutsConsoleUI.this.mark, doc.getLength() - PnutsConsoleUI.this.mark);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                e.consume();
            } else if (control && ch == '+') {
                PnutsConsoleUI.this.largerFont();
                e.consume();
            } else if (control && (ch == '-' || code == 45)) {
                PnutsConsoleUI.this.smallerFont();
                e.consume();
            } else if (code == 36 || control && code == 65) {
                if (pos == PnutsConsoleUI.this.mark) {
                    e.consume();
                } else if (pos > PnutsConsoleUI.this.mark && !control) {
                    if (e.isShiftDown()) {
                        PnutsConsoleUI.this.textComponent.moveCaretPosition(PnutsConsoleUI.this.mark);
                    } else {
                        PnutsConsoleUI.this.textComponent.setCaretPosition(PnutsConsoleUI.this.mark);
                    }
                    e.consume();
                }
            } else if (code == 10) {
                PnutsConsoleUI.this.enter();
                e.consume();
            } else if (code == 38 || control && code == 80) {
                --PnutsConsoleUI.this.historyIndex;
                if (PnutsConsoleUI.this.historyIndex >= 0) {
                    if (PnutsConsoleUI.this.historyIndex >= PnutsConsoleUI.this.history.size()) {
                        PnutsConsoleUI.this.historyIndex = PnutsConsoleUI.this.history.size() - 1;
                    }
                    if (PnutsConsoleUI.this.historyIndex >= 0) {
                        String str = (String)PnutsConsoleUI.this.history.elementAt(PnutsConsoleUI.this.historyIndex);
                        int len = PnutsConsoleUI.this.textComponent.getDocument().getLength();
                        ((JTextArea)PnutsConsoleUI.this.textComponent).replaceRange(str, PnutsConsoleUI.this.mark, len);
                        int caretPos = PnutsConsoleUI.this.mark + str.length();
                        PnutsConsoleUI.this.textComponent.select(caretPos, caretPos);
                    } else {
                        ++PnutsConsoleUI.this.historyIndex;
                    }
                } else {
                    ++PnutsConsoleUI.this.historyIndex;
                }
                e.consume();
            } else if (code == 40 || control && code == 78) {
                int caretPos = PnutsConsoleUI.this.mark;
                if (PnutsConsoleUI.this.history.size() > 0) {
                    ++PnutsConsoleUI.this.historyIndex;
                    if (PnutsConsoleUI.this.historyIndex < 0) {
                        PnutsConsoleUI.this.historyIndex = 0;
                    }
                    int len = PnutsConsoleUI.this.textComponent.getDocument().getLength();
                    if (PnutsConsoleUI.this.historyIndex < PnutsConsoleUI.this.history.size()) {
                        String str = (String)PnutsConsoleUI.this.history.elementAt(PnutsConsoleUI.this.historyIndex);
                        ((JTextArea)PnutsConsoleUI.this.textComponent).replaceRange(str, PnutsConsoleUI.this.mark, len);
                        caretPos = PnutsConsoleUI.this.mark + str.length();
                    } else {
                        PnutsConsoleUI.this.historyIndex = PnutsConsoleUI.this.history.size();
                        ((JTextArea)PnutsConsoleUI.this.textComponent).replaceRange("", PnutsConsoleUI.this.mark, len);
                    }
                }
                PnutsConsoleUI.this.textComponent.select(caretPos, caretPos);
                e.consume();
            }
        }

        public void keyTyped(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (keyChar == '\b') {
                if (PnutsConsoleUI.this.mark == PnutsConsoleUI.this.textComponent.getCaretPosition()) {
                    e.consume();
                }
            } else if (PnutsConsoleUI.this.textComponent.getCaretPosition() < PnutsConsoleUI.this.mark) {
                PnutsConsoleUI.this.textComponent.setCaretPosition(PnutsConsoleUI.this.mark);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(DocumentEvent e) {
            PnutsConsoleUI pnutsConsoleUI = PnutsConsoleUI.this;
            synchronized (pnutsConsoleUI) {
                int len = e.getLength();
                int off = e.getOffset();
                if (PnutsConsoleUI.this.mark > off) {
                    PnutsConsoleUI.this.mark += len;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent e) {
            PnutsConsoleUI pnutsConsoleUI = PnutsConsoleUI.this;
            synchronized (pnutsConsoleUI) {
                int len = e.getLength();
                int off = e.getOffset();
                if (PnutsConsoleUI.this.mark > off) {
                    PnutsConsoleUI.this.mark = PnutsConsoleUI.this.mark >= off + len ? (PnutsConsoleUI.this.mark -= len) : off;
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

