/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pnuts.lang.AbstractData;
import pnuts.lang.Callable;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Generator;
import pnuts.lang.Indexed;
import pnuts.lang.JavaBeansConfiguration;
import pnuts.lang.Package;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Property;
import pnuts.lang.Runtime;

class Java2Configuration
extends JavaBeansConfiguration {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 3317873710368570462L;
    static /* synthetic */ Class class$java$lang$Object;

    Java2Configuration() {
    }

    Java2Configuration(Class stopClass) {
        super(stopClass);
    }

    public Object getField(Context context, Object target, String name) {
        if (target instanceof Context) {
            return ((Context)target).get(name);
        }
        if (target instanceof Property) {
            return ((Property)target).get(name, context);
        }
        if (target instanceof Map) {
            return ((Map)target).get(name);
        }
        if (target instanceof Generator) {
            return this.fieldGenerator((Generator)target, name, context);
        }
        return super.getField(context, target, name);
    }

    public void putField(final Context context, Object target, String name, final Object value) {
        if (target instanceof Context) {
            ((Context)target).set(name, value);
        } else if (target instanceof Property) {
            ((Property)target).set(name, value, context);
        } else if (target instanceof Map) {
            ((Map)target).put(name, value);
        } else if (target instanceof Generator) {
            Generator g = (Generator)target;
            final String fieldName = name;
            g.apply(new PnutsFunction(){

                protected Object exec(Object[] args, Context c) {
                    Runtime.putField(context, args[0], fieldName, value);
                    return null;
                }
            }, context);
        } else {
            super.putField(context, target, name, value);
        }
    }

    public Object getStaticField(Context context, Class clazz, String name) {
        try {
            return this.getField(clazz, name).get(null);
        }
        catch (PnutsException p) {
            throw p;
        }
        catch (NoSuchFieldException f) {
            throw new PnutsException("field.notFound", new Object[]{name, clazz}, context);
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public void putStaticField(Context context, Class clazz, String name, Object value) {
        try {
            Field field = this.getField(clazz, name);
            Class<?> type = field.getType();
            if (type.isArray() && value != null && Runtime.isArray(value) && !type.isInstance(value)) {
                value = Runtime.transform(Runtime.getBottomType(type), value);
            }
            field.set(null, value);
        }
        catch (PnutsException e0) {
            throw e0;
        }
        catch (NoSuchFieldException f) {
            throw new PnutsException("field.notFound", new Object[]{name, clazz}, context);
        }
        catch (Throwable e) {
            throw new PnutsException(e, context);
        }
    }

    protected Field getField(final Class cls, final String name) throws NoSuchFieldException {
        try {
            return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return cls.getField(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchFieldException)e.getException();
        }
    }

    public Object callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        try {
            if (target instanceof AbstractData) {
                return ((AbstractData)target).invoke(name, args, context);
            }
            return super.callMethod(context, c, name, args, types, target);
        }
        catch (PnutsException e1) {
            throw e1;
        }
        catch (Throwable e2) {
            throw new PnutsException(e2, context);
        }
    }

    public Enumeration toEnumeration(Object obj) {
        if (obj instanceof Enumeration) {
            return (Enumeration)obj;
        }
        if (obj instanceof Iterator) {
            return new ItrEnum((Iterator)obj);
        }
        if (obj instanceof Object[]) {
            return new ObjectArrayEnum((Object[])obj);
        }
        if (obj instanceof Collection) {
            return Collections.enumeration((Collection)obj);
        }
        if (obj instanceof Map) {
            return new ItrEnum(((Map)obj).entrySet().iterator());
        }
        if (Runtime.isArray(obj)) {
            return new ArrayEnum(obj);
        }
        if (obj instanceof String) {
            return new StringEnum((String)obj);
        }
        return null;
    }

    public Callable toCallable(Object obj) {
        return null;
    }

    public Object getElement(Context context, Object target, Object key) {
        if (target instanceof Object[]) {
            if (key instanceof Number) {
                return ((Object[])target)[((Number)key).intValue()];
            }
            if (key instanceof PnutsFunction) {
                return Java2Configuration.filterGenerator((Object[])target, (PnutsFunction)key, context);
            }
        } else if (target instanceof Indexed) {
            if (key instanceof Number) {
                return ((Indexed)target).get(((Number)key).intValue());
            }
            if (key instanceof String) {
                return this.getBeanProperty(context, target, (String)key);
            }
        } else {
            if (target instanceof Package) {
                return ((Property)target).get(((String)key).intern(), context);
            }
            if (target instanceof Property) {
                return ((Property)target).get((String)key, context);
            }
            if (target instanceof Map) {
                return ((Map)target).get(key);
            }
            if (target instanceof Context) {
                return ((Context)target).get(((String)key).intern());
            }
            if (target instanceof Generator) {
                if (key instanceof Number) {
                    return Java2Configuration.generateNth((Generator)target, ((Number)key).intValue(), context);
                }
                if (key instanceof PnutsFunction) {
                    return Java2Configuration.filterGenerator((Generator)target, (PnutsFunction)key, context);
                }
            } else if (key instanceof PnutsFunction) {
                if (target instanceof Collection) {
                    return Java2Configuration.filterGenerator((Collection)target, (PnutsFunction)key, context);
                }
                if (target instanceof int[] || target instanceof byte[] || target instanceof short[] || target instanceof char[] || target instanceof long[] || target instanceof float[] || target instanceof double[] || target instanceof boolean[]) {
                    return Java2Configuration.filterGenerator(target, (PnutsFunction)key, context);
                }
            } else {
                if (key instanceof String) {
                    return this.getBeanProperty(context, target, (String)key);
                }
                if (key instanceof Number) {
                    if (target instanceof List) {
                        return ((List)target).get(((Number)key).intValue());
                    }
                    if (target instanceof String) {
                        return new Character(((String)target).charAt(((Number)key).intValue()));
                    }
                    if (target instanceof int[]) {
                        return new Integer(((int[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof byte[]) {
                        return new Byte(((byte[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof char[]) {
                        return new Character(((char[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof float[]) {
                        return new Float(((float[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof double[]) {
                        return new Double(((double[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof boolean[]) {
                        return ((boolean[])target)[((Number)key).intValue()];
                    }
                    if (target instanceof long[]) {
                        return new Long(((long[])target)[((Number)key).intValue()]);
                    }
                    if (target instanceof short[]) {
                        return new Short(((short[])target)[((Number)key).intValue()]);
                    }
                }
            }
        }
        throw new IllegalArgumentException(String.valueOf(key));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(Context context, Object target, Object key, Object expr) {
        if (target instanceof Object[]) {
            ((Object[])target)[((Number)key).intValue()] = expr;
            return;
        } else if (target instanceof Indexed) {
            if (key instanceof Number) {
                ((Indexed)target).set(((Number)key).intValue(), expr);
                return;
            } else {
                if (!(key instanceof String)) throw new IllegalArgumentException(String.valueOf(key));
                this.setBeanProperty(context, target, (String)key, expr);
            }
            return;
        } else if (target instanceof Package) {
            ((Property)target).set(((String)key).intern(), expr, context);
            return;
        } else if (target instanceof Property) {
            ((Property)target).set((String)key, expr, context);
            return;
        } else if (target instanceof Map) {
            ((Map)target).put(key, expr);
            return;
        } else if (target instanceof Context) {
            ((Context)target).set(((String)key).intern(), expr);
            return;
        } else if (target instanceof List) {
            ((List)target).set(((Number)key).intValue(), expr);
            return;
        } else if (target instanceof int[]) {
            ((int[])target)[((Number)key).intValue()] = ((Number)expr).intValue();
            return;
        } else if (target instanceof byte[]) {
            ((byte[])target)[((Number)key).intValue()] = ((Number)expr).byteValue();
            return;
        } else if (target instanceof char[]) {
            ((char[])target)[((Number)key).intValue()] = ((Character)expr).charValue();
            return;
        } else if (target instanceof float[]) {
            ((float[])target)[((Number)key).intValue()] = ((Number)expr).floatValue();
            return;
        } else if (target instanceof double[]) {
            ((double[])target)[((Number)key).intValue()] = ((Number)expr).doubleValue();
            return;
        } else if (target instanceof boolean[]) {
            ((boolean[])target)[((Number)key).intValue()] = (Boolean)expr;
            return;
        } else if (target instanceof long[]) {
            ((long[])target)[((Number)key).intValue()] = ((Number)expr).longValue();
            return;
        } else if (target instanceof short[]) {
            ((short[])target)[((Number)key).intValue()] = ((Number)expr).shortValue();
            return;
        } else {
            if (!(key instanceof String)) throw new IllegalArgumentException(String.valueOf(key));
            this.setBeanProperty(context, target, (String)key, expr);
        }
    }

    static void setElements(Object target, int from, int to, Object expr) {
        if (target instanceof Object[]) {
            Object[] array = (Object[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = expr;
            }
        } else if (target instanceof Indexed) {
            Indexed indexed = (Indexed)target;
            for (int i = from; i <= to; ++i) {
                indexed.set(i, expr);
            }
        } else if (target instanceof List) {
            List list = (List)target;
            for (int i = from; i <= to; ++i) {
                list.set(i, expr);
            }
        } else if (target instanceof int[]) {
            int[] array = (int[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Number)expr).intValue();
            }
        } else if (target instanceof byte[]) {
            byte[] array = (byte[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Number)expr).byteValue();
            }
        } else if (target instanceof char[]) {
            char[] array = (char[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Character)expr).charValue();
            }
        } else if (target instanceof float[]) {
            float[] array = (float[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Number)expr).floatValue();
            }
        } else if (target instanceof double[]) {
            double[] array = (double[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Number)expr).doubleValue();
            }
        } else if (target instanceof boolean[]) {
            boolean[] array = (boolean[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = (Boolean)expr;
            }
        } else if (target instanceof long[]) {
            long[] array = (long[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Number)expr).longValue();
            }
        } else if (target instanceof short[]) {
            short[] array = (short[])target;
            for (int i = from; i <= to; ++i) {
                array[i] = ((Number)expr).shortValue();
            }
        } else {
            for (int i = from; i <= to; ++i) {
                Array.set(target, i, expr);
            }
        }
    }

    public Object getRange(Context context, Object target, Object idx1, Object idx2) {
        int from = ((Number)idx1).intValue();
        int to = -1;
        if (idx2 != null) {
            to = ((Number)idx2).intValue();
        }
        if (target instanceof String) {
            String s = (String)target;
            int len = s.length();
            if (from > len - 1) {
                return "";
            }
            if (idx2 != null) {
                if (from > to || to < 0) {
                    return "";
                }
                if (from < 0) {
                    from = 0;
                }
                if (to > len - 1) {
                    to = len - 1;
                }
                return s.substring(from, to + 1);
            }
            if (from < 0) {
                from = 0;
            }
            return s.substring(from);
        }
        if (Runtime.isArray(target)) {
            int size;
            Class<?> c = target.getClass().getComponentType();
            int len = Runtime.getArrayLength(target);
            if (from > len - 1) {
                return Array.newInstance(c, 0);
            }
            if (idx2 == null) {
                to = len - 1;
            } else {
                if (from > to || to < 0) {
                    return Array.newInstance(c, 0);
                }
                if (to > len - 1) {
                    to = len - 1;
                }
            }
            if (from < 0) {
                from = 0;
            }
            if ((size = to - from + 1) < 0) {
                size = 0;
            } else if (from + size > len) {
                size = len - from;
            }
            Object ret = Array.newInstance(c, size);
            if (size > 0) {
                System.arraycopy(target, from, ret, 0, size);
            }
            return ret;
        }
        if (target instanceof List) {
            List list = (List)target;
            try {
                int size = list.size();
                if (from < 0) {
                    from = 0;
                } else if (from > size) {
                    from = size;
                }
                if (idx2 == null) {
                    to = size;
                } else if (from > to || to < 0) {
                    to = from;
                } else if (++to > size) {
                    to = size;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return list.subList(from, to);
        }
        if (target instanceof Generator) {
            if (idx2 != null) {
                if (from > to || to < 0) {
                    from = -1;
                    to = -1;
                } else if (from < 0) {
                    from = 0;
                }
            } else {
                to = -1;
                if (from < 0) {
                    from = 0;
                }
            }
            return new Runtime.RangeGenerator((Generator)target, from, to);
        }
        throw new PnutsException("illegal.type", new Object[]{target}, context);
    }

    public Object setRange(Context context, Object target, Object idx1, Object idx2, Object expr) {
        int from = ((Number)idx1).intValue();
        int to = -1;
        if (idx2 != null && (from > (to = ((Number)idx2).intValue()) || to < 0)) {
            return target;
        }
        if (target instanceof String) {
            StringBuffer s = new StringBuffer((String)target);
            int len = s.length();
            if (from > len - 1) {
                return target;
            }
            if (idx2 == null) {
                to = len - 1;
            } else if (to > len - 1) {
                to = len - 1;
            }
            if (from < 0) {
                from = 0;
            }
            if (expr instanceof Character) {
                char c = ((Character)expr).charValue();
                for (int i = from; i < to + 1; ++i) {
                    s.setCharAt(i, c);
                }
            } else {
                this.replace(s, from, to + 1, String.valueOf(expr));
            }
            String val = s.toString();
            return val;
        }
        if (Runtime.isArray(target)) {
            int size;
            int len = Runtime.getArrayLength(target);
            if (from > len - 1) {
                return target;
            }
            if (idx2 == null) {
                to = len - 1;
            } else if (to > len - 1) {
                to = len - 1;
            }
            if (from < 0) {
                from = 0;
            }
            if (from + (size = to - from + 1) > len) {
                size = len - from;
            }
            if (target instanceof char[] && expr instanceof String) {
                String str = (String)expr;
                int end = str.length();
                if (end > to - from + 1) {
                    end = to - from + 1;
                }
                str.getChars(0, end, (char[])target, from);
            } else {
                Java2Configuration.setElements(target, from, to, expr);
            }
            return target;
        }
        if (target instanceof List) {
            List list = (List)target;
            try {
                int size = list.size();
                if (from < 0) {
                    from = 0;
                } else if (from > size) {
                    from = size;
                }
                if (idx2 == null) {
                    to = size;
                } else if (from > to || to < 0) {
                    to = from;
                } else if (++to > size) {
                    to = size;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = from; i < to; ++i) {
                list.set(i, expr);
            }
            return target;
        }
        throw new PnutsException("illegal.type", PnutsException.NO_PARAM, context);
    }

    Object reInvoke(IllegalAccessException t, Method method, Object target, Object[] args) throws IllegalAccessException, InvocationTargetException {
        ((AccessibleObject)method).setAccessible(true);
        return method.invoke(target, args);
    }

    void replace(StringBuffer buf, int from, int to, String str) {
        buf.replace(from, to, str);
    }

    protected ClassLoader getInitialClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    Generator fieldGenerator(final Generator g, String name, Context context) {
        final String fieldName = name;
        return new Generator(){

            public Object apply(final PnutsFunction closure, final Context context) {
                g.apply(new PnutsFunction(){

                    protected Object exec(Object[] args, Context ctx) {
                        closure.call(new Object[]{Runtime.getField(context, args[0], fieldName)}, context);
                        return null;
                    }
                }, context);
                return null;
            }
        };
    }

    static Generator filterGenerator(Object array, PnutsFunction pred, Context context) {
        return Java2Configuration.filterGenerator((Object[])Runtime.transform(class$java$lang$Object == null ? (class$java$lang$Object = Java2Configuration.class$("java.lang.Object")) : class$java$lang$Object, array), pred, context);
    }

    static Generator filterGenerator(final Object[] array, final PnutsFunction pred, Context context) {
        return new Generator(){

            public Object apply(PnutsFunction closure, Context c) {
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    Object[] args = new Object[]{array[i]};
                    if (!((Boolean)pred.call(args, c)).booleanValue()) continue;
                    closure.call(args, c);
                }
                return null;
            }
        };
    }

    static Generator filterGenerator(final Collection collection, final PnutsFunction pred, Context context) {
        return new Generator(){

            public Object apply(PnutsFunction closure, Context c) {
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Object[] args = new Object[]{it.next()};
                    if (!((Boolean)pred.call(args, c)).booleanValue()) continue;
                    closure.call(args, c);
                }
                return null;
            }
        };
    }

    static Generator filterGenerator(final Generator g, final PnutsFunction pred, Context context) {
        return new Generator(){

            public Object apply(final PnutsFunction closure, Context context) {
                g.apply(new PnutsFunction(){

                    protected Object exec(Object[] args, Context ctx) {
                        if (((Boolean)pred.call(args, ctx)).booleanValue()) {
                            closure.call(args, ctx);
                        }
                        return null;
                    }
                }, context);
                return null;
            }
        };
    }

    static Object generateNth(Generator g, int idx, Context context) {
        if (idx < 0) {
            return null;
        }
        Counter c = new Counter(idx);
        try {
            g.apply(c, context);
        }
        catch (CounterEscape esc) {
            return esc.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CounterEscape
    extends Escape {
        Object value;

        CounterEscape(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    static class Counter
    extends PnutsFunction {
        int n;

        Counter(int n) {
            this.n = n;
        }

        protected Object exec(Object[] args, Context c) {
            if (this.n > 0) {
                --this.n;
            } else {
                throw new CounterEscape(args[0]);
            }
            return null;
        }
    }

    static class StringEnum
    implements Enumeration {
        String str;
        int len;
        int pos = 0;

        StringEnum(String str) {
            this.str = str;
            this.len = str.length();
        }

        public boolean hasMoreElements() {
            return this.len > this.pos;
        }

        public Object nextElement() {
            return new Character(this.str.charAt(this.pos++));
        }
    }

    static class ItrEnum
    implements Enumeration {
        Iterator itr;

        ItrEnum(Iterator itr) {
            this.itr = itr;
        }

        public boolean hasMoreElements() {
            return this.itr.hasNext();
        }

        public Object nextElement() {
            return this.itr.next();
        }
    }

    static class ArrayEnum
    implements Enumeration {
        Object array;
        int idx;
        int len;

        ArrayEnum(Object array) {
            this.array = array;
            this.idx = 0;
            this.len = Array.getLength(array);
        }

        public boolean hasMoreElements() {
            return this.idx < this.len;
        }

        public Object nextElement() {
            return Array.get(this.array, this.idx++);
        }
    }

    static class ObjectArrayEnum
    implements Enumeration {
        Object[] array;
        int idx;
        int len;

        ObjectArrayEnum(Object[] array) {
            this.array = array;
            this.idx = 0;
            this.len = array.length;
        }

        public boolean hasMoreElements() {
            return this.idx < this.len;
        }

        public Object nextElement() {
            return this.array[this.idx++];
        }
    }
}

