/*
 * Decompiled with CFR 0.152.
 */
package Jet.Zoner;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceSet {
    private Vector<Annotation> sentences;
    private int[] sentenceBoundaries;

    public SentenceSet(Document document) {
        this.sentences = document.annotationsOfType("sentence");
        if (this.sentences == null) {
            this.sentences = new Vector();
        }
        this.sentenceBoundaries = new int[this.sentences.size()];
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentenceBoundaries[i] = this.sentences.get(i).span().start();
        }
    }

    public Vector<Annotation> sentences() {
        return this.sentences;
    }

    public int size() {
        return this.sentences.size();
    }

    public int sentencesBetween(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.sentenceBoundaries.length; ++i) {
            if (n >= this.sentenceBoundaries[i] || this.sentenceBoundaries[i] > n2) continue;
            ++n3;
        }
        return n3;
    }

    public int sentenceNumber(int n) {
        for (int i = 1; i < this.sentenceBoundaries.length; ++i) {
            if (n >= this.sentenceBoundaries[i]) continue;
            return i - 1;
        }
        return this.sentenceBoundaries.length - 1;
    }

    public boolean inSameSentence(int n, int n2) {
        return this.sentencesBetween(n, n2) == 0;
    }

    public int pseudoHobbsDistance(int n, int n2) {
        if (this.sentencesBetween(n, n2) == 0) {
            return n2 - n;
        }
        for (int i = 0; i < this.sentenceBoundaries.length - 1; ++i) {
            if (n < this.sentenceBoundaries[i] || n >= this.sentenceBoundaries[i + 1]) continue;
            return n - this.sentenceBoundaries[i] + (n2 - this.sentenceBoundaries[i + 1]) + 1;
        }
        return 99999;
    }
}

