/*
 * Decompiled with CFR 0.152.
 */
package Jet.Util;

import Jet.Util.Cdb;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class CdbBuilder {
    private String filename;
    private String tmpFilename;
    private RandomAccessFile file;
    private List<List<HashPointer>> bucket;

    public CdbBuilder(String string, String string2) throws IOException {
        this.filename = string;
        this.tmpFilename = string2;
        this.file = new RandomAccessFile(string2, "rw");
        this.bucket = new ArrayList<List<HashPointer>>(256);
        for (int i = 0; i < 256; ++i) {
            this.bucket.add(new ArrayList());
        }
        this.file.seek(2048L);
    }

    public void add(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws IOException {
        int n5 = (int)this.file.getFilePointer();
        CdbBuilder.writeIntInLittleEndian(this.file, n2);
        CdbBuilder.writeIntInLittleEndian(this.file, n4);
        this.file.write(byArray, n, n2);
        this.file.write(byArray2, n3, n4);
        int n6 = Cdb.hash(byArray, n, n2);
        this.bucket.get(n6 & 0xFF).add(new HashPointer(n6, n5));
    }

    public void add(byte[] byArray, byte[] byArray2) throws IOException {
        int n = (int)this.file.getFilePointer();
        CdbBuilder.writeIntInLittleEndian(this.file, byArray.length);
        CdbBuilder.writeIntInLittleEndian(this.file, byArray2.length);
        this.file.write(byArray);
        this.file.write(byArray2);
        int n2 = Cdb.hash(byArray, 0, byArray.length);
        this.bucket.get(n2 & 0xFF).add(new HashPointer(n2, n));
    }

    public void finish() throws IOException {
        List<HashPointer> list2;
        int n = (int)this.file.getFilePointer();
        for (List<HashPointer> list2 : this.bucket) {
            if (list2.size() == 0) continue;
            int n2 = list2.size() * 2;
            HashPointer[] hashPointerArray = new HashPointer[n2];
            for (int i = 0; i < hashPointerArray.length; ++i) {
                hashPointerArray[i] = new HashPointer(0, 0);
            }
            for (HashPointer hashPointer : list2) {
                int n3 = (hashPointer.h >>> 8) % n2;
                while (hashPointerArray[n3].p != 0) {
                    n3 = (n3 + 1) % n2;
                }
                hashPointerArray[n3] = hashPointer;
            }
            for (HashPointer hashPointer : hashPointerArray) {
                CdbBuilder.writeIntInLittleEndian(this.file, hashPointer.h);
                CdbBuilder.writeIntInLittleEndian(this.file, hashPointer.p);
            }
        }
        this.file.seek(0L);
        for (List<HashPointer> list2 : this.bucket) {
            CdbBuilder.writeIntInLittleEndian(this.file, n);
            CdbBuilder.writeIntInLittleEndian(this.file, list2.size() * 2);
            n += list2.size() * 2 * 8;
        }
        this.file.close();
        File file = new File(this.tmpFilename);
        list2 = new File(this.filename);
        file.renameTo((File)((Object)list2));
    }

    private static void writeIntInLittleEndian(RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.write((byte)n & 0xFF);
        randomAccessFile.write((byte)(n >> 8 & 0xFF));
        randomAccessFile.write((byte)(n >> 16 & 0xFF));
        randomAccessFile.write((byte)(n >> 24 & 0xFF));
    }

    private static final class HashPointer {
        int h;
        int p;

        public HashPointer(int n, int n2) {
            this.h = n;
            this.p = n2;
        }
    }
}

