/*
 * Decompiled with CFR 0.152.
 */
package Jet.Time;

import Jet.Time.PatternItem;
import Jet.Time.PatternMatchResult;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberPattern
extends PatternItem {
    private int min;
    private int max;
    private Ordinal ordinal;

    public NumberPattern(int n, int n2, Ordinal ordinal) {
        this.min = n;
        this.max = n2;
        this.ordinal = ordinal;
    }

    public NumberPattern(int n, int n2) {
        this(n, n2, Ordinal.SHOULD);
    }

    public NumberPattern(Ordinal ordinal) {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, ordinal);
    }

    public NumberPattern() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, Ordinal.SHOULD);
    }

    @Override
    public PatternMatchResult match(Document document, List<Annotation> list, int n) {
        int n2 = list.get(n).start();
        Vector<Annotation> vector = document.annotationsAt(n2, "number");
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Annotation annotation = (Annotation)vector.get(0);
        Number number = (Number)annotation.get("value");
        Boolean bl = (Boolean)annotation.get("ordinal");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (this.min <= number.intValue() && number.intValue() <= this.max) {
            if (this.ordinal == Ordinal.MUST && !bl.booleanValue()) {
                return null;
            }
            if (this.ordinal == Ordinal.MUST_NOT && bl.booleanValue()) {
                return null;
            }
            return new PatternMatchResult(number, annotation.span());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ordinal {
        MUST,
        SHOULD,
        MUST_NOT;

    }
}

