/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Lisp.FeatureSet;
import Jet.Lisp.Variable;
import Jet.Pat.AtomicPatternElement;
import Jet.Pat.PatternApplication;
import Jet.Pat.PatternNode;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.HashMap;

public class IntegerPatternElement
extends AtomicPatternElement {
    Integer min;
    Integer max;
    Variable intvalueVariable;

    public IntegerPatternElement(FeatureSet featureSet) {
        this.min = (Integer)featureSet.get("min");
        this.max = (Integer)featureSet.get("max");
        this.intvalueVariable = (Variable)featureSet.get("intvalue");
    }

    public void eval(Document document, int n, String string, HashMap hashMap, PatternApplication patternApplication, PatternNode patternNode) {
        Annotation annotation = document.tokenAt(n);
        if (annotation == null) {
            return;
        }
        Integer n2 = (Integer)annotation.get("intvalue");
        if (n2 == null) {
            return;
        }
        if (this.min != null && n2 < this.min) {
            return;
        }
        if (this.max != null && n2 > this.max) {
            return;
        }
        int n3 = annotation.span().end();
        if (this.intvalueVariable != null) {
            hashMap = (HashMap)hashMap.clone();
            hashMap.put(this.intvalueVariable.name, n2);
        }
        patternNode.eval(document, n3, hashMap, patternApplication);
    }

    public String toString() {
        String string = "[integer";
        if (this.min != null) {
            string = string + "min = " + this.min;
        }
        if (this.max != null) {
            string = string + "max = " + this.max;
        }
        string = string + "]";
        return string;
    }
}

