/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import AceJet.Ace;
import Jet.Control;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMMstate;
import Jet.HMM.Retagger;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.ParseTreeNode;
import Jet.Pat.Pat;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SpecialZoner;
import danbikel.lisp.Sexp;
import danbikel.lisp.SexpList;
import danbikel.lisp.Symbol;
import danbikel.parser.Parser;
import danbikel.parser.Settings;
import danbikel.parser.english.HeadFinder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatParser {
    static int nextToken = 0;
    static ArrayList<String> words;
    static ArrayList<Span> spans;
    static ArrayList<Annotation> wordDefns;
    static ArrayList<String> pennPOS;
    static Parser parser;
    static boolean initialized;
    static final boolean findHeads = true;
    static HeadFinder headFinder;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 4) {
            System.err.println("StatParser requires 4 arguments");
            System.err.println("  properties-file input-directory output-directory list-of-files");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        System.out.println("Starting Jet StatParser ...");
        JetTest.initializeFromConfig(string);
        Pat.trace = false;
        StatParser.parseCollection(string2, string3, string4);
    }

    public static void initialize(String string, Properties properties) {
        String string2 = properties.getProperty("StatParser.properties.fileName");
        String string3 = properties.getProperty("StatParser.grammar.fileName");
        if (string2 == null && string3 == null) {
            return;
        }
        if (string2 == null || string3 == null) {
            System.err.println("Error in properties file:  for StatParser, both");
            System.err.println("properties.Filename and grammar.fileName must be specified");
            return;
        }
        StatParser.initialize(string + File.separatorChar + string2, string + File.separatorChar + string3);
    }

    public static void initialize(String string, String string2) {
        try {
            Settings.load(string);
            parser = new Parser(string2);
            initialized = true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Unable to initialize parser.");
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static ParseTreeNode parse(Document document, Span span) {
        SexpList sexpList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        JetTest.tagger.annotate(document, span, "tagger");
        int n = span.start();
        int n2 = span.end();
        StatParser.buildParserInput(document, n, n2, true);
        StatParser.fixHyphenatedItems(document);
        if (wordDefns.size() == 0) {
            System.out.println("StatParse:  no tokens in span");
            return null;
        }
        SexpList sexpList2 = new SexpList();
        for (int i = 0; i < words.size(); ++i) {
            object4 = words.get(i);
            object3 = pennPOS.get(i);
            object2 = new SexpList();
            ((SexpList)object2).add(Symbol.get((String)object3));
            object = new SexpList();
            ((SexpList)object).add(Symbol.get((String)object4));
            ((SexpList)object).add((Sexp)object2);
            sexpList2.add((Sexp)object);
        }
        System.out.println("Sentence = " + sexpList2.toString());
        try {
            sexpList = parser.parse(sexpList2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("No parse possible.");
            return null;
        }
        if (sexpList == null) {
            System.out.println("No parse possible.");
            return null;
        }
        System.out.println("Parse = " + sexpList);
        if (headFinder == null) {
            try {
                headFinder = new HeadFinder();
            }
            catch (IOException iOException) {
                System.out.println("StatParser: " + iOException);
                System.out.println("Unable to generate heads.");
            }
        }
        nextToken = 0;
        object4 = StatParser.makeParseTree(document, sexpList);
        object3 = ParseTreeNode.makeParseAnnotations(document, (ParseTreeNode)object4);
        StatParser.deleteUnusedConstits(document, span, (Annotation)object3);
        object2 = document.annotationsAt(n, "sentence");
        if (object2 != null && ((Vector)object2).size() > 0) {
            object = (Annotation)((Vector)object2).get(0);
            ((Annotation)object).put("parse", object3);
        }
        return object4;
    }

    public static void deleteUnusedConstits(Document document, Span span, Annotation annotation) {
        Set<Annotation> set = StatParser.descendants(annotation);
        Vector<Annotation> vector = document.annotationsOfType("constit", span);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation2 = vector.get(i);
            if (set != null && set.contains(annotation2)) continue;
            document.removeAnnotation(annotation2);
        }
    }

    public static void buildParserInput(Document document, int n, int n2, boolean bl) {
        wordDefns = new ArrayList();
        pennPOS = new ArrayList();
        words = new ArrayList();
        spans = new ArrayList();
        int n3 = Tokenizer.skipWSX(document, n, n2);
        while (n3 < n2) {
            Span span;
            Object object;
            Vector<Annotation> vector = document.annotationsAt(n3, "constit");
            Annotation annotation = null;
            String string = null;
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    object = vector.get(i);
                    if (((Annotation)object).get("hidden") != null) continue;
                    annotation = object;
                    string = (String)annotation.get("cat");
                    break;
                }
            }
            wordDefns.add(annotation);
            if (bl) {
                String string2 = StatParser.ptbPOS(document, n3, annotation, string);
                pennPOS.add(string2);
            } else {
                pennPOS.add(null);
            }
            if (annotation != null) {
                span = annotation.span();
            } else {
                object = document.tokenAt(n3);
                if (object == null) break;
                span = ((Annotation)object).span();
            }
            spans.add(span);
            object = document.text(span).trim();
            if (((String)object).equals("_")) {
                object = "--";
            } else if (((String)object).equals("(")) {
                object = "-LRB-";
            } else if (((String)object).equals(")")) {
                object = "-RRB-";
            } else if (((String)object).equals("\"")) {
                object = "''";
            }
            words.add((String)object);
            n3 = span.end();
        }
    }

    private static String ptbPOS(Document document, int n, Annotation annotation, String string) {
        String string2;
        if (string == "name") {
            return "NNP";
        }
        Vector<Annotation> vector = document.annotationsAt(n, "tagger");
        Annotation annotation2 = vector.get(0);
        String string3 = (String)annotation2.get("cat");
        String string4 = document.text(annotation2).trim().toLowerCase();
        Vector<Annotation> vector2 = document.annotationsAt(n, "constit");
        if (vector2 == null || vector2.size() == 0) {
            return string3;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Annotation annotation3 = vector2.get(i);
            if (!annotation2.span().equals(annotation3.span())) continue;
            FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string4, string3);
            for (int j = 0; j < featureSetArray.length; ++j) {
                if (!featureSetArray[j].subsetOf(annotation3.attributes())) continue;
                return string3;
            }
        }
        if (annotation != null && (string2 = Retagger.jetToPtbPos(annotation.attributes())) != null) {
            return string2;
        }
        return string3;
    }

    public static void fixHyphenatedItems(Document document) {
        for (int i = 1; i < words.size() - 1; ++i) {
            if (!words.get(i).equals("-") || spans.get(i - 1).end() != spans.get(i).start() || spans.get(i).end() != spans.get(i + 1).start()) continue;
            Annotation annotation = new Annotation("constit", spans.get(i), new FeatureSet("cat", "-"));
            document.addAnnotation(annotation);
            wordDefns.set(i, annotation);
            Span span = new Span(spans.get(i - 1).start(), spans.get(i + 1).end());
            Annotation[] annotationArray = new Annotation[3];
            annotationArray[0] = wordDefns.get(i - 1);
            if (annotationArray[0] == null) {
                annotationArray[0] = new Annotation("constit", spans.get(i - 1), new FeatureSet("cat", "?"));
                document.addAnnotation(annotationArray[0]);
            }
            annotationArray[1] = wordDefns.get(i);
            annotationArray[2] = wordDefns.get(i + 1);
            if (annotationArray[2] == null) {
                annotationArray[2] = new Annotation("constit", spans.get(i + 1), new FeatureSet("cat", "?"));
                document.addAnnotation(annotationArray[2]);
            }
            Annotation annotation2 = new Annotation("constit", span, new FeatureSet("cat", "hyphword", "children", annotationArray));
            document.addAnnotation(annotation2);
            spans.set(i - 1, span);
            spans.remove(i + 1);
            spans.remove(i);
            words.set(i - 1, document.text(span).trim());
            words.remove(i + 1);
            words.remove(i);
            pennPOS.set(i - 1, "JJ");
            pennPOS.remove(i + 1);
            pennPOS.remove(i);
            wordDefns.set(i - 1, annotation2);
            wordDefns.remove(i + 1);
            wordDefns.remove(i);
        }
    }

    private static ParseTreeNode makeParseTree(Document document, Sexp sexp) {
        int n;
        if (!sexp.isList()) {
            System.out.println("StatParse:  invalid Sexp for parse node " + sexp.toString());
            return null;
        }
        SexpList sexpList = (SexpList)sexp;
        if (sexpList.length() < 2) {
            System.out.println("StatParse:  invalid Sexp for parse node " + sexpList.toString());
            return null;
        }
        Sexp sexp2 = sexpList.get(0);
        if (!sexp2.isSymbol()) {
            System.out.println("StatParse:  invalid Sexp for parse node " + sexpList.toString());
            return null;
        }
        String string = ((Symbol)sexp2).toString().intern();
        String string2 = string.toLowerCase().intern();
        Sexp sexp3 = sexpList.get(1);
        if (sexp3.isSymbol()) {
            String string3 = ((Symbol)sexp3).toString();
            String string4 = words.get(nextToken);
            while (!string4.equals(string3)) {
                System.out.println("StatParser:  parse skips " + string4 + " in sentence.");
                if (++nextToken >= words.size()) {
                    System.out.println("*** Unable to align sentence and parse tree.");
                    return null;
                }
                string4 = words.get(nextToken);
            }
            Annotation annotation = wordDefns.get(nextToken);
            Span span = spans.get(nextToken);
            annotation = StatParser.buildWordDefn(document, string4, span, annotation, string);
            ++nextToken;
            return new ParseTreeNode((Object)string2, null, annotation.start(), annotation.end(), annotation, string4);
        }
        int n2 = 0;
        n2 = headFinder.findHead(sexp);
        int n3 = sexpList.length() - 1;
        int n4 = nextToken;
        int n5 = spans.get(n4).start();
        ParseTreeNode[] parseTreeNodeArray = new ParseTreeNode[n3];
        for (n = 0; n < n3; ++n) {
            parseTreeNodeArray[n] = StatParser.makeParseTree(document, sexpList.get(n + 1));
        }
        n = n5;
        if (nextToken > n4) {
            n = spans.get(nextToken - 1).end();
        }
        return new ParseTreeNode(string2, parseTreeNodeArray, n5, n, n2);
    }

    public static Annotation buildWordDefn(Document document, String string, Span span, Annotation annotation, String string2) {
        Object object;
        Vector<Annotation> vector;
        if (annotation != null && ((vector = (String)annotation.get("cat")) == "name" || vector == "hyphword")) {
            return annotation;
        }
        vector = document.annotationsAt(span.start(), "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (Annotation)vector.get(i);
                if (((Annotation)object).get("hidden") != null || !Retagger.compatible(string, string2, (Annotation)object)) continue;
                return object;
            }
        }
        if (string2 != "POS" && annotation != null) {
            return annotation;
        }
        FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string, string2);
        if (featureSetArray.length > 0) {
            object = new FeatureSet(featureSetArray[0]);
            String string3 = (String)((FeatureSet)object).get("cat");
            if (string3 == "n" || string3 == "v" || string3 == "tv" || string3 == "ving" || string3 == "ven") {
                ((FeatureSet)object).put("pa", new FeatureSet("head", string.toLowerCase().intern()));
            }
            annotation = new Annotation("constit", span, (FeatureSet)object);
            document.addAnnotation(annotation);
            return annotation;
        }
        annotation = new Annotation("constit", span, new FeatureSet("cat", string2.toLowerCase().intern()));
        document.addAnnotation(annotation);
        return annotation;
    }

    public static Set<Annotation> descendants(Annotation annotation) {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.add(annotation);
        Annotation[] annotationArray = ParseTreeNode.children(annotation);
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                if (annotationArray[i] == null) continue;
                hashSet.addAll(StatParser.descendants(annotationArray[i]));
            }
        }
        return hashSet;
    }

    private static void parseCollection(String string, String string2, String string3) throws IOException {
        DocumentCollection documentCollection = new DocumentCollection(string, string3);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            String string4 = externalDocument.fileName();
            if (new File(string2, string4).exists()) {
                System.out.println("\nSkipping document   " + i + ": " + externalDocument.fileName());
                continue;
            }
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            SpecialZoner.findSpecialZones(externalDocument);
            BigramHMMemitter.useBigrams = Ace.monocase = Ace.allLowerCase(externalDocument);
            HMMstate.otherPreference = Ace.monocase ? 1.0 : 0.0;
            Control.processDocument(externalDocument, null, i == -1, i);
            externalDocument.removeAnnotationsOfType("ENAMEX");
            StatParser.clearInputAnnotations(externalDocument);
            externalDocument.removeAnnotationsOfType("tagger");
            externalDocument.saveIn(string2);
        }
    }

    public static void clearInputAnnotations(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("ANNOTATION");
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            int n = annotation.span().start();
            int n2 = annotation.span().end();
            for (int j = n; j < n2; ++j) {
                if (Character.isWhitespace(document.charAt(i))) continue;
                document.setCharAt(i, ' ');
            }
        }
        document.removeAnnotationsOfType("ANNOTATION");
    }

    static {
        initialized = false;
        headFinder = null;
    }
}

