/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.JetTest;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationColorEntry;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;

public class AnnotationColor {
    public static ArrayList colors = new ArrayList();
    static File colorFile;
    static JFrame colorFrame;
    static final int ALPHA = 150;

    public AnnotationColor(String string) {
        this(string, "annColors.clr");
    }

    public AnnotationColor(String string, String string2) {
        try {
            colorFile = new File(string, string2);
            if (!colorFile.createNewFile()) {
                System.out.println("Reading colors from file " + colorFile);
                AnnotationColor.readColors();
            }
            if (!JetTest.batchFlag) {
                colorFrame = new JFrame("Customize Annotation Color");
                colorFrame.getContentPane().setLayout(new GridLayout(0, 1));
                colorFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        colorFrame.dispose();
                    }
                });
                AnnotationColor.fillColorFrame();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void readColors() {
        try {
            String string;
            colors.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(colorFile));
            while ((string = bufferedReader.readLine()) != null) {
                AnnotationColorEntry annotationColorEntry = AnnotationColorEntry.read(string);
                if (annotationColorEntry == null) continue;
                colors.add(annotationColorEntry);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeColors() {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(colorFile)));
            for (int i = 0; i < colors.size(); ++i) {
                AnnotationColorEntry annotationColorEntry = (AnnotationColorEntry)colors.get(i);
                printWriter.println(annotationColorEntry.toString());
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Error writing to file " + colorFile);
        }
    }

    public static void addType(String string) {
        for (int i = 0; i < colors.size(); ++i) {
            if (!((AnnotationColorEntry)AnnotationColor.colors.get((int)i)).type.equals(string)) continue;
            return;
        }
        String string2 = "#" + Integer.toHexString(string.hashCode() & 0xFFFFFF);
        colors.add(new AnnotationColorEntry(string, null, null, string2, ' '));
        if (colorFile != null) {
            AnnotationColor.writeColors();
            if (!JetTest.batchFlag) {
                AnnotationColor.showColors();
            }
        }
    }

    private static void fillColorFrame() {
        colorFrame.getContentPane().removeAll();
        for (int i = 0; i < colors.size(); ++i) {
            final int n = i;
            AnnotationColorEntry annotationColorEntry = (AnnotationColorEntry)colors.get(i);
            JButton jButton = new JButton(annotationColorEntry.typeAndFeature());
            jButton.setBackground(AnnotationColor.setAlpha(Color.decode(annotationColorEntry.color), 150));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    Color color = JColorChooser.showDialog(colorFrame, "Choose Background Color", jButton.getBackground());
                    if (color != null) {
                        jButton.setBackground(color);
                        ((AnnotationColorEntry)AnnotationColor.colors.get((int)n)).color = "#" + Integer.toHexString(color.hashCode());
                        AnnotationColor.writeColors();
                    }
                }
            });
            colorFrame.getContentPane().add(jButton);
        }
    }

    public static void showColors() {
        AnnotationColor.readColors();
        AnnotationColor.fillColorFrame();
        colorFrame.pack();
        colorFrame.setVisible(true);
    }

    public static Color getColor(Annotation annotation) {
        String string = annotation.type();
        for (int i = 0; i < colors.size(); ++i) {
            AnnotationColorEntry annotationColorEntry = (AnnotationColorEntry)colors.get(i);
            if (!string.equals(annotationColorEntry.type) || annotationColorEntry.feature != null && !annotation.get(annotationColorEntry.feature).equals(annotationColorEntry.featureValue)) continue;
            return AnnotationColor.setAlpha(Color.decode(annotationColorEntry.color), 150);
        }
        return null;
    }

    private static Color setAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    static {
        colorFrame = null;
    }
}

