/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.EventTagger;
import Jet.Control;
import Jet.JetTest;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class TrainEventTagger {
    static final String eventFeatureFileName = "eventFeatureFile.log";
    static final String eventModelFileName = "eventModel.log";
    static final String corefFeatureFileName = "corefFeatureFile.log";
    static final String corefModelFileName = "corefModel.log";
    static final String argFeatureFileName = "argFeatureFile.log";
    static final String argModelFileName = "argModel.log";
    static final String roleFeatureFileName = "roleFeatureFile.log";
    static final String roleModelFileName = "roleModel.log";
    static final String argFeatureHalfFileName = "argFeatureHalfFile.log";
    static final String argModelHalfFileName = "argModelHalf.log";
    static final String roleFeatureHalfFileName = "roleFeatureHalfFile.log";
    static final String roleModelHalfFileName = "roleModelHalf.log";
    static final String eventPatternFile = "eventPatterns.log";
    static final String eventReportFile = "eventPatternReport.log";
    static final String halfEventPatternFile = "eventPatternsHalf.log";
    static String fileListTrain;
    static String docDir;
    static String outputDir;
    static boolean processOnlyOddDocuments;
    static boolean processOnlyEvenDocuments;

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting ACE event tagger training procedure.");
        if (stringArray.length != 4 && stringArray.length != 6) {
            System.out.println("EventTagger must take 4 or 6 arguments:");
            System.out.println("    properties filelist documentDir outputDir [glarfDir glarfSuffix]");
            System.exit(1);
        }
        String string = stringArray[0];
        fileListTrain = stringArray[1];
        docDir = stringArray[2];
        if (!docDir.endsWith("/")) {
            docDir = docDir + "/";
        }
        EventTagger.docDir = docDir;
        outputDir = stringArray[3];
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        EventTagger.glarfDir = null;
        if (stringArray.length == 6) {
            EventTagger.glarfDir = stringArray[4];
            if (!EventTagger.glarfDir.endsWith("/")) {
                EventTagger.glarfDir = EventTagger.glarfDir + "/";
            }
            EventTagger.triplesSuffix = stringArray[5];
            EventTagger.usePA = true;
        }
        JetTest.initializeFromConfig(string);
        Pat.trace = false;
        Resolve.trace = false;
        AceDocument.ace2005 = true;
        EventTagger eventTagger = new EventTagger();
        eventTagger.argFeatureWriter = new PrintStream(new FileOutputStream(outputDir + argFeatureFileName));
        eventTagger.roleFeatureWriter = new PrintStream(new FileOutputStream(outputDir + roleFeatureFileName));
        System.out.println("\n===== Acquiring patterns and training argument model. =====\n");
        TrainEventTagger.train(eventTagger, fileListTrain, 0);
        TrainEventTagger.train(eventTagger, fileListTrain, 1);
        eventTagger.report(outputDir + eventReportFile);
        eventTagger.argFeatureWriter.close();
        eventTagger.roleFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + argFeatureFileName, outputDir + argModelFileName);
        TrainEventTagger.buildClassifierModel(outputDir + roleFeatureFileName, outputDir + roleModelFileName);
        eventTagger.save(outputDir + eventPatternFile);
        System.out.println("\n===== Training event model. =====\n");
        TrainEventTagger.trainEventModel(eventTagger);
        System.out.println("\n===== Training coreference model. =====\n");
        TrainEventTagger.trainCorefModel(eventTagger);
    }

    private static void trainEventModel(EventTagger eventTagger) throws IOException {
        processOnlyOddDocuments = true;
        eventTagger.argFeatureWriter = new PrintStream(new FileOutputStream(outputDir + argFeatureHalfFileName));
        eventTagger.roleFeatureWriter = new PrintStream(new FileOutputStream(outputDir + roleFeatureHalfFileName));
        TrainEventTagger.train(eventTagger, fileListTrain, 0);
        TrainEventTagger.train(eventTagger, fileListTrain, 1);
        eventTagger.save(outputDir + halfEventPatternFile);
        eventTagger.argFeatureWriter.close();
        eventTagger.roleFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + argFeatureHalfFileName, outputDir + argModelHalfFileName);
        TrainEventTagger.buildClassifierModel(outputDir + roleFeatureHalfFileName, outputDir + roleModelHalfFileName);
        EventTagger.argModel = EventTagger.loadClassifierModel(outputDir + argModelHalfFileName);
        EventTagger.roleModel = EventTagger.loadClassifierModel(outputDir + roleModelHalfFileName);
        eventTagger.eventFeatureWriter = new PrintStream(new FileOutputStream(outputDir + eventFeatureFileName));
        processOnlyOddDocuments = false;
        processOnlyEvenDocuments = true;
        TrainEventTagger.train(eventTagger, fileListTrain, 2);
        eventTagger.eventFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + eventFeatureFileName, outputDir + eventModelFileName);
    }

    private static void trainCorefModel(EventTagger eventTagger) throws IOException {
        EventTagger.argModel = EventTagger.loadClassifierModel(outputDir + argModelHalfFileName);
        EventTagger.roleModel = EventTagger.loadClassifierModel(outputDir + roleModelHalfFileName);
        EventTagger.eventModel = EventTagger.loadClassifierModel(outputDir + eventModelFileName);
        eventTagger.load(outputDir + halfEventPatternFile);
        eventTagger.corefFeatureWriter = new PrintStream(new FileOutputStream(outputDir + corefFeatureFileName));
        processOnlyEvenDocuments = true;
        TrainEventTagger.train(eventTagger, fileListTrain, 3);
        eventTagger.corefFeatureWriter.close();
        TrainEventTagger.buildClassifierModel(outputDir + corefFeatureFileName, outputDir + corefModelFileName);
    }

    public static void train(EventTagger eventTagger, String string, int n) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n2 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (processOnlyOddDocuments && ++n2 % 2 == 0 || processOnlyEvenDocuments && n2 % 2 == 1) continue;
            System.out.println("\nProcessing file " + string2);
            String string3 = docDir + string2 + ".sgm";
            String string4 = docDir + string2 + ".apf.xml";
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            externalDocument.stretchAll();
            Resolve.ACE = true;
            Ace.monocase = Ace.allLowerCase(externalDocument);
            Control.processDocument(externalDocument, null, false, 0);
            AceDocument aceDocument = new AceDocument(string3, string4);
            if (n == 0) {
                eventTagger.acquirePatterns(externalDocument, aceDocument, string2);
                continue;
            }
            if (n == 1) {
                eventTagger.evaluatePatterns(externalDocument, aceDocument, string2);
                continue;
            }
            if (n == 2) {
                eventTagger.trainEventModel(externalDocument, aceDocument, string2);
                continue;
            }
            eventTagger.trainCorefModel(externalDocument, aceDocument, string2);
        }
        bufferedReader.close();
    }

    private static void buildClassifierModel(String string, String string2) {
        boolean bl = false;
        boolean bl2 = true;
        double d = 0.1;
        try {
            FileReader fileReader = new FileReader(new File(string));
            BasicEventStream basicEventStream = new BasicEventStream(new PlainTextByLineDataStream(fileReader));
            GIS.SMOOTHING_OBSERVATION = d;
            GISModel gISModel = GIS.trainModel(basicEventStream, 100, 4, bl, bl2);
            File file = new File(string2);
            SuffixSensitiveGISModelWriter suffixSensitiveGISModelWriter = new SuffixSensitiveGISModelWriter(gISModel, file);
            suffixSensitiveGISModelWriter.persist();
        }
        catch (Exception exception) {
            System.err.print("Unable to create model due to exception: ");
            System.err.println(exception);
        }
    }

    static {
        processOnlyOddDocuments = false;
        processOnlyEvenDocuments = false;
    }
}

