/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceRelation;
import AceJet.AceRelationMention;
import AceJet.ChunkPath;
import AceJet.Datum;
import AceJet.PerfectAce;
import AceJet.PerfectNameTagger;
import Jet.Control;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.MaxEntModel;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Scorer.NameTagger;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTagger {
    static boolean useParser = false;
    public static boolean relationTrace = false;
    static Document doc;
    static AceDocument aceDoc;
    static String currentDoc;
    static NameTagger realNameTagger;
    static SentenceSet sentences;
    static final String[] relations;
    static HashMap mentionIDMap;
    static HashMap mentionHeadMap;
    static HashMap mentionStartMap;
    static Set<AceEntityMention> mentionSet;
    static TreeSet<AceEntityMention> allMentionSet;
    static ArrayList<AceRelationMention> relMentionList;
    static List<AceRelation> relationList;
    static String docName;
    static final boolean expandConjuncts = true;
    static HashMap conjunctf;
    static HashMap conjunctb;
    static MaxEntModel model0;
    static MaxEntModel model1;
    static MaxEntModel model2;
    static MaxEntModel model3;
    static Map<String, String> typeConstraints;
    static Map<String, String> syntacticRelationMap;
    private static final int mentionWindow = 4;
    static String[] relatives;
    static double threshold;
    public static boolean mergeMultipleRelations;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 7) {
            System.err.println("RelationTagger requires 7 arguments:");
            System.err.println("  configFile docList textDir textSuffix apfDir apfSuffix modelDirectory");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        System.out.println("Learning relations ...");
        JetTest.initializeFromConfig(string);
        Ace.setAceYear();
        realNameTagger = JetTest.nameTagger;
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        Ace.perfectMentions = true;
        Ace.perfectEntities = true;
        model0 = new MaxEntModel(string7 + "/" + "featureFile-0", string7 + "/" + "modelFile-0");
        model1 = new MaxEntModel(string7 + "/" + "featureFile-1", string7 + "/" + "modelFile-1");
        model2 = new MaxEntModel(string7 + "/" + "featureFile-2", string7 + "/" + "modelFile-2");
        model3 = new MaxEntModel(string7 + "/" + "featureFile-3", string7 + "/" + "modelFile-3");
        model0.initializeForTraining();
        model1.initializeForTraining();
        model2.initializeForTraining();
        model3.initializeForTraining();
        RelationTagger.learnFromFileList(string2, string3, string4, string5, string6);
        model0.buildModel();
        model1.buildModel();
        model2.buildModel();
        model3.buildModel();
        model0.saveModel();
        model1.saveModel();
        model2.saveModel();
        model3.saveModel();
    }

    static void learnFromFileList(String string, String string2, String string3, String string4, String string5) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((currentDoc = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + currentDoc);
            String string6 = string2 + "/" + currentDoc + "." + string3;
            ExternalDocument externalDocument = new ExternalDocument("sgml", string6);
            externalDocument.setAllTags(true);
            externalDocument.open();
            doc = externalDocument;
            RelationTagger.readACErelations(string6, string4 + "/" + currentDoc + "." + string5);
            Ace.monocase = Ace.allLowerCase(doc);
            PerfectAce.buildEntityMentionMap(externalDocument, aceDoc);
            JetTest.nameTagger = new PerfectNameTagger(aceDoc, realNameTagger);
            Control.processDocument(doc, null, n < 0, n);
            sentences = new SentenceSet(doc);
            RelationTagger.findSyntacticRelations(doc);
            List<AceEntityMention[]> list = RelationTagger.findMentionPairs();
            for (AceEntityMention[] aceEntityMentionArray : list) {
                RelationTagger.addTrainingInstance(aceEntityMentionArray[0], aceEntityMentionArray[1]);
            }
            RelationTagger.reportLeftovers();
        }
    }

    public static void findRelations(String string, Document document, AceDocument aceDocument) {
        doc = document;
        aceDoc = aceDocument;
        docName = string;
        sentences = new SentenceSet(doc);
        relationList = new ArrayList<AceRelation>();
        RelationTagger.findEntityMentions(aceDoc);
        RelationTagger.findConjuncts(doc);
        RelationTagger.findSyntacticRelations(doc);
        List<AceEntityMention[]> list = RelationTagger.findMentionPairs();
        for (AceEntityMention[] aceEntityMentionArray : list) {
            RelationTagger.predictRelation(aceEntityMentionArray[0], aceEntityMentionArray[1]);
        }
        RelationTagger.extendRelationsToConjuncts();
        RelationTagger.relationCoref(aceDoc);
        RelationTagger.removeRedundantMentions(aceDoc);
    }

    static void loadModels(String string) {
        model0 = new MaxEntModel();
        model1 = new MaxEntModel();
        model2 = new MaxEntModel();
        model3 = new MaxEntModel();
        model0.loadModel(string + "/" + "modelFile-0");
        model1.loadModel(string + "/" + "modelFile-1");
        model2.loadModel(string + "/" + "modelFile-2");
        model3.loadModel(string + "/" + "modelFile-3");
        RelationTagger.loadTypeConstraints(string + "/" + "argTypes");
    }

    static void loadTypeConstraints(String string) {
        typeConstraints = new HashMap<String, String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\\s+", 3);
                typeConstraints.put(stringArray[0] + "." + stringArray[1], stringArray[2]);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error opening relation type constraint file");
            System.err.println("  " + iOException);
            System.err.println("  Type constraints will not be enforced for relations");
        }
    }

    static boolean satisfiesTypeConstraint(String string, String string2, String string3, String string4) {
        if (typeConstraints.isEmpty()) {
            return true;
        }
        string4 = string4.substring(0, 3);
        String string5 = string + "." + string2 + "." + string3;
        String string6 = typeConstraints.get(string5);
        if (string6 == null) {
            System.err.println("No relation type constraint for " + string5);
            return true;
        }
        boolean bl = string6.contains(string4);
        if (relationTrace && !bl) {
            System.out.println("Relation type violation for " + string5);
            System.out.println("  arg is " + string4 + ", allowed types are " + string6);
        }
        return bl;
    }

    private static void findSyntacticRelations(Document document) {
        syntacticRelationMap = new HashMap<String, String>();
        Vector<Annotation> vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (Annotation annotation : vector) {
                String string2;
                for (String string2 : relations) {
                    if (annotation.get(string2) == null) continue;
                    Annotation annotation2 = (Annotation)annotation.get(string2);
                    RelationTagger.recordSyntacticRelation(annotation, string2, annotation2);
                }
                Annotation object = (Annotation)annotation.get("subject");
                Annotation annotation3 = (Annotation)annotation.get("headC");
                if (object == null || annotation3 == null || annotation3.get("object") == null) continue;
                Annotation annotation4 = (Annotation)annotation3.get("object");
                string2 = SynFun.getNameOrHead(document, annotation3);
                RelationTagger.recordSyntacticRelation(object, string2, annotation4);
            }
        }
    }

    private static void recordSyntacticRelation(Annotation annotation, String string, Annotation annotation2) {
        Annotation annotation3;
        Span span;
        int n;
        AceEntityMention aceEntityMention;
        if (relationTrace) {
            System.out.println("recordSyntacticRelation relation = " + string);
            System.out.println("                        arg1 = " + doc.normalizedText(annotation) + " arg2 = " + doc.normalizedText(annotation2));
        }
        if ((aceEntityMention = (AceEntityMention)mentionHeadMap.get(new Integer(n = (span = (annotation3 = Resolve.getHeadC(annotation)).span()).start()))) == null) {
            return;
        }
        Annotation annotation4 = Resolve.getHeadC(annotation2);
        Span span2 = annotation4.span();
        int n2 = span2.start();
        AceEntityMention aceEntityMention2 = (AceEntityMention)mentionHeadMap.get(new Integer(n2));
        if (aceEntityMention2 == null) {
            return;
        }
        syntacticRelationMap.put(aceEntityMention.id + ":" + aceEntityMention2.id, string);
    }

    private static boolean canBeRelated(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        return !aceEntityMention.entity.id.equals(aceEntityMention2.entity.id);
    }

    private static List<AceEntityMention[]> findMentionPairs() {
        ArrayList<AceEntityMention[]> arrayList = new ArrayList<AceEntityMention[]>();
        if (mentionSet.isEmpty()) {
            return arrayList;
        }
        ArrayList<AceEntityMention> arrayList2 = new ArrayList<AceEntityMention>(mentionSet);
        for (int i = 0; i < arrayList2.size() - 1; ++i) {
            for (int j = 1; j <= 4 && i + j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention;
                AceEntityMention aceEntityMention2 = arrayList2.get(i);
                if (!RelationTagger.canBeRelated(aceEntityMention2, aceEntityMention = arrayList2.get(i + j)) || !sentences.inSameSentence(aceEntityMention2.jetHead.start(), aceEntityMention.jetHead.start())) continue;
                arrayList.add(new AceEntityMention[]{aceEntityMention2, aceEntityMention});
            }
        }
        return arrayList;
    }

    private static void addTrainingInstance(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        MaxEntModel maxEntModel;
        boolean bl;
        Datum datum = RelationTagger.relationFeatures(aceEntityMention, aceEntityMention2);
        String string = "nil";
        for (AceRelationMention object2 : relMentionList) {
            if (object2.arg1 == aceEntityMention && object2.arg2 == aceEntityMention2) {
                string = object2.relation.type + ":" + object2.relation.subtype;
                relMentionList.remove(object2);
                break;
            }
            if (object2.arg1 != aceEntityMention2 || object2.arg2 != aceEntityMention) continue;
            string = object2.relation.type + ":" + object2.relation.subtype + "-1";
            relMentionList.remove(object2);
            break;
        }
        MaxEntModel maxEntModel2 = (bl = RelationTagger.inSameBaseNP(aceEntityMention.head, aceEntityMention2.head)) ? model0 : model2;
        MaxEntModel maxEntModel3 = maxEntModel = bl ? model1 : model3;
        if (string == "nil") {
            datum.setOutcome("nil");
            maxEntModel2.addEvent(datum);
        } else {
            datum.setOutcome("t");
            maxEntModel2.addEvent(datum);
            datum.setOutcome(string);
            maxEntModel.addEvent(datum);
        }
    }

    private static Datum relationFeatures(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        Annotation annotation;
        String string2;
        Datum datum = new Datum();
        Span span = new Span(aceEntityMention.jetExtent.start(), aceEntityMention.jetHead.end());
        Span span2 = new Span(aceEntityMention2.jetExtent.start(), aceEntityMention2.jetHead.end());
        String[] stringArray = RelationTagger.tokensIn(aceEntityMention.jetHead.start(), aceEntityMention.jetHead.end()).toArray(new String[0]);
        String[] stringArray2 = RelationTagger.tokensIn(aceEntityMention2.jetHead.start(), aceEntityMention2.jetHead.end()).toArray(new String[0]);
        List<String> list = RelationTagger.tokensIn(span.end(), span2.start());
        int n = list.size();
        ChunkPath chunkPath = new ChunkPath(doc, span.end(), span2.start());
        int n2 = chunkPath.size();
        for (String string2 : stringArray) {
            datum.addFV("wm1", string2);
        }
        datum.addFV("hm1", aceEntityMention.headText.replaceAll("\\s+", "_"));
        String[] stringArray3 = stringArray2;
        int n3 = stringArray3.length;
        for (int i = 0; i < n3; ++i) {
            string2 = stringArray3[i];
            datum.addFV("wm2", string2);
        }
        datum.addFV("hm2", aceEntityMention2.headText.replaceAll("\\s+", "_"));
        String string3 = aceEntityMention.headText.replaceAll("\\s+", "_") + ":" + aceEntityMention2.headText.replaceAll("\\s+", "_");
        datum.addFV("hm12", string3);
        if (n == 0) {
            datum.addF("wbnull");
        } else if (n == 1) {
            datum.addFV("wbfl", list.get(0));
        } else {
            datum.addFV("wbf", list.get(0));
            for (n3 = 1; n3 < n - 1; ++n3) {
                datum.addFV("wbo", list.get(n3));
            }
            datum.addFV("wbl", list.get(n - 1));
        }
        Annotation annotation2 = doc.tokenEndingAt(span.start());
        if (annotation2 != null) {
            datum.addFV("bm1f", doc.text(annotation2).trim());
        }
        if ((annotation = doc.tokenAt(span2.end())) != null) {
            datum.addFV("am2f", doc.text(annotation).trim());
        }
        string2 = aceEntityMention.entity.type + ":" + aceEntityMention2.entity.type;
        datum.addFV("et12", string2);
        datum.addFV("et1sub2", aceEntityMention.entity.subtype + ":" + aceEntityMention2.entity.type);
        datum.addFV("et12sub", aceEntityMention.entity.type + ":" + aceEntityMention2.entity.subtype);
        datum.addFV("et1sub2sub", aceEntityMention.entity.subtype + ":" + aceEntityMention2.entity.subtype);
        datum.addFV("ml12", aceEntityMention.type + ":" + aceEntityMention2.type);
        datum.addFV("#wb", Integer.toString(list.size()));
        String string4 = span.within(span2) ? "true" : "false";
        String string5 = span2.within(span) ? "true" : "false";
        datum.addFV("et12+m1>m2", string2 + ":" + string4);
        datum.addFV("et12+m1<m2", string2 + ":" + string5);
        datum.addFV("hm12+m1>m2", string2 + ":" + string4);
        datum.addFV("hm12+m1<m2", string2 + ":" + string5);
        if (Ace.gazetteer.isCountry(stringArray2)) {
            datum.addFV("et1_country", aceEntityMention.entity.type);
        } else if (Ace.gazetteer.isNationality(stringArray2)) {
            datum.addFV("et1_nationality", aceEntityMention.entity.type);
        } else if (Ace.gazetteer.isCountry(stringArray)) {
            datum.addFV("country_et2", aceEntityMention2.entity.type);
        } else if (Ace.gazetteer.isNationality(stringArray)) {
            datum.addFV("nationality_et2", aceEntityMention2.entity.type);
        }
        if (RelationTagger.isRelative(aceEntityMention2.headText)) {
            datum.addFV("et1_relative", aceEntityMention.entity.type);
        } else if (RelationTagger.isRelative(aceEntityMention.headText)) {
            datum.addFV("relative_et2", aceEntityMention2.entity.type);
        } else {
            datum.addF("not_a_relative");
        }
        if (n2 == 0) {
            datum.addF("chpbnull");
        } else if (n2 == 1) {
            datum.addFV("chpbfl", chunkPath.chunks.get(0));
        } else if (n2 > 1) {
            datum.addFV("chpbf", chunkPath.chunks.get(0));
            for (int i = 1; i < n2 - 1; ++i) {
                datum.addFV("chpbo", chunkPath.chunks.get(i));
            }
            datum.addFV("chpbl", chunkPath.chunks.get(n2 - 1));
            datum.addFV("cpp", chunkPath.toString().replace(" ", "_"));
        }
        String string6 = aceEntityMention.headText.replaceAll("\\s+", "_");
        String string7 = aceEntityMention2.headText.replaceAll("\\s+", "_");
        String string8 = aceEntityMention.entity.type;
        String string9 = aceEntityMention2.entity.type;
        String string10 = "";
        if (syntacticRelationMap.get(aceEntityMention.id + ":" + aceEntityMention2.id) != null) {
            string10 = syntacticRelationMap.get(aceEntityMention.id + ":" + aceEntityMention2.id) + ":";
        } else if (syntacticRelationMap.get(aceEntityMention2.id + ":" + aceEntityMention.id) != null) {
            string10 = syntacticRelationMap.get(aceEntityMention2.id + ":" + aceEntityMention.id) + "-1:";
        }
        datum.addFV("etet", string10 + string8 + ":" + string9);
        datum.addFV("hmet", string10 + string6 + ":" + string9);
        datum.addFV("ethm", string10 + string8 + ":" + string7);
        datum.addFV("hmhm", string10 + string6 + ":" + string7);
        return datum;
    }

    static List<String> tokensIn(int n, int n2) {
        Annotation annotation;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        while (n3 < n2 && (annotation = doc.tokenAt(n3)) != null) {
            arrayList.add(doc.text(annotation).trim());
            n3 = annotation.end();
        }
        return arrayList;
    }

    static boolean isRelative(String string) {
        for (String string2 : relatives) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static void reportLeftovers() {
        for (AceRelationMention aceRelationMention : relMentionList) {
            System.out.println("Relation not used in training: " + aceRelationMention);
        }
    }

    static String getHead(AceEntityMention aceEntityMention) {
        Vector<Annotation> vector = doc.annotationsAt(aceEntityMention.jetHead.start(), "constit");
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                String string;
                String[] stringArray;
                Annotation annotation = vector.get(i);
                String string2 = (String)annotation.get("cat");
                if (string2 != "n" && string2 != "pro" && string2 != "name" && string2 != "adj" && string2 != "ven" && (string2 != "det" || annotation.get("tposs") != "t")) continue;
                if (string2 == "name") {
                    stringArray = Resolve.getNameTokens(doc, annotation);
                    if (Ace.gazetteer.isCountry(stringArray)) {
                        return "country";
                    }
                    if (Ace.gazetteer.isNationality(stringArray)) {
                        return "nationality";
                    }
                }
                if ((stringArray = (FeatureSet)annotation.get("pa")) == null || (string = (String)stringArray.get("head")) == null) continue;
                return string.replace(' ', '-').replace('\n', '-');
            }
        }
        return doc.text(aceEntityMention.jetHead).trim().replace(' ', '-').replace('\n', '-');
    }

    static void findConjuncts(Document document) {
        conjunctf.clear();
        conjunctb.clear();
        Vector<Annotation> vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.elementAt(i);
                Annotation annotation2 = (Annotation)annotation.get("conj");
                if (annotation2 == null) continue;
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
                arrayList.add(annotation);
                while (annotation2 != null) {
                    arrayList.add(annotation2);
                    annotation2 = (Annotation)annotation2.get("conj");
                }
                RelationTagger.recordConjunct(arrayList);
            }
        }
    }

    static void recordConjunct(ArrayList arrayList) {
        Object object;
        int n;
        String string = "";
        ArrayList<AceEntityMention> arrayList2 = new ArrayList<AceEntityMention>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Annotation)arrayList.get(n);
            AceEntityMention aceEntityMention = RelationTagger.mentionForAnnotation((Annotation)object);
            if (aceEntityMention == null) {
                return;
            }
            arrayList2.add(aceEntityMention);
            if (n == 0) {
                string = aceEntityMention.type;
                continue;
            }
            if (string.equals(aceEntityMention.type)) continue;
            return;
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            object = (AceEntityMention)arrayList2.get(n);
            AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(n + 1);
            conjunctf.put(object, aceEntityMention);
            conjunctb.put(aceEntityMention, object);
            if (!relationTrace) continue;
            System.out.println("Found conjuncts " + doc.text(((AceEntityMention)object).jetHead) + " and " + doc.text(aceEntityMention.jetHead));
        }
    }

    static AceEntityMention mentionForAnnotation(Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        Span span = annotation2.span();
        int n = span.start();
        return (AceEntityMention)mentionHeadMap.get(new Integer(n));
    }

    static ArrayList getConjuncts(AceEntityMention aceEntityMention) {
        ArrayList<AceEntityMention> arrayList = new ArrayList<AceEntityMention>();
        arrayList.add(aceEntityMention);
        AceEntityMention aceEntityMention2 = aceEntityMention;
        while (conjunctf.get(aceEntityMention2) != null) {
            aceEntityMention2 = (AceEntityMention)conjunctf.get(aceEntityMention2);
            arrayList.add(aceEntityMention2);
            if (!relationTrace) continue;
            System.out.println("Processing conjunct " + aceEntityMention2.text + " of " + aceEntityMention.text);
        }
        aceEntityMention2 = aceEntityMention;
        while (conjunctb.get(aceEntityMention2) != null) {
            aceEntityMention2 = (AceEntityMention)conjunctb.get(aceEntityMention2);
            arrayList.add(aceEntityMention2);
            if (!relationTrace) continue;
            System.out.println("Processing conjunct " + aceEntityMention2.text + " of " + aceEntityMention.text);
        }
        return arrayList;
    }

    static void extendRelationsToConjuncts() {
        ArrayList<AceRelation> arrayList = new ArrayList<AceRelation>(relationList);
        for (AceRelation aceRelation : arrayList) {
            AceRelationMention aceRelationMention = (AceRelationMention)aceRelation.mentions.get(0);
            AceEntityMention aceEntityMention = aceRelationMention.arg1;
            AceEntityMention aceEntityMention2 = aceRelationMention.arg2;
            if (aceEntityMention.jetExtent.end() >= aceEntityMention2.jetExtent.start() && aceEntityMention2.jetExtent.end() >= aceEntityMention.jetExtent.start()) continue;
            ArrayList arrayList2 = RelationTagger.getConjuncts(aceEntityMention);
            ArrayList arrayList3 = RelationTagger.getConjuncts(aceEntityMention2);
            if (arrayList2.contains(aceEntityMention2)) continue;
            for (int i = 0; i < arrayList2.size(); ++i) {
                block2: for (int j = 0; j < arrayList3.size(); ++j) {
                    Object object;
                    AceEntityMention aceEntityMention3 = (AceEntityMention)arrayList2.get(i);
                    AceEntityMention aceEntityMention4 = (AceEntityMention)arrayList3.get(j);
                    if (aceEntityMention3 == aceEntityMention && aceEntityMention4 == aceEntityMention2) continue;
                    if (relationTrace) {
                        System.out.println("Trying to add relation between " + aceEntityMention3.text + " and " + aceEntityMention4.text);
                    }
                    for (AceRelation aceRelation2 : relationList) {
                        object = (AceRelationMention)aceRelation2.mentions.get(0);
                        if (aceEntityMention3 != ((AceRelationMention)object).arg1 || aceEntityMention4 != ((AceRelationMention)object).arg2) continue;
                        continue block2;
                    }
                    AceRelationMention aceRelationMention2 = new AceRelationMention("", aceEntityMention3, aceEntityMention4, doc);
                    String string = aceRelation.type;
                    object = aceRelation.subtype;
                    AceRelation aceRelation3 = new AceRelation("", string, (String)object, "", aceEntityMention3.entity, aceEntityMention4.entity);
                    aceRelation3.addMention(aceRelationMention2);
                    relationList.add(aceRelation3);
                    if (!relationTrace) continue;
                    System.out.println("Adding relation between " + aceEntityMention3.text + " and " + aceEntityMention4.text);
                }
            }
        }
    }

    private static void readACErelations(String string, String string2) {
        aceDoc = new AceDocument(string, string2);
        RelationTagger.findEntityMentions(aceDoc);
        RelationTagger.findRelationMentions(aceDoc);
    }

    static void findEntityMentions(AceDocument aceDocument) {
        RelationTagger.resetMentions();
        ArrayList<AceEntity> arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = arrayList.get(i);
            String string = aceEntity.type;
            String string2 = aceEntity.subtype;
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                RelationTagger.addMention(aceEntityMention);
            }
        }
    }

    static void resetMentions() {
        mentionHeadMap = new HashMap();
        mentionStartMap = new HashMap();
        mentionIDMap = new HashMap();
        mentionSet = new TreeSet<AceEntityMention>();
        allMentionSet = new TreeSet();
    }

    static void addMention(AceEntityMention aceEntityMention) {
        mentionSet.add(aceEntityMention);
        allMentionSet.add(aceEntityMention);
        mentionHeadMap.put(new Integer(aceEntityMention.jetHead.start()), aceEntityMention);
        mentionStartMap.put(new Integer(aceEntityMention.jetExtent.start()), aceEntityMention);
        mentionIDMap.put(aceEntityMention.id, aceEntityMention);
    }

    private static void findRelationMentions(AceDocument aceDocument) {
        relMentionList = new ArrayList();
        ArrayList<AceRelation> arrayList = aceDocument.relations;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceRelation aceRelation = arrayList.get(i);
            String string = aceRelation.relClass;
            if (string.equals("IMPLICIT")) continue;
            relMentionList.addAll(aceRelation.mentions);
        }
    }

    private static void predictRelation(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        boolean bl = RelationTagger.inSameBaseNP(aceEntityMention.head, aceEntityMention2.head);
        MaxEntModel maxEntModel = bl ? model0 : model2;
        MaxEntModel maxEntModel2 = bl ? model1 : model3;
        Datum datum = RelationTagger.relationFeatures(aceEntityMention, aceEntityMention2);
        double d = maxEntModel.prob(datum, "t");
        double d2 = maxEntModel.prob(datum, "nil");
        String string = maxEntModel.bestOutcome(datum);
        if (d / (d + d2) < threshold) {
            return;
        }
        if (!RelationTagger.blockingTest(aceEntityMention, aceEntityMention2)) {
            return;
        }
        if (!RelationTagger.blockingTest(aceEntityMention2, aceEntityMention)) {
            return;
        }
        string = maxEntModel2.bestOutcome(datum);
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            System.err.println("Invalid outcome in predictRelation:" + string);
            return;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string3.endsWith("-1")) {
            if (!RelationTagger.satisfiesTypeConstraint(string2, string3 = string3.replace("-1", ""), "arg1", aceEntityMention2.entity.type)) {
                return;
            }
            if (!RelationTagger.satisfiesTypeConstraint(string2, string3, "arg2", aceEntityMention.entity.type)) {
                return;
            }
            AceRelationMention aceRelationMention = new AceRelationMention("", aceEntityMention2, aceEntityMention, doc);
            AceRelation aceRelation = new AceRelation("", string2, string3, "", aceEntityMention2.entity, aceEntityMention.entity);
            aceRelation.addMention(aceRelationMention);
            relationList.add(aceRelation);
        } else {
            if (!RelationTagger.satisfiesTypeConstraint(string2, string3, "arg1", aceEntityMention.entity.type)) {
                return;
            }
            if (!RelationTagger.satisfiesTypeConstraint(string2, string3, "arg2", aceEntityMention2.entity.type)) {
                return;
            }
            AceRelationMention aceRelationMention = new AceRelationMention("", aceEntityMention, aceEntityMention2, doc);
            AceRelation aceRelation = new AceRelation("", string2, string3, "", aceEntityMention.entity, aceEntityMention2.entity);
            aceRelation.addMention(aceRelationMention);
            relationList.add(aceRelation);
        }
    }

    private static void relationCoref(AceDocument aceDocument) {
        ArrayList<AceRelation> arrayList = new ArrayList<AceRelation>();
        System.out.println("RelationCoref: " + relationList.size() + " relation mentions");
        block0: for (AceRelation aceRelation : relationList) {
            AceRelationMention aceRelationMention = (AceRelationMention)aceRelation.mentions.get(0);
            String string = aceRelation.arg1.id;
            String string2 = aceRelation.arg2.id;
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                AceRelation aceRelation2 = (AceRelation)object.next();
                if (string != aceRelation2.arg1.id || string2 != aceRelation2.arg2.id || !mergeMultipleRelations && (!aceRelation.type.equals(aceRelation2.type) || !aceRelation.subtype.equals(aceRelation2.subtype))) continue;
                int n = aceRelation2.mentions.size() + 1;
                aceRelationMention.id = aceRelation2.id + "-" + n;
                aceRelation2.addMention(aceRelationMention);
                continue block0;
            }
            aceRelation.id = object = docName + "-R" + (arrayList.size() + 1);
            aceRelationMention.id = (String)object + "-1";
            arrayList.add(aceRelation);
            aceDocument.addRelation(aceRelation);
        }
        System.out.println("RelationCoref: " + arrayList.size() + " relations");
    }

    private static void removeRedundantMentions(AceDocument aceDocument) {
        ArrayList<AceRelation> arrayList = aceDocument.relations;
        for (AceRelation aceRelation : arrayList) {
            ArrayList arrayList2 = aceRelation.mentions;
            HashSet hashSet = new HashSet();
            for (int i = 0; i < arrayList2.size() - 1; ++i) {
                for (int j = i + 1; j < arrayList2.size(); ++j) {
                    if (RelationTagger.widerMention((AceRelationMention)arrayList2.get(i), (AceRelationMention)arrayList2.get(j))) {
                        hashSet.add(arrayList2.get(i));
                        continue;
                    }
                    if (!RelationTagger.widerMention((AceRelationMention)arrayList2.get(j), (AceRelationMention)arrayList2.get(i))) continue;
                    hashSet.add(arrayList2.get(j));
                }
            }
            if (hashSet.isEmpty()) continue;
            for (AceRelationMention aceRelationMention : hashSet) {
                arrayList2.remove(aceRelationMention);
            }
            aceRelation.mentions = arrayList2;
        }
    }

    private static boolean widerMention(AceRelationMention aceRelationMention, AceRelationMention aceRelationMention2) {
        int n = aceRelationMention.arg1.head.end();
        int n2 = aceRelationMention.arg2.head.end();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = aceRelationMention2.arg1.head.end();
        int n6 = aceRelationMention2.arg2.head.end();
        int n7 = Math.min(n5, n6);
        int n8 = Math.max(n5, n6);
        return n3 <= n7 && n4 >= n8;
    }

    static boolean blockingTest(AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2) {
        Span span = aceEntityMention.jetHead;
        Span span2 = aceEntityMention2.jetHead;
        Annotation annotation = RelationTagger.containingBaseNP(span);
        if (annotation == null) {
            return true;
        }
        Span span3 = annotation.span();
        if (span.end() == span3.end()) {
            return true;
        }
        if (conjunctf.get(aceEntityMention) != null) {
            return true;
        }
        if (mentionStartMap.get(span3.start()) == null) {
            return true;
        }
        boolean bl = span2.within(span3);
        if (relationTrace && !bl) {
            System.out.println("Relation blocking test fails for " + aceEntityMention.text + " - " + aceEntityMention2.text);
        }
        return bl;
    }

    static Annotation containingBaseNP(Span span) {
        Annotation annotation;
        int n = span.start();
        Annotation annotation2 = null;
        block0: while (true) {
            Object object;
            Vector<Annotation> vector;
            if ((vector = doc.annotationsAt(n, "constit")) != null) {
                object = vector.iterator();
                while (object.hasNext()) {
                    annotation = (Annotation)object.next();
                    if (!RelationTagger.isBaseNp(annotation)) continue;
                    break block0;
                }
            }
            if ((object = doc.tokenEndingAt(n)) == null) {
                return null;
            }
            n = ((Annotation)object).start();
        }
        annotation2 = annotation;
        if (annotation2.end() >= span.end()) {
            return annotation2;
        }
        return null;
    }

    static boolean isBaseNp(Annotation annotation) {
        if (annotation.get("cat") != "np") {
            return false;
        }
        Annotation annotation2 = (Annotation)annotation.get("headC");
        return annotation2 != null && annotation2.get("cat") != "np";
    }

    static boolean inSameBaseNP(Span span, Span span2) {
        Annotation annotation = RelationTagger.containingBaseNP(span);
        if (annotation == null) {
            return false;
        }
        return span2.within(annotation.span());
    }

    static {
        relations = new String[]{"of", "poss", "nameMod"};
        conjunctf = new HashMap();
        conjunctb = new HashMap();
        model0 = null;
        model1 = null;
        model2 = null;
        model3 = null;
        typeConstraints = null;
        relatives = new String[]{"family", "parent", "parents", "father", "dad", "mother", "mom", "sibling", "brother", "brothers", "sister", "sisters", "sis", "spouse", "husband", "hubby", "wife", "child", "children", "baby", "daughter", "daughters", "son", "sons", "widow", "widower", "grandparent", "grandparents", "grandfather", "grandfathers", "grandmother", "grandmothers", "grandchild", "grandchildren", "grandson", "grandsons", "granddaughter", "granddaughters", "stepparent", "stepparents", "stepfather", "stepmother", "stepchild", "stepchildren", "stepson", "stepsons", "stepdaughter", "stepdaughters", "father-in-law", "mother-in-law", "brother-in-law", "sister-in-law", "daughter-in-law", "son-in-law", "cousin", "cousins", "nephew", "nephews", "uncle", "uncles", "aunt", "aunts", "niece", "nieces"};
        threshold = 0.25;
        mergeMultipleRelations = false;
    }
}

