/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEvent;
import AceJet.AceEventAnchor;
import AceJet.AceEventArgument;
import AceJet.AceEventArgumentValue;
import AceJet.AceEventMention;
import AceJet.AceEventMentionArgument;
import AceJet.AceMention;
import AceJet.ChunkPath;
import AceJet.Datum;
import AceJet.EventPattern;
import AceJet.EventSyntacticPattern;
import AceJet.PatternEvaluation;
import Jet.Control;
import Jet.JetTest;
import Jet.Parser.SyntacticRelationSet;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTagger {
    static boolean useArgumentModel = true;
    static double EVENT_PROBABILITY_THRESHOLD = 0.8;
    static double MIN_ARG_PROBABILITY = 0.1;
    static double ARGUMENT_PROBABILITY_THRESHOLD = 0.35;
    static double COREF_CONFIDENCE = 0.1;
    static double COREF_THRESHOLD = 0.4;
    TreeMap<String, List<EventPattern>> anchorMap;
    PrintStream eventFeatureWriter;
    PrintStream argFeatureWriter;
    PrintStream roleFeatureWriter;
    PrintStream corefFeatureWriter;
    static GISModel eventModel;
    static GISModel argModel;
    static GISModel roleModel;
    static GISModel corefModel;
    static String triplesSuffix;
    static boolean usePA;
    static boolean useParser;
    String[] patternTypeList = new String[]{"CHUNK", "SYNTAX", "PA"};
    private static boolean evalTrace;
    private static int eventWeight;
    AceEventMention correctEventMention = null;
    private static double CONFIDENT_ARG;
    EventPattern patternMatched;
    static String docDir;
    static String modelDir;
    static String outputDir;
    static String glarfDir;

    public EventTagger() {
        this.anchorMap = new TreeMap();
    }

    public void acquirePatterns(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(glarfDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        ArrayList<AceEvent> arrayList = aceDocument.events;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEvent aceEvent = arrayList.get(i);
            ArrayList<AceEventMention> arrayList2 = aceEvent.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMention aceEventMention = arrayList2.get(j);
                System.out.println("\nProcessing event mention " + aceEventMention.id + " = " + aceEventMention.text);
                Span span = aceEventMention.anchorJetExtent;
                String string2 = EventPattern.normalizedAnchor(span, aceEventMention.anchorText, document, syntacticRelationSet);
                for (String string3 : this.patternTypeList) {
                    EventPattern eventPattern = new EventPattern(string3, document, syntacticRelationSet, aceEvent, aceEventMention);
                    if (eventPattern.empty()) continue;
                    System.out.println(string3 + " pattern = " + eventPattern);
                    this.addPattern(string2, eventPattern);
                    AceEvent aceEvent2 = eventPattern.match(span, string2, document, syntacticRelationSet, aceDocument);
                    if (aceEvent2 != null) continue;
                    System.err.println("**** match failed ****");
                }
                this.trainArgClassifier(aceEvent, aceEventMention, document, aceDocument, syntacticRelationSet);
            }
        }
    }

    private void addPattern(String string, EventPattern eventPattern) {
        String string2;
        List<EventPattern> list = this.anchorMap.get(string);
        if (list == null) {
            list = new ArrayList<EventPattern>();
            this.anchorMap.put(string, list);
        }
        if (!list.contains(eventPattern)) {
            list.add(eventPattern);
        }
        if ((string2 = (String)SyntacticRelationSet.nomVmap.get(string)) != null) {
            EventPattern eventPattern2 = new EventPattern(eventPattern);
            eventPattern2.anchor = string2;
            eventPattern2.paths = null;
            list = this.anchorMap.get(string2);
            if (list == null) {
                list = new ArrayList<EventPattern>();
                this.anchorMap.put(string2, list);
            }
            if (!list.contains(eventPattern2)) {
                list.add(eventPattern2);
            }
        }
    }

    private void addBasicPattern(String string, EventPattern eventPattern) {
        List<EventPattern> list = this.anchorMap.get(string);
        if (list == null) {
            list = new ArrayList<EventPattern>();
            this.anchorMap.put(string, list);
        }
        if (!list.contains(eventPattern)) {
            list.add(eventPattern);
        }
    }

    private void trainArgClassifier(AceEvent aceEvent, AceEventMention aceEventMention, Document document, AceDocument aceDocument, SyntacticRelationSet syntacticRelationSet) {
        Span span = aceEventMention.anchorJetExtent;
        String string = aceEventMention.anchorText;
        String string2 = EventPattern.normalizedAnchor(span, string, document, syntacticRelationSet);
        AceEventAnchor aceEventAnchor = new AceEventAnchor(span, span, string, document);
        Annotation annotation = this.findContainingSentence(document, span);
        if (annotation == null) {
            return;
        }
        Span span2 = annotation.span();
        ArrayList<AceMention> arrayList = aceDocument.getAllMentions();
        for (int i = 0; i < arrayList.size(); ++i) {
            AceMention aceMention = arrayList.get(i);
            if (!aceMention.jetExtent.within(span2)) continue;
            ArrayList<AceEventMentionArgument> arrayList2 = aceEventMention.arguments;
            String string3 = "noArg";
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMentionArgument aceEventMentionArgument = arrayList2.get(j);
                if (!aceEventMentionArgument.value.equals(aceMention)) continue;
                string3 = aceEventMentionArgument.role;
                break;
            }
            Datum datum = this.argumentFeatures(document, string2, aceEvent, aceMention, aceEventAnchor, syntacticRelationSet);
            if (string3 == "noArg") {
                datum.setOutcome("noArg");
                this.argFeatureWriter.println(datum.toString());
                continue;
            }
            datum.setOutcome("arg");
            this.argFeatureWriter.println(datum.toString());
            datum.setOutcome(string3);
            this.roleFeatureWriter.println(datum.toString());
        }
    }

    private Datum argumentFeatures(Document document, String string, AceEvent aceEvent, AceMention aceMention, AceMention aceMention2, SyntacticRelationSet syntacticRelationSet) {
        ChunkPath chunkPath;
        String string2;
        if (aceMention2.getJetHead().start() < aceMention.getJetHead().start()) {
            string2 = "follow";
            chunkPath = new ChunkPath(document, aceMention2, aceMention);
        } else {
            string2 = "precede";
            chunkPath = new ChunkPath(document, aceMention, aceMention2);
        }
        String string3 = EventSyntacticPattern.buildSyntacticPath(aceMention2.getJetHead().start(), aceMention.getJetHead().start(), syntacticRelationSet);
        Datum datum = new Datum();
        datum.addFV("anchor", string);
        datum.addFV("evType", aceEvent.type);
        datum.addFV("menType", aceMention.getType());
        String string4 = Resolve.normalizeName(aceMention.getHeadText()).replace(' ', '_');
        datum.addFV("arg", string4);
        datum.addFV("evTypeArg", aceEvent.subtype + ":" + string4);
        int n = aceMention.jetExtent.start();
        Annotation annotation = document.tokenEndingAt(n);
        if (annotation != null) {
            datum.addFV("prevToken", document.text(annotation).trim());
            datum.addFV("prevTokenAndType", aceEvent.type + "_" + document.text(annotation).trim());
        }
        if (chunkPath == null || chunkPath.toString() == null) {
            datum.addFV("noChunkPath", null);
        } else {
            String string5 = chunkPath.toString().replace(' ', '_');
            datum.addFV("chunkPath", string2 + "_" + string5);
            datum.addFV("chunkPathAndType", aceEvent.type + "_" + string2 + "_" + string5);
            datum.addFV("dist", Integer.toString(chunkPath.size()));
        }
        if (string3 == null) {
            datum.addF("noSynPath");
        } else {
            datum.addFV("synPath", string3);
            datum.addFV("synPathEvType", aceEvent.type + "_" + string3);
            datum.addFV("synPathTypes", aceEvent.type + "_" + aceMention.getType() + "_" + string3);
        }
        return datum;
    }

    private Annotation findContainingSentence(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("sentence");
        if (vector == null) {
            System.err.println("findContainingSentence:  no sentences found");
            return null;
        }
        Annotation annotation = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation2 = vector.get(i);
            if (!span.within(annotation2.span())) continue;
            annotation = annotation2;
            break;
        }
        if (annotation == null) {
            System.err.println("findContainingSentence:  can't find sentence with span");
            return null;
        }
        return annotation;
    }

    static GISModel loadClassifierModel(String string) {
        try {
            File file = new File(string);
            GISModel gISModel = (GISModel)new SuffixSensitiveGISModelReader(file).getModel();
            System.err.println("GIS model " + file.getName() + " loaded.");
            return gISModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private void collectArguments(AceEvent aceEvent, AceEventMention aceEventMention, Document document, AceDocument aceDocument, SyntacticRelationSet syntacticRelationSet) {
        Object object;
        Span span = aceEventMention.anchorJetExtent;
        String string = aceEventMention.anchorText;
        String string2 = EventPattern.normalizedAnchor(span, string, document, syntacticRelationSet);
        AceEventAnchor aceEventAnchor = new AceEventAnchor(span, aceEventMention.anchorJetExtent, string, document);
        Set<String> set = this.rolesFilledInEvent(aceEvent);
        Annotation annotation = this.findContainingSentence(document, span);
        if (annotation == null) {
            return;
        }
        Span span2 = annotation.span();
        HashSet<AceEventArgumentValue> hashSet = this.argumentValues(aceEvent);
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        ArrayList<AceMention> arrayList = aceDocument.getAllMentions();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object2 = arrayList.get(i);
            if (!((AceMention)object2).jetExtent.within(span2) || ((AceMention)object2).getJetHead().within(span)) continue;
            object = this.argumentFeatures(document, string2, aceEvent, (AceMention)object2, aceEventAnchor, syntacticRelationSet);
            double d = argModel.eval(((Datum)object).toArray())[argModel.getIndex("arg")];
            String string3 = roleModel.getBestOutcome(roleModel.eval(((Datum)object).toArray())).intern();
            double d2 = roleModel.eval(((Datum)object).toArray())[roleModel.getIndex(string3)];
            if (set.contains(string3) || !AceEventArgument.isValid(aceEvent.subtype, string3, (AceMention)object2) || !(d > MIN_ARG_PROBABILITY) || hashMap.get(string3) != null && !(d > (Double)hashMap.get(string3))) continue;
            hashMap.put(string3, d);
            hashMap3.put(string3, d2);
            hashMap2.put(string3, object2);
        }
        for (Object object2 : hashMap2.keySet()) {
            object = (AceMention)hashMap2.get(object2);
            AceEventArgumentValue aceEventArgumentValue = ((AceMention)object).getParent();
            if (hashSet.contains(aceEventArgumentValue)) continue;
            double d = (Double)hashMap.get(object2);
            AceEventMentionArgument aceEventMentionArgument = new AceEventMentionArgument((AceMention)object, (String)object2);
            aceEventMentionArgument.confidence = d;
            aceEventMentionArgument.roleConfidence = (Double)hashMap3.get(object2);
            aceEventMention.arguments.add(aceEventMentionArgument);
            AceEventArgument aceEventArgument = new AceEventArgument(aceEventArgumentValue, (String)object2);
            aceEventArgument.confidence = d;
            aceEvent.arguments.add(aceEventArgument);
            hashSet.add(aceEventArgumentValue);
        }
    }

    public void evaluatePatterns(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(glarfDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        ArrayList<AceEvent> arrayList = aceDocument.events;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            String string2 = (String)annotation.get("cat");
            if (string2 != "n" && string2 != "v" && string2 != "tv" && string2 != "ven" && string2 != "ving" && string2 != "adj") continue;
            String string3 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
            Span span = annotation.span();
            List<EventPattern> list = this.anchorMap.get(string3);
            if (list == null) continue;
            String string4 = null;
            for (int j = 0; j < list.size(); ++j) {
                AceEvent aceEvent;
                EventPattern eventPattern = list.get(j);
                AceEvent aceEvent2 = eventPattern.match(span, string3, document, syntacticRelationSet, aceDocument);
                if (aceEvent2 == null) continue;
                if (evalTrace) {
                    System.out.println("Evaluating " + eventPattern);
                }
                if (evalTrace) {
                    System.out.println("  for matched event " + aceEvent2);
                }
                AceEventMention aceEventMention = aceEvent2.mentions.get(0);
                if (evalTrace) {
                    System.out.println("  with extent " + document.text(aceEventMention.jetExtent));
                }
                if ((aceEvent = this.correctEvent(span, aceEvent2, arrayList)) != null) {
                    ArrayList<AceEventMentionArgument> arrayList2 = aceEventMention.arguments;
                    ArrayList<AceEventMentionArgument> arrayList3 = this.correctEventMention.arguments;
                    ArrayList<AceEventMentionArgument> arrayList4 = new ArrayList<AceEventMentionArgument>(arrayList2);
                    arrayList4.retainAll(arrayList3);
                    ArrayList<AceEventMentionArgument> arrayList5 = new ArrayList<AceEventMentionArgument>(arrayList2);
                    arrayList5.removeAll(arrayList3);
                    int n = eventWeight + arrayList4.size();
                    int n2 = arrayList5.size();
                    eventPattern.evaluation.recordSuccess(aceEventMention.arguments, n);
                    eventPattern.evaluation.recordFailure(aceEventMention.arguments, n2);
                    if (evalTrace) {
                        System.out.println("    a success");
                    }
                    string4 = aceEvent2.type + ":" + aceEvent2.subtype;
                    continue;
                }
                int n = eventWeight + aceEventMention.arguments.size();
                eventPattern.evaluation.recordFailure(aceEventMention.arguments, n);
                if (!evalTrace) continue;
                System.out.println("    a failure");
            }
        }
    }

    private AceEvent correctEvent(Span span, AceEvent aceEvent, ArrayList arrayList) {
        AceEventMention aceEventMention = aceEvent.mentions.get(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEvent aceEvent2 = (AceEvent)arrayList.get(i);
            ArrayList<AceEventMention> arrayList2 = aceEvent2.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventMention aceEventMention2 = arrayList2.get(j);
                Span span2 = aceEventMention2.jetExtent;
                if (!span.within(span2) || !aceEvent.type.equals(aceEvent2.type) || !aceEvent.subtype.equals(aceEvent2.subtype)) continue;
                this.correctEventMention = aceEventMention2;
                return aceEvent2;
            }
        }
        return null;
    }

    void trainEventModel(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(glarfDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        ArrayList<AceEvent> arrayList = aceDocument.events;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            String string2 = (String)annotation.get("cat");
            if (string2 != "n" && string2 != "v" && string2 != "tv" && string2 != "ven" && string2 != "ving" && string2 != "adj") continue;
            String string3 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
            Span span = annotation.span();
            List<EventPattern> list = this.anchorMap.get(string3);
            if (list == null) continue;
            CONFIDENT_ARG = 0.1;
            AceEvent aceEvent = this.eventAnchoredByConstituent(annotation, document, aceDocument, string, syntacticRelationSet, 0);
            if (aceEvent == null || this.confidentRoleCount(aceEvent, 0.999) != 0) continue;
            EventPattern eventPattern = this.patternMatched;
            Datum datum = this.eventFeatures(string3, aceEvent, eventPattern);
            boolean bl = this.correctEvent(span, aceEvent, arrayList) != null;
            datum.setOutcome(bl ? "event" : "noEvent");
            this.eventFeatureWriter.println(datum.toString());
        }
    }

    private Datum eventFeatures(String string, AceEvent aceEvent, EventPattern eventPattern) {
        Datum datum = new Datum();
        datum.addF(string);
        PatternEvaluation patternEvaluation = eventPattern.evaluation;
        int n = 5 * patternEvaluation.successCount / (patternEvaluation.successCount + patternEvaluation.failureCount);
        datum.addFV("successRate", Integer.toString(n));
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            String string2 = aceEventArgument.role;
            int n2 = (int)(aceEventArgument.confidence * 5.0);
            datum.addF(string2 + "+" + n2);
        }
        return datum;
    }

    void trainCorefModel(Document document, AceDocument aceDocument, String string) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(glarfDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        ArrayList<AceEvent> arrayList = aceDocument.events;
        ArrayList<AceEvent> arrayList2 = new ArrayList<AceEvent>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 1;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            AceEvent aceEvent;
            Annotation annotation = vector.get(i);
            String string2 = (String)annotation.get("cat");
            if (string2 != "n" && string2 != "v" && string2 != "tv" && string2 != "ven" && string2 != "ving" && string2 != "adj") continue;
            String string3 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
            Span span = annotation.span();
            AceEvent aceEvent2 = this.eventAnchoredByConstituent(annotation, document, aceDocument, string, syntacticRelationSet, n);
            if ((aceEvent2 = this.pruneEvent(aceEvent2, annotation, document, syntacticRelationSet)) == null || (aceEvent = this.correctEvent(span, aceEvent2, arrayList)) == null) continue;
            String string4 = aceEvent.id;
            Integer n2 = (Integer)hashMap.get(string4);
            int n3 = n2 == null ? -1 : n2;
            for (int j = 0; j < arrayList2.size(); ++j) {
                object = (AceEvent)arrayList2.get(j);
                if (!((AceEvent)object).subtype.equals(aceEvent2.subtype)) continue;
                Datum datum = this.corefFeatures((AceEvent)object, aceEvent2, string3);
                datum.setOutcome(j == n3 ? "merge" : "dontMerge");
                this.corefFeatureWriter.println(datum.toString());
            }
            if (n3 >= 0) {
                AceEvent aceEvent3 = (AceEvent)arrayList2.get(n3);
                aceEvent3.arguments = this.mergeArguments(aceEvent2.arguments, aceEvent3.arguments);
                object = aceEvent2.mentions.get(0);
                aceEvent3.addMention((AceEventMention)object);
                ((AceEventMention)object).setId(aceEvent3.id + "-" + aceEvent3.mentions.size());
                continue;
            }
            arrayList2.add(aceEvent2);
            hashMap.put(string4, new Integer(arrayList2.size() - 1));
            ++n;
        }
    }

    private Datum corefFeatures(AceEvent aceEvent, AceEvent aceEvent2, String string) {
        Datum datum = new Datum();
        datum.addFV("subtype", aceEvent2.subtype);
        datum.addFV("anchor", string);
        if (string.endsWith("/n")) {
            datum.addF("nomAnchor");
        }
        AceEventMention aceEventMention = aceEvent.mentions.get(aceEvent.mentions.size() - 1);
        int n = aceEventMention.anchorExtent.start();
        AceEventMention aceEventMention2 = aceEvent2.mentions.get(aceEvent2.mentions.size() - 1);
        int n2 = aceEventMention2.anchorExtent.start();
        int n3 = n2 - n;
        datum.addFV("distance", Integer.toString(Math.min(n3 / 100, 9)));
        if (aceEventMention2.anchorText.equals(aceEventMention.anchorText)) {
            datum.addF("anchorMatch");
        }
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        ArrayList<AceEventArgument> arrayList2 = aceEvent2.arguments;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            if (aceEventArgument.confidence < COREF_CONFIDENCE) continue;
            String string2 = aceEventArgument.role;
            String string3 = aceEventArgument.value.id;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventArgument aceEventArgument2 = arrayList2.get(j);
                if (aceEventArgument2.confidence < COREF_CONFIDENCE) continue;
                String string4 = aceEventArgument2.role;
                String string5 = aceEventArgument2.value.id;
                int n4 = (int)(Math.min(aceEventArgument.confidence, aceEventArgument2.confidence) * 5.0);
                if (!string2.equals(string4)) continue;
                if (string3.equals(string5)) {
                    datum.addFV("overlap", string2 + ":" + n4);
                    continue;
                }
                datum.addFV("conflict", string2 + ":" + n4);
            }
        }
        return datum;
    }

    public void tag(Document document, AceDocument aceDocument, String string, String string2) {
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        if (usePA) {
            syntacticRelationSet.readRelations(glarfDir + string + triplesSuffix);
        } else {
            syntacticRelationSet.addRelations(document);
        }
        int n = 1;
        Vector<Annotation> vector = document.annotationsOfType("constit");
        HashSet<Span> hashSet = new HashSet<Span>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Span span;
                Annotation annotation = vector.get(i);
                String string3 = (String)annotation.get("cat");
                if (string3 != "n" && string3 != "v" && string3 != "tv" && string3 != "ven" && string3 != "ving" && string3 != "adj" || hashSet.contains(span = annotation.span())) continue;
                AceEvent aceEvent = this.eventAnchoredByConstituent(annotation, document, aceDocument, string2, syntacticRelationSet, n);
                if ((aceEvent = this.pruneEvent(aceEvent, annotation, document, syntacticRelationSet)) == null) continue;
                aceDocument.addEvent(aceEvent);
                ++n;
                hashSet.add(span);
            }
        }
        this.eventCoref(aceDocument, document, syntacticRelationSet);
    }

    AceEvent eventAnchoredByConstituent(Annotation annotation, Document document, AceDocument aceDocument, String string, SyntacticRelationSet syntacticRelationSet, int n) {
        String string2 = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
        Span span = annotation.span();
        List<EventPattern> list = this.anchorMap.get(string2);
        if (list == null) {
            return null;
        }
        AceEvent aceEvent = this.matchPatternSet(list, span, string2, document, syntacticRelationSet, aceDocument);
        if (aceEvent == null) {
            return null;
        }
        Annotation annotation2 = EventPattern.containingSentence(document, span);
        int n2 = string.lastIndexOf(47);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        String string3 = string + "-EV" + n;
        aceEvent.setId(string3);
        AceEventMention aceEventMention = aceEvent.mentions.get(0);
        aceEventMention.setId(string3 + "-1");
        if (useArgumentModel) {
            this.collectArguments(aceEvent, aceEventMention, document, aceDocument, syntacticRelationSet);
        }
        if (this.confidentRoleCount(aceEvent, CONFIDENT_ARG) > 0) {
            return aceEvent;
        }
        return null;
    }

    AceEvent pruneEvent(AceEvent aceEvent, Annotation annotation, Document document, SyntacticRelationSet syntacticRelationSet) {
        Object object;
        if (aceEvent == null) {
            return null;
        }
        String string = EventPattern.normalizedAnchor(annotation, document, syntacticRelationSet);
        EventPattern eventPattern = this.patternMatched;
        Datum datum = this.eventFeatures(string, aceEvent, eventPattern);
        double d = eventModel.eval(datum.toArray())[eventModel.getIndex("event")];
        AceEventMention aceEventMention = aceEvent.mentions.get(0);
        aceEventMention.confidence = d;
        if (this.confidentRoleCount(aceEvent, 0.999) != 0) {
            return aceEvent;
        }
        if (d < EVENT_PROBABILITY_THRESHOLD) {
            return null;
        }
        ArrayList<Object> arrayList = aceEvent.arguments;
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(((AceEventArgument)object).confidence * d < ARGUMENT_PROBABILITY_THRESHOLD)) continue;
            iterator.remove();
        }
        arrayList = aceEventMention.arguments;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (AceEventMentionArgument)iterator.next();
            if (!(((AceEventMentionArgument)object).confidence * d < ARGUMENT_PROBABILITY_THRESHOLD)) continue;
            iterator.remove();
        }
        return aceEvent;
    }

    AceEvent matchPatternSet(List list, Span span, String string, Document document, SyntacticRelationSet syntacticRelationSet, AceDocument aceDocument) {
        this.patternMatched = null;
        AceEvent aceEvent = null;
        EventPattern eventPattern = null;
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            EventPattern eventPattern2 = (EventPattern)list.get(i);
            AceEvent aceEvent2 = eventPattern2.match(span, string, document, syntacticRelationSet, aceDocument);
            if (aceEvent2 == null || eventPattern2.evaluation.test(aceEvent2.arguments) <= 0) continue;
            int n2 = eventPattern2.getMatchScore() + eventPattern2.evaluation.test(aceEvent2.arguments);
            if (eventPattern2.patternType != null && eventPattern2.patternType.equals("SYNTAX")) {
                n2 += 50;
            }
            if (aceEvent2.arguments.size() < 0 || n2 <= n) continue;
            n = n2;
            aceEvent = aceEvent2;
            eventPattern = eventPattern2;
        }
        this.patternMatched = eventPattern;
        return aceEvent;
    }

    private Set<String> rolesFilledInEvent(AceEvent aceEvent) {
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            hashSet.add(aceEventArgument.role);
        }
        return hashSet;
    }

    private int confidentRoleCount(AceEvent aceEvent, double d) {
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            if (!(aceEventArgument.confidence > d)) continue;
            ++n;
        }
        return n;
    }

    private HashSet<AceEventArgumentValue> argumentValues(AceEvent aceEvent) {
        ArrayList<AceEventArgument> arrayList = aceEvent.arguments;
        HashSet<AceEventArgumentValue> hashSet = new HashSet<AceEventArgumentValue>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList.get(i);
            hashSet.add(aceEventArgument.value);
        }
        return hashSet;
    }

    public void tag(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        boolean bl = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing file " + string2);
            String string3 = docDir + string2 + ".sgm";
            String string4 = docDir + string2 + ".apf.xml";
            String string5 = outputDir + string2 + ".apf";
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            externalDocument.stretchAll();
            Control.processDocument(externalDocument, null, false, 0);
            AceDocument aceDocument = new AceDocument(string3, string4);
            aceDocument.events.clear();
            this.tag(externalDocument, aceDocument, string2.replaceFirst(".sgm", ""), aceDocument.docID);
            aceDocument.write(new PrintWriter(new FileWriter(string5)), externalDocument);
        }
    }

    public void eventCoref(AceDocument aceDocument, Document document, SyntacticRelationSet syntacticRelationSet) {
        ArrayList<AceEvent> arrayList = aceDocument.events;
        System.out.println("eventCoref: " + arrayList.size() + " event mentions");
        ArrayList<AceEvent> arrayList2 = new ArrayList<AceEvent>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            AceEvent aceEvent = arrayList.get(i);
            int n = -1;
            double d = 0.0;
            for (int j = arrayList2.size() - 1; j >= 0; --j) {
                object = (AceEvent)arrayList2.get(j);
                if (!aceEvent.type.equals(((AceEvent)object).type) || !aceEvent.subtype.equals(((AceEvent)object).subtype)) continue;
                AceEventMention aceEventMention = aceEvent.mentions.get(0);
                String string = EventPattern.normalizedAnchor(aceEventMention.anchorExtent, aceEventMention.anchorText, document, syntacticRelationSet);
                Datum datum = this.corefFeatures((AceEvent)object, aceEvent, string);
                double d2 = corefModel.eval(datum.toArray())[corefModel.getIndex("merge")];
                if (!(d2 > COREF_THRESHOLD) || !(d2 > d)) continue;
                n = j;
                d = d2;
            }
            if (n >= 0) {
                AceEvent aceEvent2 = (AceEvent)arrayList2.get(n);
                aceEvent2.arguments = this.mergeArguments(aceEvent.arguments, aceEvent2.arguments);
                object = aceEvent.mentions.get(0);
                aceEvent2.addMention((AceEventMention)object);
                ((AceEventMention)object).setId(aceEvent2.id + "-" + aceEvent2.mentions.size());
                continue;
            }
            arrayList2.add(aceEvent);
        }
        aceDocument.events = arrayList2;
        System.out.println("eventCoref: " + arrayList.size() + " events");
    }

    private boolean compatibleArguments(ArrayList arrayList, ArrayList arrayList2) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEventArgument aceEventArgument = (AceEventArgument)arrayList.get(i);
            if (aceEventArgument.confidence < COREF_CONFIDENCE) continue;
            String string = aceEventArgument.role;
            String string2 = aceEventArgument.value.id;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEventArgument aceEventArgument2 = (AceEventArgument)arrayList2.get(j);
                if (aceEventArgument2.confidence < COREF_CONFIDENCE) continue;
                String string3 = aceEventArgument2.role;
                String string4 = aceEventArgument2.value.id;
                if (!string.equals(string3)) continue;
                if (string2.equals(string4)) {
                    bl = true;
                    continue;
                }
                return false;
            }
        }
        return bl;
    }

    private ArrayList<AceEventArgument> mergeArguments(ArrayList<AceEventArgument> arrayList, ArrayList<AceEventArgument> arrayList2) {
        ArrayList<AceEventArgument> arrayList3 = new ArrayList<AceEventArgument>(arrayList);
        block0: for (int i = 0; i < arrayList2.size(); ++i) {
            AceEventArgument aceEventArgument = arrayList2.get(i);
            String string = aceEventArgument.role;
            String string2 = aceEventArgument.value.id;
            for (int j = 0; j < arrayList.size(); ++j) {
                AceEventArgument aceEventArgument2 = arrayList.get(j);
                String string3 = aceEventArgument2.role;
                String string4 = aceEventArgument2.value.id;
                if (string3.equals(string) && string4.equals(string2)) continue block0;
            }
            arrayList3.add(aceEventArgument);
        }
        return arrayList3;
    }

    public void report(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        Set<String> set = this.anchorMap.keySet();
        for (String string2 : set) {
            printWriter.println("\n" + string2 + " ================================");
            List<EventPattern> list = this.anchorMap.get(string2);
            for (int i = 0; i < list.size(); ++i) {
                EventPattern eventPattern = list.get(i);
                printWriter.println(eventPattern.toString());
            }
        }
        printWriter.close();
    }

    public void save(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        Set<String> set = this.anchorMap.keySet();
        for (String string2 : set) {
            List<EventPattern> list = this.anchorMap.get(string2);
            for (int i = 0; i < list.size(); ++i) {
                EventPattern eventPattern = list.get(i);
                eventPattern.write(printWriter);
            }
        }
        printWriter.close();
    }

    public void load(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            EventPattern eventPattern = new EventPattern(bufferedReader);
            this.addBasicPattern(eventPattern.anchor, eventPattern);
            ++n;
            string2 = bufferedReader.readLine();
        }
        System.out.println(n + " patterns loaded");
    }

    public void loadAllModels(String string) throws IOException {
        eventModel = EventTagger.loadClassifierModel(string + "eventModel.log");
        argModel = EventTagger.loadClassifierModel(string + "argModel.log");
        roleModel = EventTagger.loadClassifierModel(string + "roleModel.log");
        corefModel = EventTagger.loadClassifierModel(string + "corefModel.log");
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting ACE event tagger.");
        if (stringArray.length != 5 && stringArray.length != 7) {
            System.out.println("EventTagger must take 5 or 7 arguments:");
            System.out.println("    properties filelist documentDir modelDir outputDir [glarfDir glarfSuffix]");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        docDir = stringArray[2];
        if (!docDir.endsWith("/")) {
            docDir = docDir + "/";
        }
        if (!(modelDir = stringArray[3]).endsWith("/")) {
            modelDir = modelDir + "/";
        }
        if (!(outputDir = stringArray[4]).endsWith("/")) {
            outputDir = outputDir + "/";
        }
        glarfDir = null;
        if (stringArray.length == 7) {
            glarfDir = stringArray[5];
            if (!glarfDir.endsWith("/")) {
                glarfDir = glarfDir + "/";
            }
            triplesSuffix = stringArray[6];
            usePA = true;
        }
        JetTest.initializeFromConfig(string);
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        AceDocument.ace2005 = true;
        Ace.writeEventConfidence = JetTest.getConfigFile("Ace.writeEventConfidence") != null;
        EVENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.eventProbabilityThreshold", EVENT_PROBABILITY_THRESHOLD);
        ARGUMENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.argumentProbabilityThreshold", ARGUMENT_PROBABILITY_THRESHOLD);
        EventTagger eventTagger = new EventTagger();
        eventTagger.load(modelDir + "eventPatterns.log");
        eventTagger.loadAllModels(modelDir);
        eventTagger.tag(string2);
    }

    static {
        usePA = false;
        evalTrace = false;
        eventWeight = 10;
        CONFIDENT_ARG = 0.2;
    }
}

