/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntityMention;
import AceJet.AceRelation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceRelationMention {
    public String id;
    public Span extent;
    public String text;
    public AceEntityMention arg1;
    public AceEntityMention arg2;
    public AceRelation relation;
    public double confidence = 1.0;

    public AceRelationMention(String string, AceEntityMention aceEntityMention, AceEntityMention aceEntityMention2, Document document) {
        this.id = string;
        this.arg1 = aceEntityMention;
        this.arg2 = aceEntityMention2;
        int n = Math.min(aceEntityMention.extent.start(), aceEntityMention2.extent.start());
        int n2 = Math.max(aceEntityMention.extent.end(), aceEntityMention2.extent.end());
        this.extent = new Span(n, n2);
        this.text = document.text(new Span(n, n2 + 1));
    }

    public AceRelationMention(Element element, AceDocument aceDocument, String string) {
        this.id = element.getAttribute("ID");
        NodeList nodeList = element.getElementsByTagName("extent");
        Element element2 = (Element)nodeList.item(0);
        this.extent = AceEntityMention.decodeCharseq(element2);
        this.text = string.substring(this.extent.start(), this.extent.end() + 1);
        if (AceDocument.ace2005) {
            NodeList nodeList2 = element.getElementsByTagName("relation_mention_argument");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                String string2 = element3.getAttribute("REFID");
                String string3 = element3.getAttribute("ROLE");
                if (string3.equals("Arg-1")) {
                    this.arg1 = aceDocument.findEntityMention(string2);
                    continue;
                }
                if (string3.equals("Arg-2")) {
                    this.arg2 = aceDocument.findEntityMention(string2);
                    continue;
                }
                if (AceRelation.timeRoles.contains(string3)) continue;
                System.err.println("*** invalid ROLE for relation mention");
            }
        } else {
            NodeList nodeList3 = element.getElementsByTagName("rel_mention_arg");
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                Element element4 = (Element)nodeList3.item(i);
                String string4 = element4.getAttribute(AceDocument.ace2004 ? "ENTITYMENTIONID" : "MENTIONID");
                String string5 = element4.getAttribute("ARGNUM");
                if (string5.equals("1")) {
                    this.arg1 = aceDocument.findEntityMention(string4);
                    continue;
                }
                if (string5.equals("2")) {
                    this.arg2 = aceDocument.findEntityMention(string4);
                    continue;
                }
                System.err.println("*** invalid ARGNUM for relation");
            }
        }
    }

    public void write(PrintWriter printWriter) {
        printWriter.print("      <relation_mention ID=\"" + this.id + "\"");
        if (!AceDocument.ace2005) {
            printWriter.print(" LDCLEXICALCONDITION=\"Formulaic\"");
        }
        if (Ace.writeEventConfidence) {
            printWriter.format(" p=\"%5.3f\"", this.confidence);
        }
        printWriter.println(">");
        printWriter.println("      <extent>");
        AceEntityMention.writeCharseq(printWriter, this.extent, this.text);
        printWriter.println("      </extent>");
        this.writeMentionArg(printWriter, 1, this.arg1);
        this.writeMentionArg(printWriter, 2, this.arg2);
        printWriter.println("      </relation_mention>");
    }

    private void writeMentionArg(PrintWriter printWriter, int n, AceEntityMention aceEntityMention) {
        if (AceDocument.ace2005) {
            printWriter.println("        <relation_mention_argument REFID=\"" + aceEntityMention.id + "\" ROLE=\"Arg-" + n + "\">");
        } else {
            String string = AceDocument.ace2004 ? "ENTITYMENTIONID" : "MENTIONID";
            printWriter.println("        <rel_mention_arg " + string + "=\"" + aceEntityMention.id + "\" ARGNUM=\"" + n + "\">");
        }
        printWriter.println("          <extent>");
        printWriter.print("            <charseq START=\"" + aceEntityMention.extent.start() + "\" END=\"" + aceEntityMention.extent.end() + "\">");
        printWriter.print(AceEntityMention.addXmlEscapes(aceEntityMention.text));
        printWriter.println("</charseq>");
        printWriter.println("          </extent>");
        if (AceDocument.ace2005) {
            printWriter.println("        </relation_mention_argument>");
        } else {
            printWriter.println("        </rel_mention_arg>");
        }
    }

    public String toString() {
        return this.relation.type + ":" + this.relation.subtype + "(" + this.arg1.text + ", " + this.arg2.text + ")";
    }
}

