/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.POSKey;
import net.didion.jwnl.util.cache.Cache;
import net.didion.jwnl.util.cache.LRUCache;
import net.didion.jwnl.util.factory.Param;

public class DefaultMorphologicalProcessor
implements MorphologicalProcessor {
    public static final String CACHE_CAPACITY = "cache_capacity";
    private static final String[][] NOUN_SUFFIXES = new String[][]{{"s", ""}, {"ses", "s"}, {"xes", "x"}, {"zes", "z"}, {"ches", "ch"}, {"shes", "sh"}};
    private static final String[][] VERB_SUFFIXES = new String[][]{{"s", ""}, {"es", "e"}, {"es", ""}, {"ed", "e"}, {"ed", ""}, {"ing", "e"}, {"ing", ""}};
    private static final String[][] ADJECTIVE_SUFFIXES = new String[][]{{"er", ""}, {"est", ""}, {"er", "e"}, {"est", "e"}};
    private static final Operation LOOKUP_EXCEPTIONS = new Operation(){

        public void performOperation(POS pOS, String string, BaseForm baseForm) throws JWNLException {
            this.findExceptions(pOS, string, baseForm);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() > 1) {
                String string2;
                String[] stringArray = new String[stringTokenizer.countTokens()];
                BaseForm baseForm2 = new BaseForm();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    string2 = stringTokenizer.nextToken();
                    this.findExceptions(pOS, string2, baseForm2);
                    if (baseForm2.hasMoreForms()) {
                        try {
                            stringBuffer.append(baseForm2.getNextForm());
                            stringBuffer.append(" ");
                        }
                        catch (Exception exception) {
                            stringBuffer.append(string2);
                            stringBuffer.append(" ");
                        }
                    } else {
                        stringBuffer.append(string2);
                        stringBuffer.append(" ");
                    }
                    ++n;
                }
                string2 = stringBuffer.toString().trim();
                IndexWord indexWord = Dictionary.getInstance().getIndexWord(pOS, string2);
                if (indexWord != null) {
                    baseForm.add(string2);
                }
            }
        }

        private void findExceptions(POS pOS, String string, BaseForm baseForm) throws JWNLException {
            Exc exc = Dictionary.getInstance().getException(pOS, string);
            if (exc != null) {
                String[] stringArray = exc.getExceptionArray();
                int n = 0;
                while (n < stringArray.length) {
                    baseForm.add(stringArray[n]);
                    ++n;
                }
            }
        }
    };
    private static final Operation DETACH_SUFFIXES = new Operation(){

        public void performOperation(POS pOS, String string, BaseForm baseForm) throws JWNLException {
            String[][] stringArray = null;
            if (pOS == POS.NOUN) {
                stringArray = NOUN_SUFFIXES;
            } else if (pOS == POS.VERB) {
                stringArray = VERB_SUFFIXES;
            } else if (pOS == POS.ADJECTIVE) {
                stringArray = ADJECTIVE_SUFFIXES;
            } else {
                return;
            }
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            List[] listArray = new List[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                listArray[n++] = this.getStemmedForms(stringTokenizer.nextToken(), stringArray);
            }
            int[] nArray = new int[listArray.length];
            int[] nArray2 = new int[listArray.length];
            n = 0;
            while (n < listArray.length) {
                nArray[n] = listArray[n].size() - 1;
                nArray2[n] = 0;
                ++n;
            }
            nArray2[nArray2.length - 1] = -1;
            do {
                IndexWord indexWord;
                n = listArray.length - 1;
                while (n >= 0) {
                    int n2 = n;
                    nArray2[n2] = nArray2[n2] + 1;
                    if (nArray2[n2] <= nArray[n]) break;
                    nArray2[n] = 0;
                    --n;
                }
                StringBuffer stringBuffer = new StringBuffer();
                n = 0;
                while (n < listArray.length) {
                    stringBuffer.append((String)listArray[n].get(nArray2[n]));
                    stringBuffer.append(" ");
                    ++n;
                }
                String string2 = stringBuffer.toString().trim();
                if (string2.equals(string) || (indexWord = Dictionary.getInstance().getIndexWord(pOS, string2)) == null) continue;
                baseForm.add(string2);
            } while (!Arrays.equals(nArray2, nArray));
        }

        private List getStemmedForms(String string, String[][] stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            int n = 0;
            while (n < stringArray.length) {
                if (string.endsWith(stringArray[n][0])) {
                    arrayList.add(string.substring(0, string.length() - stringArray[n][0].length()) + stringArray[n][1]);
                }
                ++n;
            }
            return arrayList;
        }
    };
    private static final Operation REMOVE_DELIMITERS = new Operation(){

        public void performOperation(POS pOS, String string, BaseForm baseForm) throws JWNLException {
            String string2;
            StringBuffer stringBuffer;
            StringTokenizer stringTokenizer;
            if (string.indexOf("-") >= 0) {
                stringTokenizer = new StringTokenizer(string, "-\t\n\r\f");
                stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append(" ");
                }
                string2 = stringBuffer.toString().trim();
                this.repeatSteps(pOS, string2, baseForm);
            } else {
                string2 = string;
            }
            if (string2.indexOf(" ") >= 0) {
                stringTokenizer = new StringTokenizer(string2, " ");
                stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                }
                this.repeatSteps(pOS, stringBuffer.toString(), baseForm);
            }
            stringTokenizer = new StringTokenizer(string2, ".,;:?/!&()'\"\\");
            stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append(" ");
            }
            String string3 = stringBuffer.toString().trim();
            if (string3 != string2) {
                this.repeatSteps(pOS, string3, baseForm);
                stringTokenizer = new StringTokenizer(string3, " ");
                StringBuffer stringBuffer2 = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer2.append(stringTokenizer.nextToken());
                }
                this.repeatSteps(pOS, stringBuffer2.toString(), baseForm);
            }
        }

        private void repeatSteps(POS pOS, String string, BaseForm baseForm) throws JWNLException {
            IndexWord indexWord = Dictionary.getInstance().getIndexWord(pOS, string);
            if (indexWord != null) {
                baseForm.add(string);
            }
            LOOKUP_EXCEPTIONS.performOperation(pOS, string, baseForm);
            DETACH_SUFFIXES.performOperation(pOS, string, baseForm);
        }
    };
    private static final Operation REMOVE_PREP_PHRASES = new Operation(){

        public void performOperation(POS pOS, String string, BaseForm baseForm) {
        }
    };
    private static final int DEFAULT_CACHE_CAPACITY = 1000;
    private Cache _baseFormCache = null;

    public DefaultMorphologicalProcessor() {
    }

    public DefaultMorphologicalProcessor(int n) {
        this._baseFormCache = new LRUCache(n);
    }

    public Object create(Map map) throws JWNLException {
        Param param = (Param)map.get(CACHE_CAPACITY);
        int n = param == null ? 1000 : new Integer(param.getValue());
        return new DefaultMorphologicalProcessor(n);
    }

    public IndexWord lookupBaseForm(POS pOS, String string) throws JWNLException {
        BaseForm baseForm = this.getCachedBaseForm(new POSKey(pOS, string));
        if (baseForm != null && baseForm.hasCurrentForm()) {
            return Dictionary.getInstance().getIndexWord(pOS, baseForm.getCurrentForm());
        }
        return this.lookupNextBaseForm(pOS, string, baseForm);
    }

    private void cacheBaseForm(POSKey pOSKey, BaseForm baseForm) {
        this._baseFormCache.put(pOSKey, baseForm);
    }

    private BaseForm getCachedBaseForm(POSKey pOSKey) {
        return (BaseForm)this._baseFormCache.get(pOSKey);
    }

    private IndexWord lookupNextBaseForm(POS pOS, String string, BaseForm baseForm) throws JWNLException {
        if (string.equals("") || string == null) {
            return null;
        }
        String string2 = null;
        if (baseForm == null) {
            POSKey pOSKey = new POSKey(pOS, string);
            baseForm = this.getCachedBaseForm(pOSKey);
            if (baseForm == null) {
                baseForm = new BaseForm();
                this.cacheBaseForm(pOSKey, baseForm);
            } else if (baseForm.hasMoreForms()) {
                string2 = baseForm.getNextForm();
            }
        }
        while (baseForm.hasNextOperation() && string2 == null) {
            baseForm.getNextOperation().performOperation(pOS, string, baseForm);
            if (!baseForm.hasMoreForms()) continue;
            string2 = baseForm.getNextForm();
            break;
        }
        return string2 == null ? null : Dictionary.getInstance().getIndexWord(pOS, string2);
    }

    public List lookupAllBaseForms(POS pOS, String string) throws JWNLException {
        BaseForm baseForm = this.getCachedBaseForm(new POSKey(pOS, string));
        if (baseForm == null) {
            return Collections.EMPTY_LIST;
        }
        int n = baseForm.getNextIndex();
        while (this.lookupNextBaseForm(pOS, string, baseForm) != null) {
        }
        baseForm.setNextIndex(n);
        return baseForm.getForms();
    }

    static /* synthetic */ Operation access$600() {
        return REMOVE_DELIMITERS;
    }

    static /* synthetic */ Operation access$700() {
        return REMOVE_PREP_PHRASES;
    }

    private static class BaseForm {
        private static final Operation[] operations = new Operation[]{DefaultMorphologicalProcessor.access$400(), DefaultMorphologicalProcessor.access$500(), DefaultMorphologicalProcessor.access$600(), DefaultMorphologicalProcessor.access$700()};
        private List _forms = new LinkedList();
        private int _nextOperation = 0;
        private int _nextIndex = 0;

        private BaseForm() {
        }

        public boolean hasMoreForms() {
            return this._nextIndex < this._forms.size();
        }

        public boolean hasCurrentForm() {
            return this._nextIndex - 1 >= 0;
        }

        public void add(String string) {
            this._forms.add(string);
        }

        public boolean hasNextOperation() {
            return this._nextOperation < operations.length;
        }

        public Operation getNextOperation() {
            if (this.hasNextOperation()) {
                return operations[this._nextOperation++];
            }
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_011");
        }

        public String getCurrentForm() {
            if (!this.hasCurrentForm()) {
                throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_012");
            }
            return this.getForm(this._nextIndex - 1);
        }

        public String getNextForm() {
            if (this._nextIndex >= this._forms.size()) {
                throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_013");
            }
            int n = this._nextIndex++;
            return this.getForm(n);
        }

        public int getNextIndex() {
            return this._nextIndex;
        }

        public void setNextIndex(int n) {
            if (n < this._forms.size()) {
                this._nextIndex = n;
            }
        }

        public String getForm(int n) {
            return (String)this._forms.get(n);
        }

        public List getForms() {
            return this._forms;
        }

        public int numForms() {
            return this._forms.size();
        }
    }

    private static interface Operation {
        public void performOperation(POS var1, String var2, BaseForm var3) throws JWNLException;
    }
}

