/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.io.GISModelWriter;
import opennlp.model.AbstractModel;

public class BinaryGISModelWriter
extends GISModelWriter {
    DataOutputStream output;

    public BinaryGISModelWriter(AbstractModel abstractModel, File file) throws IOException {
        super(abstractModel);
        this.output = file.getName().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file))) : new DataOutputStream(new FileOutputStream(file));
    }

    public BinaryGISModelWriter(AbstractModel abstractModel, DataOutputStream dataOutputStream) {
        super(abstractModel);
        this.output = dataOutputStream;
    }

    public void writeUTF(String string) throws IOException {
        this.output.writeUTF(string);
    }

    public void writeInt(int n) throws IOException {
        this.output.writeInt(n);
    }

    public void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

