function [output input_dx] = tanhAct(input)
% Hyperbolic tangent non-linearity.
% input is the input value (it can also be a vector or a matrix).
% output is the output value
% input_dx [optional] are the derivatives of the output w.r.t. input
%
% 1 June 2012
% Marc'Aurelio Ranzato
% ranzato@google.com

output = tanh(input);
if nargout > 1
    input_dx = (1-output) .* (1+output);
end
