varying vec3 normal,lightDir;

uniform vec4 c;

void main()
{
    vec4 color = gl_LightModel.ambient * gl_FrontMaterial.ambient;
    
    /* compute the dot product between normal and normalized lightdir */
    float NdotL = max(dot(normalize(normal),normalize(lightDir)),0.0);
	
    if (NdotL > 0.0)
        color += (gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse * NdotL);
	
    gl_FragColor = color;
}
