module memory/fixedSizeMemory_H [Addr, Data]

open memory/fixedSizeMemory [Addr, Data] as memory

sig FixMemory_H extends memory/FixMemory {
	unwritten: set Addr
}

pred init [m: FixMemory_H] {
	memory/init [m]
	m.unwritten = Addr
}

pred read [m: FixMemory_H, a: Addr, d: Data] {
	memory/read [m, a, d]
}

pred write [m, m': FixMemory_H, a: Addr, d: Data] {
	memory/write [m, m', a, d]
	m'.unwritten = m.unwritten - a
}
