public final class IntKey implements Key {
   private int x;
   
   public IntKey(int k) { x = k; }
    
   public int compareTo(Object o){
      int y = ((IntKey) o).value();
      return x == y ? 0 : (x < y ? -1 : 1); 
   }
    
   public /*@ pure @*/ boolean equals(/*@ nullable @*/ Object o){
      if (o == null || !(o instanceof IntKey))
	 return false;
      int y = ((IntKey) o).value();
      return y == x;
   }
    
   public Object clone () {
      return new IntKey(this.value());
   }
    
   public /*@ pure @*/ int value() { return x; }
    
   public String toString(){
      return new Integer(x).toString();
   }
}
