public class FilterLock implements Lock {
  private volatile int[] level;
  private volatile int[] victim;
  final private int n;

  public FilterLock(int n) {
    level = new int[n];
    victim = new int[n];
    this.n = n;
  }
    
  public void lock(int me) {
    for (int i = 1; i < n; i++) {
      level[me] = i;
      victim[i] = me;
      level = level;
      //System.out.println("Thread " + me + " is waiting for the lock");
      while (sameOrHigher(me, i) && victim[i] == me) { }
      //System.out.println("Thread " + me + " has aquired the lock");
    }
  }
  
  boolean sameOrHigher(int me, int i) {
    for(int k = 0; k < n; k++)
      if (k != me && level[k] >= i) return true;
    return false;
  }
  
  public void unlock(int me) {
    level[me] = 0;
    //System.out.println("Thread " + me + " has released the lock ");
  }
}