package xtc.oop;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

import xtc.lang.JavaFiveParser;
import xtc.lang.JavaEntities;
import xtc.lang.JavaExternalAnalyzer;
import xtc.lang.JavaAstSimplifier;

import xtc.parser.ParseException;
import xtc.parser.Result;

import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.tree.Attribute;
import xtc.util.SymbolTable;


/**
 * A tool to print symbol tables
 *
 * @author Thomas Wies
 */
public class Translator extends xtc.util.Tool {

  /** Create a new tool. */
  public Translator() {
    // Nothing to do.
  }

  {
    // A class-level anonymous scope.
  }

  public interface ICommand {
    public void run();
  }

  public String getName() {
    return "A tool to build a symbol table";
  }

  public String getCopy() {
    return "(C) 2013 Thomas Wies";
  }

  public File locate(String name) throws IOException {
    File file = super.locate(name);
    if (Integer.MAX_VALUE < file.length()) {
      throw new IllegalArgumentException(file + ": file too large");
    }
    return file;
  }

  public Node parse(Reader in, File file) throws IOException, ParseException {
    JavaFiveParser parser =
      new JavaFiveParser(in, file.toString(), (int)file.length());
    Result result = parser.pCompilationUnit(0);
    return (Node)parser.value(result);
  }

  public void process(Node node) {
    SymbolTable table = new SymbolTable();

    // do some simplifications on the AST
    new JavaAstSimplifier().dispatch(node);
    
    // construct the symbol table
    new SymbolTableBuilder(runtime, table).dispatch(node);

    // alternatively, use xtc's functionality to build a symbol table
    //new JavaExternalAnalyzer(runtime, table).dispatch(node);

    // Print the symbol table
    //new SymbolTablePrinter(runtime.console(), table).print();

    // a more convenient way to print the symbol table
    table.current().dump(runtime.console());
    
    // report all occurrences of local variables
    new FindLocals(runtime, table).dispatch(node);

    runtime.console().flush();

  }

  /**
   * Run the tool with the specified command line arguments.
   *
   * @param args The command line arguments.
   */
  public static void main(String[] args) {
    new Translator().run(args);
  }

}
