/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedArrayList<E>
extends ArrayList<E> {
    int[] mLevels = new int[5];
    int mCurscope = -1;

    @Override
    public void clear() {
        this.mLevels = new int[5];
        this.mCurscope = -1;
        super.clear();
    }

    public void beginScope() {
        if (++this.mCurscope == this.mLevels.length) {
            this.mLevels = ScopeUtils.grow(this.mLevels);
        }
        this.mLevels[this.mCurscope] = this.size();
    }

    public void endScope() {
        int oldsize = this.mLevels[this.mCurscope];
        super.removeRange(oldsize, this.size());
        if (ScopeUtils.shouldShrink(--this.mCurscope, this.mLevels.length)) {
            this.mLevels = ScopeUtils.shrink(this.mLevels);
        }
    }

    public int getLastScopeSize() {
        return this.mLevels[this.mCurscope];
    }

    public void addToLevel(E obj, int level) {
        if (level > this.mCurscope) {
            this.add(obj);
        } else {
            int pos = this.mLevels[level];
            this.add(pos, obj);
            for (int i = level; i <= this.mCurscope; ++i) {
                int n = level;
                this.mLevels[n] = this.mLevels[n] + 1;
            }
        }
    }

    public Iterable<E> currentScope() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return ScopedArrayList.this.listIterator(ScopedArrayList.this.mLevels[ScopedArrayList.this.mCurscope]);
            }
        };
    }
}

