/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableInfinitNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfinitNumber
implements Comparable<InfinitNumber> {
    public final Rational mA;
    public final int mEps;
    public static final InfinitNumber POSITIVE_INFINITY = new InfinitNumber(Rational.POSITIVE_INFINITY, 0);
    public static final InfinitNumber NEGATIVE_INFINITY = new InfinitNumber(Rational.NEGATIVE_INFINITY, 0);
    public static final InfinitNumber ZERO = new InfinitNumber(Rational.ZERO, 0);
    public static final InfinitNumber ONE = new InfinitNumber(Rational.ONE, 0);
    public static final InfinitNumber EPSILON = new InfinitNumber(Rational.ZERO, 1);

    public InfinitNumber() {
        this(Rational.ZERO, 0);
    }

    public InfinitNumber(Rational a, int eps) {
        this.mA = a;
        this.mEps = eps;
    }

    static int normEpsilon(int eps) {
        return eps > 0 ? 1 : (eps < 0 ? -1 : 0);
    }

    public InfinitNumber add(InfinitNumber other) {
        return new InfinitNumber(this.mA.add(other.mA), InfinitNumber.normEpsilon(this.mEps + other.mEps));
    }

    public InfinitNumber sub(InfinitNumber other) {
        return new InfinitNumber(this.mA.sub(other.mA), InfinitNumber.normEpsilon(this.mEps - other.mEps));
    }

    public InfinitNumber mul(Rational c) {
        return new InfinitNumber(this.mA.mul(c), this.mEps * c.signum());
    }

    public InfinitNumber div(Rational c) {
        return new InfinitNumber(this.mA.div(c), this.mEps * c.signum());
    }

    public InfinitNumber negate() {
        return new InfinitNumber(this.mA.negate(), -this.mEps);
    }

    public InfinitNumber addmul(InfinitNumber fac1, Rational fac2) {
        return new InfinitNumber(this.mA.addmul(fac1.mA, fac2), InfinitNumber.normEpsilon(this.mEps + fac1.mEps * fac2.signum()));
    }

    public InfinitNumber subdiv(InfinitNumber s, Rational d) {
        return new InfinitNumber(this.mA.subdiv(s.mA, d), InfinitNumber.normEpsilon(this.mEps - s.mEps) * d.signum());
    }

    @Override
    public int compareTo(InfinitNumber arg0) {
        int ac = this.mA.compareTo(arg0.mA);
        if (ac == 0) {
            return this.mEps - arg0.mEps;
        }
        return ac;
    }

    public boolean equals(Object o) {
        if (o instanceof InfinitNumber) {
            InfinitNumber n = (InfinitNumber)o;
            return this.mA.equals(n.mA) && this.mEps == n.mEps;
        }
        if (o instanceof MutableInfinitNumber) {
            return ((MutableInfinitNumber)o).equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.mA.hashCode() + 65537 * this.mEps;
    }

    public boolean less(InfinitNumber other) {
        int ac = this.mA.compareTo(other.mA);
        return ac < 0 || ac == 0 && this.mEps < other.mEps;
    }

    public boolean lesseq(InfinitNumber other) {
        int ac = this.mA.compareTo(other.mA);
        return ac < 0 || ac == 0 && this.mEps <= other.mEps;
    }

    public boolean isInfinity() {
        return this.mA == Rational.POSITIVE_INFINITY || this.mA == Rational.NEGATIVE_INFINITY;
    }

    public String toString() {
        if (this.mEps == 0) {
            return this.mA.toString();
        }
        return this.mA + (this.mEps > 0 ? "+" : "-") + "eps";
    }

    public boolean isIntegral() {
        return this.mA.isIntegral() && this.mEps == 0;
    }

    public InfinitNumber floor() {
        if (!this.mA.isIntegral()) {
            return new InfinitNumber(this.mA.floor(), 0);
        }
        if (this.mEps >= 0) {
            return new InfinitNumber(this.mA, 0);
        }
        return new InfinitNumber(this.mA.sub(Rational.ONE), 0);
    }

    public InfinitNumber ceil() {
        if (!this.mA.isIntegral()) {
            return new InfinitNumber(this.mA.ceil(), 0);
        }
        if (this.mEps <= 0) {
            return new InfinitNumber(this.mA, 0);
        }
        return new InfinitNumber(this.mA.add(Rational.ONE), 0);
    }

    public int signum() {
        return this.mA == Rational.ZERO ? this.mEps : this.mA.signum();
    }

    public InfinitNumber inverse() {
        return new InfinitNumber(this.mA.inverse(), -this.mEps);
    }
}

