/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.Term;

public class InterpolationInfo {
    Term[] mPartitions = new Term[5];
    int[] mStartOfSubTrees = new int[5];
    int mSize = 0;
    boolean mIsAndTerm = false;

    private void grow(int minsize) {
        int newsize = 2 * this.mPartitions.length;
        if (newsize < minsize) {
            newsize = minsize + 1;
        }
        Term[] newPartitions = new Term[newsize];
        int[] newStartOfSubTrees = new int[newsize];
        System.arraycopy(this.mPartitions, 0, newPartitions, 0, this.mSize);
        System.arraycopy(this.mStartOfSubTrees, 0, newStartOfSubTrees, 0, this.mSize);
        this.mPartitions = newPartitions;
        this.mStartOfSubTrees = newStartOfSubTrees;
    }

    public void makeAndTerm() {
        this.mIsAndTerm = true;
    }

    public void addParent(Term partition) {
        if (this.mSize + 1 >= this.mPartitions.length) {
            this.grow(this.mSize + 1);
        }
        this.mPartitions[this.mSize] = partition;
        this.mStartOfSubTrees[this.mSize] = 0;
        ++this.mSize;
    }

    public void addSibling(InterpolationInfo sibling) {
        if (this.mSize + sibling.mSize >= this.mPartitions.length) {
            this.grow(this.mSize + sibling.mSize);
        }
        System.arraycopy(sibling.mPartitions, 0, this.mPartitions, this.mSize, sibling.mSize);
        for (int i = 0; i < sibling.mSize; ++i) {
            this.mStartOfSubTrees[this.mSize + i] = this.mSize + sibling.mStartOfSubTrees[i];
        }
        this.mSize += sibling.mSize;
    }

    public Term[] getPartition() {
        if (this.mPartitions.length != this.mSize) {
            Term[] newPartitions = new Term[this.mSize];
            System.arraycopy(this.mPartitions, 0, newPartitions, 0, this.mSize);
            return newPartitions;
        }
        return this.mPartitions;
    }

    public int[] getTreeStructure() {
        if (this.mStartOfSubTrees.length != this.mSize) {
            int[] newStartOfSubtrees = new int[this.mSize];
            System.arraycopy(this.mStartOfSubTrees, 0, newStartOfSubtrees, 0, this.mSize);
            return newStartOfSubtrees;
        }
        return this.mStartOfSubTrees;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public boolean isAndTerm() {
        return this.mIsAndTerm;
    }

    public boolean isClosedTree() {
        return !this.mIsAndTerm && this.mSize > 0 && this.mStartOfSubTrees[this.mSize - 1] == 0;
    }
}

