/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class Benchmark {
    private final Script mScript;
    private int mFormulaNum;
    private final Map<String, Sort> mSortTranslator;
    private final Map<String, String> mFunNameTranslator;

    public Benchmark(Script solver, boolean disableIPol) {
        this.mScript = solver;
        this.mFormulaNum = disableIPol ? -2 : -1;
        this.mSortTranslator = new HashMap<String, Sort>();
        this.mFunNameTranslator = new HashMap<String, String>();
        this.mScript.setOption(":produce-proofs", true);
    }

    public void setOption(String option, Object value) {
        this.mScript.setOption(option, value);
    }

    public void note(String s) {
        if ("Interpolation Problem starts here".equals(s)) {
            ++this.mFormulaNum;
        }
    }

    private final void mapFuns() {
        this.mFunNameTranslator.put("abs", "abs$");
        this.mFunNameTranslator.put("mod", "mod$");
        this.mFunNameTranslator.put("div", "div$");
    }

    private final void mapArith() {
        this.mFunNameTranslator.put("~", "-");
    }

    private final String translateFunName(String funname) {
        String res = this.mFunNameTranslator.get(funname);
        return res == null ? funname : res;
    }

    public void setLogic(String logic) {
        Logics l = Logics.valueOf(logic);
        this.mScript.setLogic(l);
        switch (l) {
            case QF_AX: {
                this.mScript.declareSort("Index", 0);
                this.mScript.declareSort("Element", 0);
                this.mSortTranslator.put("Array", this.mScript.sort("Array", this.mScript.sort("Index", new Sort[0]), this.mScript.sort("Element", new Sort[0])));
                break;
            }
            case AUFLIRA: 
            case AUFNIRA: {
                Sort array1 = this.mScript.sort("Array", this.mScript.sort("Int", new Sort[0]), this.mScript.sort("Real", new Sort[0]));
                this.mSortTranslator.put("Array1", array1);
                this.mSortTranslator.put("Array2", this.mScript.sort("Array", this.mScript.sort("Int", new Sort[0]), array1));
                this.mapFuns();
                this.mapArith();
                break;
            }
            case QF_AUFLIA: 
            case AUFLIA: {
                this.mSortTranslator.put("Array", this.mScript.sort("Array", this.mScript.sort("Int", new Sort[0]), this.mScript.sort("Real", new Sort[0])));
            }
            case QF_UFLIA: 
            case QF_UFLRA: {
                this.mapFuns();
                this.mapArith();
                break;
            }
            case QF_UF: {
                this.mScript.declareSort("U", 0);
                break;
            }
            case LRA: 
            case QF_LIA: 
            case QF_LRA: 
            case QF_RDL: 
            case QF_IDL: {
                this.mapArith();
                break;
            }
        }
    }

    public void setInfo(String info, String value) {
        this.mScript.setInfo(info, value);
    }

    public void declareSort(String name) {
        this.mScript.declareSort(name, 0);
    }

    public void declareFun(String name, Sort[] paramSorts, Sort resultSort) {
        this.mScript.declareFun(this.translateFunName(name), paramSorts, resultSort);
    }

    public Term term(String name, Term ... params) {
        return this.mScript.term(this.translateFunName(name), params);
    }

    public Term annotateTerm(Term t, Annotation ... annots) {
        if (annots.length > 0) {
            t = this.mScript.annotate(t, annots);
        }
        return t;
    }

    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) {
        return this.mScript.quantifier(quantor, vars, body, patterns);
    }

    public Term let(TermVariable var, Term value, Term body) {
        return this.mScript.let(new TermVariable[]{var}, new Term[]{value}, body);
    }

    public Sort sort(String name) {
        Sort res = this.mSortTranslator.get(name);
        if (res != null) {
            return res;
        }
        return this.mScript.sort(name, new Sort[0]);
    }

    public TermVariable variable(String name, Sort sort) {
        return this.mScript.variable(name, sort);
    }

    public Sort getBooleanSort() {
        return this.mScript.sort("Bool", new Sort[0]);
    }

    public void assertTerm(Term t) {
        if (this.mFormulaNum >= 0) {
            t = this.mScript.annotate(t, new Annotation(":named", "IP_" + this.mFormulaNum++));
        }
        this.mScript.assertTerm(t);
    }

    public Term numeral(String num) {
        return this.mScript.numeral(num);
    }

    public Term decimal(String decimal) {
        return this.mScript.decimal(decimal);
    }

    public Term[] check() {
        Script.LBool res = this.mScript.checkSat();
        if (!(this.mScript instanceof LoggingScript)) {
            System.out.println((Object)res);
        }
        if (this.mFormulaNum > 1) {
            Term[] partition = new Term[this.mFormulaNum];
            for (int i = 0; i < this.mFormulaNum; ++i) {
                partition[i] = this.mScript.term("IP_" + i, new Term[0]);
            }
            return this.mScript.getInterpolants(partition);
        }
        return null;
    }

    public void close() {
        this.mScript.exit();
    }

    public void getProof() {
        this.mScript.getProof();
    }
}

